/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.EditWhereCols;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class EditWhereColsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditWhereColsPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(EditWhereColsPanel.class);
    private String _tableName;
    private String _unambiguousTableName;
    private SortedSet<String> _columnList;
    private JList useColsList;
    private JList notUseColsList;
    private Object[] initalUseColsArray;
    private Object[] initalNotUseColsArray;
    private ISession _session = null;
    private PrimaryKeyInfo[] primaryKeyInfos = null;
    EditWhereCols _editWhereCols = new EditWhereCols();

    public EditWhereColsPanel(ISession session, ITableInfo ti, SortedSet<String> columnList, String unambiguousTableName) throws IllegalArgumentException {
        this._session = session;
        this._editWhereCols.setApplication(session.getApplication());
        this.getPrimaryKey(ti);
        this._columnList = columnList;
        this._tableName = ti.getQualifiedName();
        this._unambiguousTableName = unambiguousTableName;
        HashMap<String, String> colsTable = EditWhereCols.get(unambiguousTableName);
        if (colsTable == null) {
            this.initalUseColsArray = this._columnList.toArray();
            this.initalNotUseColsArray = new Object[0];
        } else {
            TreeSet initialUseColsSet = new TreeSet();
            TreeSet initialNotUseColsList = new TreeSet();
            for (Object e : this._columnList) {
                if (colsTable.get(e) != null) {
                    initialUseColsSet.add(e);
                    continue;
                }
                initialNotUseColsList.add(e);
            }
            this.initalUseColsArray = initialUseColsSet.toArray();
            this.initalNotUseColsArray = initialNotUseColsList.toArray();
        }
        this.createGUI();
    }

    private void getPrimaryKey(ITableInfo ti) {
        try {
            this.primaryKeyInfos = this._session.getMetaData().getPrimaryKey(ti);
        }
        catch (SQLException e) {
            s_log.error("Unexpected exception while attempting to get primary key info for table " + ti.getQualifiedName() + ": " + e.getMessage(), e);
        }
    }

    public String getTitle() {
        return EditWhereColsPanelI18N.TITLE;
    }

    public String getHint() {
        return EditWhereColsPanelI18N.HINT;
    }

    public void reset() {
        this.useColsList.setListData(this.initalUseColsArray);
        this.notUseColsList.setListData(this.initalNotUseColsArray);
    }

    public boolean ok() {
        if (this.notUseColsList.getModel().getSize() == 0) {
            this._editWhereCols.put(this._unambiguousTableName, null);
        } else {
            ListModel useColsModel = this.useColsList.getModel();
            if (useColsModel.getSize() == 0) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("editWhereColsPanel.cannotRemoveAllCols"));
                return false;
            }
            HashMap<String, String> useColsMap = new HashMap<String, String>(useColsModel.getSize());
            for (int i = 0; i < useColsModel.getSize(); ++i) {
                useColsMap.put((String)useColsModel.getElementAt(i), (String)useColsModel.getElementAt(i));
            }
            this._editWhereCols.put(this._unambiguousTableName, useColsMap);
        }
        return true;
    }

    private void moveToNotUsed() {
        ListModel notUseColsModel = this.notUseColsList.getModel();
        TreeSet<String> notUseColsSet = new TreeSet<String>();
        for (int i = 0; i < notUseColsModel.getSize(); ++i) {
            notUseColsSet.add((String)notUseColsModel.getElementAt(i));
        }
        ListModel useColsModel = this.useColsList.getModel();
        TreeSet<String> useColsSet = new TreeSet<String>();
        for (int i = 0; i < useColsModel.getSize(); ++i) {
            String colName = (String)useColsModel.getElementAt(i);
            if (this.useColsList.isSelectedIndex(i)) {
                notUseColsSet.add(colName);
                continue;
            }
            useColsSet.add(colName);
        }
        this.useColsList.setListData(useColsSet.toArray());
        this.notUseColsList.setListData(notUseColsSet.toArray());
    }

    private void moveToUsed() {
        ListModel useColsModel = this.useColsList.getModel();
        TreeSet<String> useColsSet = new TreeSet<String>();
        for (int i = 0; i < useColsModel.getSize(); ++i) {
            useColsSet.add((String)useColsModel.getElementAt(i));
        }
        ListModel notUseColsModel = this.notUseColsList.getModel();
        TreeSet<String> notUseColsSet = new TreeSet<String>();
        for (int i = 0; i < notUseColsModel.getSize(); ++i) {
            String colName = (String)notUseColsModel.getElementAt(i);
            if (this.notUseColsList.isSelectedIndex(i)) {
                useColsSet.add(colName);
                continue;
            }
            notUseColsSet.add(colName);
        }
        this.useColsList.setListData(useColsSet.toArray());
        this.notUseColsList.setListData(notUseColsSet.toArray());
    }

    private void usePK() {
        Object colName;
        int i;
        if (this.primaryKeyInfos == null || this.primaryKeyInfos.length <= 0) {
            String msg = s_stringMgr.getString("editWhereColsPanel.noPK", this._tableName);
            JOptionPane.showMessageDialog(this, msg);
            return;
        }
        HashSet<String> pkCols = new HashSet<String>();
        for (int i2 = 0; i2 < this.primaryKeyInfos.length; ++i2) {
            PrimaryKeyInfo pkInfo = this.primaryKeyInfos[i2];
            pkCols.add(pkInfo.getColumnName());
        }
        ArrayList<String> newNotUseList = new ArrayList<String>();
        ListModel useColsModel = this.useColsList.getModel();
        ListModel notUseColsModel = this.notUseColsList.getModel();
        for (i = 0; i < useColsModel.getSize(); ++i) {
            colName = useColsModel.getElementAt(i);
            if (pkCols.contains(colName)) continue;
            newNotUseList.add(colName.toString());
        }
        for (i = 0; i < notUseColsModel.getSize(); ++i) {
            colName = notUseColsModel.getElementAt(i);
            if (pkCols.contains(colName)) continue;
            newNotUseList.add(colName.toString());
        }
        this.useColsList.setListData(pkCols.toArray());
        this.notUseColsList.setListData(newNotUseList.toArray());
    }

    private void createGUI() {
        JPanel useColsPanel = new JPanel(new BorderLayout());
        useColsPanel.add((Component)new JLabel(s_stringMgr.getString("editWhereColsPanel.useColumns")), "North");
        this.useColsList = new JList<Object>(this.initalUseColsArray);
        JScrollPane scrollPane = new JScrollPane(this.useColsList);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        useColsPanel.add((Component)scrollPane, "South");
        this.add(useColsPanel);
        JPanel moveButtonsPanel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(3, 1));
        JButton moveToNotUsedButton = new JButton("=>");
        moveToNotUsedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWhereColsPanel.this.moveToNotUsed();
            }
        });
        buttonPanel.add(moveToNotUsedButton);
        JButton moveToUsedButton = new JButton("<=");
        moveToUsedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWhereColsPanel.this.moveToUsed();
            }
        });
        buttonPanel.add(moveToUsedButton);
        JButton usePKButton = new JButton(EditWhereColsPanelI18N.USE_PK);
        usePKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWhereColsPanel.this.usePK();
            }
        });
        buttonPanel.add(usePKButton);
        moveButtonsPanel.add((Component)buttonPanel, "Center");
        this.add(moveButtonsPanel);
        JPanel notUseColsPanel = new JPanel(new BorderLayout());
        notUseColsPanel.add((Component)new JLabel(s_stringMgr.getString("editWhereColsPanel.notUseColumns")), "North");
        this.notUseColsList = new JList<Object>(this.initalNotUseColsArray);
        JScrollPane notUseScrollPane = new JScrollPane(this.notUseColsList);
        notUseScrollPane.setPreferredSize(new Dimension(200, 200));
        notUseColsPanel.add((Component)notUseScrollPane, "South");
        this.add(notUseColsPanel);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface EditWhereColsPanelI18N {
        public static final String TITLE = EditWhereColsPanel.access$000().getString("editWhereColsPanel.limitColsInCell");
        public static final String HINT = EditWhereColsPanel.access$000().getString("editWhereColsPanel.limitColsInCellHint");
        public static final String USE_PK = EditWhereColsPanel.access$000().getString("editWhereColsPanel.usePKLabel");
    }
}

