/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class FilterMatcher {
    private String _sqlOrMetaDataMatchString;
    private ArrayList<Pattern> _includeFilterPatterns = new ArrayList();
    private ArrayList<Pattern> _excludeFilterPatterns = new ArrayList();

    public FilterMatcher(String filterInclude, String filterExclude) {
        String regExStr;
        int i;
        String[] splits;
        if (null != filterInclude) {
            splits = filterInclude.split(",");
            for (i = 0; i < splits.length; ++i) {
                if (0 >= splits[i].trim().length()) continue;
                regExStr = splits[i].replaceAll("\\.", "\\\\.").replaceAll("%", ".*").replaceAll("_", ".{1}");
                this._includeFilterPatterns.add(Pattern.compile(regExStr, 2));
                if (1 != this._includeFilterPatterns.size()) continue;
                this._sqlOrMetaDataMatchString = splits[i];
            }
        }
        if (null != filterExclude) {
            splits = filterExclude.split(",");
            for (i = 0; i < splits.length; ++i) {
                if (0 >= splits[i].trim().length()) continue;
                regExStr = splits[i].replaceAll("\\.", "\\\\.").replaceAll("%", ".*").replaceAll("_", ".{1}");
                this._excludeFilterPatterns.add(Pattern.compile(regExStr, 2));
            }
        }
    }

    public boolean matches(String simpleObjectName) {
        return this.matchesPatterns(simpleObjectName, this._includeFilterPatterns, false) && !this.matchesPatterns(simpleObjectName, this._excludeFilterPatterns, true);
    }

    private boolean matchesPatterns(String simpleObjectName, ArrayList<Pattern> patterns, boolean exclude) {
        boolean matchesPatterns = exclude ? false : 0 == patterns.size();
        for (Pattern includeFilterPattern : patterns) {
            if (!includeFilterPattern.matcher(simpleObjectName).matches()) continue;
            matchesPatterns = true;
            break;
        }
        return matchesPatterns;
    }

    public String getMetaDataMatchString() {
        return this._sqlOrMetaDataMatchString;
    }

    public String getSqlLikeMatchString() {
        if (null != this._sqlOrMetaDataMatchString) {
            return this._sqlOrMetaDataMatchString;
        }
        return "%";
    }

    public static void main(String[] args) {
        boolean b = new FilterMatcher("Geer%", null).matches("Gerhard");
        System.out.println(b);
    }
}

