/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.ejb.access.AbstractRemoteSlsbInvokerInterceptor;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;

public class SimpleRemoteSlsbInvokerInterceptor
extends AbstractRemoteSlsbInvokerInterceptor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        EJBObject ejb = null;
        try {
            try {
                ejb = this.getSessionBeanInstance();
                Object object = RmiClientInterceptorUtils.doInvoke(invocation, (Remote)ejb);
                Object var7_6 = null;
                if (ejb == null) return object;
                this.releaseSessionBeanInstance(ejb);
                return object;
            }
            catch (NamingException ex) {
                throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable targetEx = ex.getTargetException();
                if (targetEx instanceof RemoteException) {
                    RemoteException rex = (RemoteException)targetEx;
                    throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, this.isConnectFailure(rex), this.getJndiName());
                }
                if (!(targetEx instanceof CreateException)) throw targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), targetEx, "Could not create remote EJB [" + this.getJndiName() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ejb == null) throw throwable;
            this.releaseSessionBeanInstance(ejb);
            throw throwable;
        }
    }

    protected EJBObject getSessionBeanInstance() throws NamingException, InvocationTargetException {
        return this.newSessionBeanInstance();
    }

    protected void releaseSessionBeanInstance(EJBObject ejb) {
        this.removeSessionBeanInstance(ejb);
    }
}

