/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class GraphiteDefaultTheme
extends AbstractTheme {
    public GraphiteDefaultTheme() {
        this.setUpColor();
        this.loadProperties();
        this.setUpColorArrs();
    }

    public String getPropertyFileName() {
        return "GraphiteTheme.properties";
    }

    public void setUpColor() {
        super.setUpColor();
        foregroundColor = black;
        backgroundColor = new ColorUIResource(224, 224, 224);
        backgroundColorLight = white;
        backgroundColorDark = lightGray;
        alterBackgroundColor = new ColorUIResource(220, 220, 220);
        disabledForegroundColor = new ColorUIResource(128, 128, 128);
        disabledBackgroundColor = new ColorUIResource(240, 240, 240);
        inputBackgroundColor = white;
        inputForegroundColor = black;
        selectionForegroundColor = white;
        selectionBackgroundColor = new ColorUIResource(80, 80, 80);
        selectionBackgroundColorLight = new ColorUIResource(96, 96, 96);
        selectionBackgroundColorDark = new ColorUIResource(64, 64, 64);
        focusColor = orange;
        focusCellColor = orange;
        frameColor = new ColorUIResource(144, 144, 144);
        gridColor = new ColorUIResource(200, 200, 200);
        rolloverColor = orange;
        rolloverColorLight = new ColorUIResource(255, 213, 113);
        rolloverColorDark = new ColorUIResource(240, 168, 0);
        buttonForegroundColor = black;
        buttonBackgroundColor = extraLightGray;
        buttonColorLight = white;
        buttonColorDark = extraLightGray;
        controlForegroundColor = black;
        controlBackgroundColor = extraLightGray;
        controlShadowColor = new ColorUIResource(164, 164, 164);
        controlDarkShadowColor = new ColorUIResource(64, 64, 64);
        controlColorLight = new ColorUIResource(96, 96, 96);
        controlColorDark = new ColorUIResource(40, 40, 40);
        windowTitleForegroundColor = white;
        windowTitleBackgroundColor = new ColorUIResource(88, 88, 88);
        windowTitleColorLight = new ColorUIResource(88, 88, 88);
        windowTitleColorDark = new ColorUIResource(24, 24, 24);
        windowBorderColor = black;
        windowIconColor = white;
        windowIconShadowColor = black;
        windowIconRolloverColor = orange;
        windowInactiveTitleForegroundColor = white;
        windowInactiveTitleBackgroundColor = new ColorUIResource(224, 224, 224);
        windowInactiveTitleColorLight = new ColorUIResource(64, 64, 64);
        windowInactiveTitleColorDark = new ColorUIResource(0, 0, 0);
        windowInactiveBorderColor = black;
        menuForegroundColor = black;
        menuBackgroundColor = new ColorUIResource(240, 240, 240);
        menuSelectionForegroundColor = black;
        menuSelectionBackgroundColor = new ColorUIResource(32, 32, 32);
        menuSelectionBackgroundColorLight = new ColorUIResource(255, 213, 113);
        menuSelectionBackgroundColorDark = new ColorUIResource(240, 168, 0);
        menuColorLight = new ColorUIResource(240, 240, 240);
        menuColorDark = new ColorUIResource(220, 220, 220);
        toolbarForegroundColor = black;
        toolbarBackgroundColor = backgroundColor;
        toolbarColorLight = menuColorLight;
        toolbarColorDark = menuColorDark;
        tabAreaBackgroundColor = backgroundColor;
        tabSelectionForegroundColor = white;
        desktopColor = backgroundColor;
        tooltipForegroundColor = black;
        tooltipBackgroundColor = yellow;
        controlFont = new FontUIResource("Dialog", 0, 13);
        systemFont = new FontUIResource("Dialog", 0, 13);
        userFont = new FontUIResource("Dialog", 0, 13);
        smallFont = new FontUIResource("Dialog", 0, 12);
        menuFont = new FontUIResource("Dialog", 0, 13);
        windowTitleFont = new FontUIResource("Dialog", 1, 13);
    }

    public void setUpColorArrs() {
        super.setUpColorArrs();
        BUTTON_COLORS = ColorHelper.createColorArr(buttonColorLight, buttonColorDark, 24);
        CHECKBOX_COLORS = BUTTON_COLORS;
        DEFAULT_COLORS = ColorHelper.createColorArr(controlColorLight, controlColorDark, 24);
        HIDEFAULT_COLORS = new Color[20];
        for (int i = 0; i < 20; ++i) {
            GraphiteDefaultTheme.HIDEFAULT_COLORS[i] = ColorHelper.brighter(DEFAULT_COLORS[i], 40.0);
        }
        SELECTED_COLORS = DEFAULT_COLORS;
        SELECTION_COLORS = ColorHelper.createColorArr(selectionBackgroundColorLight, selectionBackgroundColorDark, 20);
        MENU_SELECTION_COLORS = ColorHelper.createColorArr(menuSelectionBackgroundColorLight, menuSelectionBackgroundColorDark, 20);
        ROLLOVER_COLORS = ColorHelper.createColorArr(rolloverColorLight, rolloverColorDark, 24);
        PRESSED_COLORS = ColorHelper.createColorArr(menuColorDark, menuColorLight, 24);
        DISABLED_COLORS = ColorHelper.createColorArr(superLightGray, extraLightGray, 24);
        ACTIVE_COLORS = DEFAULT_COLORS;
        INACTIVE_COLORS = BUTTON_COLORS;
        WINDOW_TITLE_COLORS = ColorHelper.createColorArr(windowTitleColorLight, windowTitleColorDark, 24);
        WINDOW_INACTIVE_TITLE_COLORS = ColorHelper.createColorArr(windowInactiveTitleColorLight, windowInactiveTitleColorDark, 24);
        TOOLBAR_COLORS = ColorHelper.createColorArr(toolbarColorLight, toolbarColorDark, 24);
        MENUBAR_COLORS = ColorHelper.createColorArr(menuColorLight, menuColorDark, 24);
        TAB_COLORS = BUTTON_COLORS;
        COL_HEADER_COLORS = BUTTON_COLORS;
        ColorUIResource hiColor = backgroundColorLight;
        Color loColor = ColorHelper.darker(backgroundColor, 4.0);
        TRACK_COLORS = ColorHelper.createColorArr(loColor, hiColor, 24);
        if ("true".equals(System.getProperty("graphiteBrightThumb"))) {
            hiColor = backgroundColorDark;
            loColor = ColorHelper.darker(backgroundColorDark, 10.0);
            THUMB_COLORS = ColorHelper.createColorArr(hiColor, loColor, 24);
        } else {
            THUMB_COLORS = DEFAULT_COLORS;
        }
        SLIDER_COLORS = DEFAULT_COLORS;
        PROGRESSBAR_COLORS = DEFAULT_COLORS;
    }
}

