/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.TableCellRenderer;
import org.fife.ui.FileExplorerTableModel;

public class UIUtil {
    private static boolean desktopCreationAttempted;
    private static Object desktop;
    private static final Object LOCK_DESKTOP_CREATION;
    private static int nonOpaqueTabbedPaneComponents;
    private static final Color LIGHT_HYPERLINK_FG;
    private static final Border EMPTY_5_BORDER;
    private static final int DEFAULT_BUTTON_SIZE = 85;

    private UIUtil() {
    }

    public static boolean browse(String uri) {
        if (uri == null) {
            return false;
        }
        try {
            return UIUtil.browse(new URI(uri));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean browse(URI uri) {
        Object desktop;
        boolean success = false;
        if (uri != null && (desktop = UIUtil.getDesktop()) != null) {
            try {
                Method m = desktop.getClass().getDeclaredMethod("browse", URI.class);
                m.invoke(desktop, uri);
                success = true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public static final Container createButtonFooter(JButton ok, JButton cancel) {
        return UIUtil.createButtonFooter(ok, cancel, -1);
    }

    public static final Container createButtonFooter(JButton ok, JButton cancel, int topPadding) {
        JPanel temp = new JPanel(new GridLayout(1, 2, 5, 5));
        temp.add(ok);
        temp.add(cancel);
        Dimension prefSize = ok.getPreferredSize();
        if (prefSize.width < 85) {
            UIUtil.ensureDefaultButtonWidth(cancel);
        }
        return UIUtil.createButtonFooter(temp, topPadding);
    }

    public static final Container createButtonFooter(Container buttons) {
        return UIUtil.createButtonFooter(buttons, -1);
    }

    public static final Container createButtonFooter(Container buttons, int topPadding) {
        return UIUtil.createButtonFooter(buttons, topPadding, -1);
    }

    public static final Container createButtonFooter(Container buttons, int topPadding, int sidePadding) {
        if (topPadding < 0) {
            topPadding = 10;
        }
        if (sidePadding < 0) {
            sidePadding = 8;
        }
        if (buttons instanceof JButton) {
            JButton button = (JButton)buttons;
            Dimension preferredSize = button.getPreferredSize();
            if (preferredSize.width < 85) {
                preferredSize.width = 85;
                button.setPreferredSize(preferredSize);
            }
        }
        JPanel panel = new JPanel(new BorderLayout());
        ComponentOrientation o = buttons.getComponentOrientation();
        int left = o.isLeftToRight() ? 0 : sidePadding;
        int right = o.isLeftToRight() ? sidePadding : 0;
        panel.setBorder(BorderFactory.createEmptyBorder(topPadding, left, 0, right));
        panel.add((Component)buttons, "After");
        return panel;
    }

    public static final Color deriveColor(Color orig, int darker) {
        int red = orig.getRed() - darker;
        int green = orig.getGreen() - darker;
        int blue = orig.getBlue() - darker;
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue);
    }

    public static final void ensureButtonWidth(JButton button, int width) {
        Dimension prefSize = button.getPreferredSize();
        if (prefSize.width < width) {
            prefSize.width = width;
            button.setPreferredSize(prefSize);
        }
    }

    public static final void ensureDefaultButtonWidth(JButton button) {
        UIUtil.ensureButtonWidth(button, 85);
    }

    public static void expandAllNodes(JTree tree) {
        int j = 0;
        while (j < tree.getRowCount()) {
            tree.expandRow(j++);
        }
    }

    public static void fixComboOrientation(JComboBox combo) {
        ListCellRenderer r = combo.getRenderer();
        if (r instanceof Component) {
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            ((Component)((Object)r)).setComponentOrientation(o);
        }
    }

    public static void fixJTableRendererOrientations(JTable table) {
        Component c;
        ComponentOrientation o = ComponentOrientation.getOrientation(table.getLocale());
        TableCellRenderer r = table.getDefaultRenderer(Object.class);
        if (r instanceof Component) {
            c = (Component)((Object)r);
            c.setComponentOrientation(o);
        }
        if ((r = table.getDefaultRenderer(Number.class)) instanceof Component) {
            c = (Component)((Object)r);
            c.setComponentOrientation(o);
        }
        if ((r = table.getDefaultRenderer(Boolean.class)) instanceof Component) {
            c = (Component)((Object)r);
            c.setComponentOrientation(o);
        }
        if (table.getTableHeader() != null) {
            r = table.getTableHeader().getDefaultRenderer();
            if (r instanceof Component) {
                ((Component)((Object)r)).applyComponentOrientation(o);
            } else if (r instanceof FileExplorerTableModel.SortableHeaderRenderer && (r = ((FileExplorerTableModel.SortableHeaderRenderer)r).getDelegateRenderer()) instanceof Component) {
                ((Component)((Object)r)).applyComponentOrientation(o);
            }
        }
    }

    private static final SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                try {
                    Class<?> desktopClazz = Class.forName("java.awt.Desktop");
                    Method m = desktopClazz.getDeclaredMethod("isDesktopSupported", null);
                    boolean supported = (Boolean)m.invoke(null, null);
                    if (supported) {
                        m = desktopClazz.getDeclaredMethod("getDesktop", null);
                        desktop = m.invoke(null, null);
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return desktop;
    }

    public static Border getEmpty5Border() {
        return EMPTY_5_BORDER;
    }

    public static final String getHTMLFormatForColor(Color color) {
        if (color == null) {
            return "#000000";
        }
        StringBuffer sb = new StringBuffer("#");
        int r = color.getRed();
        if (r < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(r));
        int g = color.getGreen();
        if (g < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(g));
        int b = color.getBlue();
        if (b < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b));
        return sb.toString();
    }

    public static final Color getHyperlinkForeground() {
        Color fg = UIManager.getColor("Label.foreground");
        if (fg == null) {
            fg = new JLabel().getForeground();
        }
        return UIUtil.isLightForeground(fg) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static final int getMnemonic(ResourceBundle msg, String key) {
        int mnemonic = 0;
        try {
            Object value = msg.getObject(key);
            if (value instanceof String) {
                mnemonic = ((String)value).charAt(0);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return mnemonic;
    }

    public static String getPrettyStringFor(KeyStroke keyStroke) {
        int keyCode;
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if (string != null && string.length() > 0) {
            string = string + "+";
        }
        if ((keyCode = keyStroke.getKeyCode()) != 16 && keyCode != 17 && keyCode != 18 && keyCode != 157) {
            string = string + KeyEvent.getKeyText(keyCode);
        }
        return string;
    }

    static synchronized boolean getUseNonOpaqueTabbedPaneComponents() {
        if (nonOpaqueTabbedPaneComponents == -1) {
            String osname = System.getProperty("os.name");
            if (osname.toLowerCase().indexOf("windows") > -1) {
                String osver = System.getProperty("os.version");
                boolean isXPorVista = osver.startsWith("5.1") || osver.startsWith("6.0");
                nonOpaqueTabbedPaneComponents = isXPorVista ? 1 : 0;
            } else {
                nonOpaqueTabbedPaneComponents = 0;
            }
        }
        return nonOpaqueTabbedPaneComponents == 1;
    }

    public static void installOsSpecificLafTweaks() {
        String lafName = UIManager.getLookAndFeel().getName();
        String os = System.getProperty("os.name");
        if ("Windows XP".equals(os) && "Windows".equals(lafName)) {
            Border insetsBorder = BorderFactory.createEmptyBorder(2, 3, 2, 3);
            String key = "PopupMenu.border";
            Border origBorder = UIManager.getBorder(key);
            BorderUIResource.CompoundBorderUIResource res = new BorderUIResource.CompoundBorderUIResource(origBorder, insetsBorder);
            UIManager.getLookAndFeelDefaults().put(key, res);
        }
    }

    private static final boolean isLightForeground(Color fg) {
        return fg.getRed() > 160 && fg.getGreen() > 160 && fg.getBlue() > 160;
    }

    public static final void makeSpringCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException cce) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, UIUtil.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = UIUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, UIUtil.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = UIUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private static final String mnemonicKey(String key) {
        return key + ".Mnemonic";
    }

    public static final JCheckBox newCheckBox(ResourceBundle bundle, String key) {
        JCheckBox cb = new JCheckBox(bundle.getString(key));
        cb.setMnemonic(UIUtil.getMnemonic(bundle, UIUtil.mnemonicKey(key)));
        return cb;
    }

    public static final JButton newButton(ResourceBundle bundle, String key) {
        return UIUtil.newButton(bundle, key, UIUtil.mnemonicKey(key));
    }

    public static final JButton newButton(ResourceBundle bundle, String key, ActionListener listener) {
        return UIUtil.newButton(bundle, key, UIUtil.mnemonicKey(key), listener);
    }

    public static final JButton newButton(ResourceBundle bundle, String textKey, String mnemonicKey) {
        return UIUtil.newButton(bundle, textKey, mnemonicKey, null);
    }

    public static final JButton newButton(ResourceBundle bundle, String textKey, String mnemonicKey, ActionListener listener) {
        JButton b = new JButton(bundle.getString(textKey));
        b.setMnemonic(UIUtil.getMnemonic(bundle, mnemonicKey));
        if (listener != null) {
            b.addActionListener(listener);
        }
        return b;
    }

    public static final JLabel newLabel(ResourceBundle msg, String key) {
        return UIUtil.newLabel(msg, key, null);
    }

    public static final JLabel newLabel(ResourceBundle msg, String key, Component labelFor) {
        JLabel label = new JLabel(msg.getString(key));
        label.setDisplayedMnemonic(UIUtil.getMnemonic(msg, UIUtil.mnemonicKey(key)));
        if (labelFor != null) {
            label.setLabelFor(labelFor);
        }
        return label;
    }

    public static final JRadioButton newRadio(ResourceBundle msg, String keyRoot, ButtonGroup bg) {
        return UIUtil.newRadio(msg, keyRoot, bg, null, false);
    }

    public static final JRadioButton newRadio(ResourceBundle msg, String keyRoot, ButtonGroup bg, ActionListener listener) {
        return UIUtil.newRadio(msg, keyRoot, bg, listener, false);
    }

    public static final JRadioButton newRadio(ResourceBundle msg, String keyRoot, ButtonGroup bg, ActionListener listener, boolean selected) {
        JRadioButton radio = new JRadioButton(msg.getString(keyRoot));
        radio.setMnemonic(UIUtil.getMnemonic(msg, UIUtil.mnemonicKey(keyRoot)));
        if (bg != null) {
            bg.add(radio);
        }
        if (listener != null) {
            radio.addActionListener(listener);
        }
        radio.setSelected(selected);
        return radio;
    }

    public static JButton newTabbedPaneButton(String text) {
        JButton button = new JButton(text);
        if (UIUtil.getUseNonOpaqueTabbedPaneComponents()) {
            button.setOpaque(false);
        }
        return button;
    }

    public static JPanel newTabbedPanePanel() {
        JPanel panel = new JPanel();
        if (UIUtil.getUseNonOpaqueTabbedPaneComponents()) {
            panel.setOpaque(false);
        }
        return panel;
    }

    public static JPanel newTabbedPanePanel(LayoutManager layout) {
        JPanel panel = new JPanel(layout);
        if (UIUtil.getUseNonOpaqueTabbedPaneComponents()) {
            panel.setOpaque(false);
        }
        return panel;
    }

    public static void possiblyFixGridColor(JTable table) {
        Color gridColor;
        String laf = UIManager.getLookAndFeel().getClass().getName();
        if (laf.endsWith("WindowsLookAndFeel") && Color.white.equals(table.getBackground()) && (gridColor = table.getGridColor()) != null && gridColor.getRGB() <= 0x808080) {
            table.setGridColor(new Color(0xE3E3E3));
        }
    }

    public static void setDescription(JComponent comp, ResourceBundle msg, String key) {
        comp.getAccessibleContext().setAccessibleDescription(msg.getString(key));
    }

    public static Map setNativeRenderingHints(Graphics2D g2d) {
        RenderingHints old = g2d.getRenderingHints();
        Map hints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (hints != null) {
            g2d.addRenderingHints(hints);
        }
        return old;
    }

    static {
        LOCK_DESKTOP_CREATION = new Object();
        nonOpaqueTabbedPaneComponents = -1;
        LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
        EMPTY_5_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }
}

