/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.settings.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.FilterRule;
import org.jmeld.util.conf.AbstractConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class Filter
extends AbstractConfigurationElement {
    @XmlAttribute
    private Boolean includeDefault;
    @XmlAttribute
    private String name;
    @XmlElement
    private List<FilterRule> rules = new ArrayList<FilterRule>();

    public Filter(String name) {
        this.setName(name);
    }

    public Filter() {
    }

    public void init(JMeldSettings root) {
        super.init(root);
        for (FilterRule rule : this.rules) {
            rule.init(root);
        }
    }

    public boolean isDefault() {
        return "default".equals(this.name);
    }

    public void setName(String name) {
        this.name = name;
        this.fireChanged();
    }

    public String getName() {
        return this.name;
    }

    public void insertRule(FilterRule ruleToInsertAfter, FilterRule rule) {
        rule.init(this.configuration);
        int index = this.rules.indexOf(ruleToInsertAfter);
        if (index != -1) {
            this.rules.add(index + 1, rule);
        } else {
            this.rules.add(rule);
        }
        this.fireChanged();
    }

    public void addRule(FilterRule rule) {
        rule.init(this.configuration);
        this.rules.add(rule);
        this.fireChanged();
    }

    public void removeRule(FilterRule rule) {
        this.rules.remove(rule);
        this.fireChanged();
    }

    public List<FilterRule> getRules() {
        return this.rules;
    }

    public List<String> getExcludes() {
        return this.getPatterns(FilterRule.Rule.excludes);
    }

    public List<String> getIncludes() {
        return this.getPatterns(FilterRule.Rule.includes);
    }

    private List<String> getPatterns(FilterRule.Rule r) {
        ArrayList<String> result = new ArrayList<String>();
        for (FilterRule rule : new GetRules().getRules()) {
            if (rule.getRule() != r) continue;
            result.add(rule.getPattern());
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetRules {
        HashSet<FilterRule> result = new HashSet();
        HashSet<Filter> evaluatedFilters = new HashSet();

        GetRules() {
        }

        List<FilterRule> getRules() {
            this.collectRules(Filter.this);
            return new ArrayList<FilterRule>(this.result);
        }

        void collectRules(Filter filter) {
            this.evaluatedFilters.add(filter);
            for (FilterRule rule : filter.getRules()) {
                Filter nextFilter;
                if (this.result.contains(rule) || !rule.isActive()) continue;
                if (rule.getRule() == FilterRule.Rule.importFilter && (nextFilter = JMeldSettings.getInstance().getFilter().getFilter(rule.getPattern())) != null && !this.evaluatedFilters.contains(nextFilter)) {
                    this.collectRules(nextFilter);
                }
                this.result.add(rule);
            }
        }
    }
}

