/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.settings;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.StatusBar;
import org.jmeld.ui.settings.SaveSettingsDialog;
import org.jmeld.ui.settings.SettingCellRenderer;
import org.jmeld.ui.settings.Settings;
import org.jmeld.ui.settings.SettingsPanelForm;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.conf.ConfigurationManager;
import org.jmeld.util.prefs.FileChooserPreference;

public class SettingsPanel
extends SettingsPanelForm
implements ConfigurationListenerIF {
    private DefaultListModel listModel;
    private JMeldPanel mainPanel;

    public SettingsPanel(JMeldPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.init();
        this.initConfiguration();
        this.getConfiguration().addConfigurationListener(this);
    }

    private void init() {
        this.settingsPanel.setLayout(new CardLayout());
        for (Settings setting : Settings.values()) {
            this.settingsPanel.add((Component)setting.getPanel(), setting.getName());
        }
        this.initButton(this.saveButton, "stock_save", "Save settings");
        this.saveButton.addActionListener(this.getSaveAction());
        this.initButton(this.saveAsButton, "stock_save-as", "Save settings to a different file");
        this.saveAsButton.addActionListener(this.getSaveAsAction());
        this.initButton(this.reloadButton, "stock_reload", "Reload settings from a different file");
        this.reloadButton.addActionListener(this.getReloadAction());
        this.fileLabel.setText("");
        this.listModel = new DefaultListModel();
        for (Settings setting : Settings.values()) {
            this.listModel.addElement(setting);
        }
        this.settingItems.setModel(this.listModel);
        this.settingItems.setCellRenderer(new SettingCellRenderer());
        this.settingItems.setSelectedIndex(0);
        this.settingItems.addListSelectionListener(this.getSettingItemsAction());
    }

    private void initButton(JButton button, String iconName, String toolTipText) {
        button.setText("");
        button.setToolTipText(toolTipText);
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setContentAreaFilled(false);
        ImageIcon icon = ImageUtil.getSmallImageIcon(iconName);
        button.setIcon(icon);
        button.setDisabledIcon(ImageUtil.createTransparentIcon(icon));
        button.setPressedIcon(ImageUtil.createDarkerIcon(icon));
        button.setFocusable(false);
    }

    public ActionListener getSaveAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SettingsPanel.this.getConfiguration().save();
                StatusBar.getInstance().setText("Configuration saved", new Object[0]);
            }
        };
    }

    public ActionListener getSaveAsAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser();
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save settings");
                FileChooserPreference pref = new FileChooserPreference("SettingsSave", chooser);
                Window ancestor = SwingUtilities.getWindowAncestor((Component)ae.getSource());
                int result = chooser.showOpenDialog(ancestor);
                if (result == 0) {
                    pref.save();
                    File file = chooser.getSelectedFile();
                    SettingsPanel.this.getConfiguration().setConfigurationFile(file);
                    SettingsPanel.this.getConfiguration().save();
                    StatusBar.getInstance().setText("Configuration saved to " + file, new Object[0]);
                }
            }
        };
    }

    public ActionListener getReloadAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser();
                chooser.setApproveButtonText("Reload");
                chooser.setDialogTitle("Reload settings");
                FileChooserPreference pref = new FileChooserPreference("SettingsSave", chooser);
                Window ancestor = SwingUtilities.getWindowAncestor((Component)ae.getSource());
                int result = chooser.showOpenDialog(ancestor);
                if (result == 0) {
                    pref.save();
                    File file = chooser.getSelectedFile();
                    if (!ConfigurationManager.getInstance().reload(file, SettingsPanel.this.getConfiguration().getClass())) {
                        StatusBar.getInstance().setAlarm("Failed to reload from " + file, new Object[0]);
                    }
                }
            }
        };
    }

    public ListSelectionListener getSettingItemsAction() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                Settings settings = (Settings)((Object)SettingsPanel.this.settingItems.getSelectedValue());
                CardLayout layout = (CardLayout)SettingsPanel.this.settingsPanel.getLayout();
                layout.show(SettingsPanel.this.settingsPanel, settings.getName());
            }
        };
    }

    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
        JMeldSettings c = this.getConfiguration();
        this.fileLabel.setText(c.getConfigurationFileName());
        this.saveButton.setEnabled(c.isChanged());
    }

    public boolean checkSave() {
        if (this.getConfiguration().isChanged()) {
            SaveSettingsDialog dialog = new SaveSettingsDialog(this.mainPanel);
            dialog.show();
            if (dialog.isOK()) {
                dialog.doSave();
            }
        }
        return true;
    }

    private JMeldSettings getConfiguration() {
        return JMeldSettings.getInstance();
    }
}

