/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.graph.FormatControllerListener;
import net.sourceforge.squirrel_sql.plugins.graph.FormatDlg;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.FormatXmlBean;

public class FormatController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormatController.class);
    private FormatDlg _dlg;
    private FormatXmlBean[] _formats;
    private ISession _session;
    private GraphPlugin _plugin;
    private String FORMAT_XML_FILE_NAME = "formats.xml";
    private FormatControllerListener _listener;
    private JPopupMenu m_lstPopup;
    private Unit m_currentUnit;

    public FormatController(ISession session, GraphPlugin plugin, FormatControllerListener listener) {
        try {
            this._plugin = plugin;
            this._session = session;
            this._listener = listener;
            String userSettingsFolder = this._plugin.getPluginUserSettingsFolder().getPath();
            File f = new File(userSettingsFolder + File.separator + this.FORMAT_XML_FILE_NAME);
            if (f.exists()) {
                XMLBeanReader br = new XMLBeanReader();
                br.load(userSettingsFolder + File.separator + this.FORMAT_XML_FILE_NAME, this.getClass().getClassLoader());
                ArrayList<FormatXmlBean> buf = new ArrayList<FormatXmlBean>();
                Iterator i = br.iterator();
                while (i.hasNext()) {
                    buf.add((FormatXmlBean)i.next());
                }
                this._formats = buf.toArray(new FormatXmlBean[buf.size()]);
            }
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (XMLException e) {
            throw new RuntimeException(e);
        }
    }

    private void onSave() {
        double width;
        double height;
        if (null == this._dlg.txtName.getText() || "".equals(this._dlg.txtName.getText().trim())) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("graph.invalidName"));
            return;
        }
        String name = this._dlg.txtName.getText().trim();
        Unit selUnit = (Unit)this._dlg.cboUnit.getSelectedItem();
        String buf = this._dlg.txtHeight.getText();
        try {
            height = Double.parseDouble(buf) * selUnit.getInCm();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("graph.invalidHeight"));
            return;
        }
        buf = this._dlg.txtWidth.getText();
        try {
            width = Double.parseDouble(buf) * selUnit.getInCm();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("graph.invalidWidth"));
            return;
        }
        boolean isLandscape = this._dlg.chkIsLandscape.isSelected();
        FormatXmlBean selBean = (FormatXmlBean)this._dlg.lstFormats.getSelectedValue();
        if (null == selBean) {
            selBean = new FormatXmlBean(name, width, height, false, isLandscape);
            ArrayList<FormatXmlBean> v = new ArrayList<FormatXmlBean>();
            v.addAll(Arrays.asList(this._formats));
            v.add(selBean);
            this._formats = v.toArray(new FormatXmlBean[v.size()]);
            this._dlg.lstFormats.setListData(this._formats);
            this._dlg.lstFormats.setSelectedValue(selBean, true);
        } else {
            selBean.setName(name);
            selBean.setWidth(width);
            selBean.setHeight(height);
            selBean.setLandscape(isLandscape);
            this._dlg.lstFormats.repaint();
        }
        this._listener.formatsChanged((FormatXmlBean)this._dlg.lstFormats.getSelectedValue());
        this.saveFormats();
    }

    private void saveFormats() {
        try {
            String userSettingsFolder = this._plugin.getPluginUserSettingsFolder().getPath();
            XMLBeanWriter bw = new XMLBeanWriter();
            for (FormatXmlBean _format : this._formats) {
                bw.addToRoot((Object)_format);
            }
            bw.save(userSettingsFolder + File.separator + this.FORMAT_XML_FILE_NAME);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XMLException e) {
            throw new RuntimeException(e);
        }
    }

    private void onNew() {
        this._dlg.lstFormats.clearSelection();
    }

    private void onListSelectionChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.updateRightSideControls();
        }
    }

    private void updateRightSideControls() {
        FormatXmlBean selBean = (FormatXmlBean)this._dlg.lstFormats.getSelectedValue();
        if (null == selBean) {
            this._dlg.txtName.setText(null);
            this._dlg.txtHeight.setText(null);
            this._dlg.txtWidth.setText(null);
        } else {
            this._dlg.txtName.setText(selBean.getName());
            this._dlg.chkIsLandscape.setSelected(selBean.isLandscape());
            Unit unit = (Unit)this._dlg.cboUnit.getSelectedItem();
            if (this._dlg.cboUnit.getSelectedItem() == Unit.UNIT_CM) {
                this._dlg.txtHeight.setText("" + selBean.getHeight());
                this._dlg.txtWidth.setText("" + selBean.getWidth());
            } else {
                this._dlg.txtHeight.setText("" + selBean.getHeight() / unit.getInCm());
                this._dlg.txtWidth.setText("" + selBean.getWidth() / unit.getInCm());
            }
        }
    }

    private FormatXmlBean[] getDefaultFormats() {
        return new FormatXmlBean[]{new FormatXmlBean(s_stringMgr.getString("graph.dina3"), 29.7, 42.0, false, false), new FormatXmlBean(s_stringMgr.getString("graph.dina4"), 21.0, 29.7, false, false), new FormatXmlBean(s_stringMgr.getString("graph.dina5"), 14.8, 21.0, true, false)};
    }

    public void setVisible(Window parent, boolean b) {
        this._dlg = new FormatDlg(parent);
        if (null == this._formats) {
            this._formats = this.getDefaultFormats();
        }
        this._dlg.lstFormats.setListData(this._formats);
        this._dlg.cboUnit.addItem(Unit.UNIT_CM);
        this._dlg.cboUnit.addItem(Unit.UNIT_INCH);
        this.m_currentUnit = Unit.UNIT_CM;
        this._dlg.cboUnit.setSelectedItem(Unit.UNIT_CM);
        this._dlg.lstFormats.setSelectionMode(2);
        this._dlg.lstFormats.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FormatController.this.onListSelectionChanged(e);
            }
        });
        this._dlg.lstFormats.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FormatController.this.maybeShowListPopUp(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FormatController.this.maybeShowListPopUp(e);
            }
        });
        this.m_lstPopup = new JPopupMenu();
        JMenuItem mnuDeleteFomat = new JMenuItem(s_stringMgr.getString("graph.mnuDelete"));
        mnuDeleteFomat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatController.this.onDeleteSeletedListItems();
            }
        });
        this.m_lstPopup.add(mnuDeleteFomat);
        JMenuItem mnuLandscape = new JMenuItem(s_stringMgr.getString("graph.landscape"));
        mnuLandscape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatController.this.onLandscape();
            }
        });
        this.m_lstPopup.add(mnuLandscape);
        this._dlg.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatController.this.onNew();
            }
        });
        this._dlg.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatController.this.onSave();
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FormatController.this.onWindowClosing();
            }
        });
        this._dlg.cboUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FormatController.this.onUnitChanged(e);
            }
        });
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(b);
    }

    private void onLandscape() {
        FormatXmlBean selBean = (FormatXmlBean)this._dlg.lstFormats.getSelectedValue();
        if (null == selBean) {
            return;
        }
        FormatXmlBean lsBean = new FormatXmlBean(selBean.getName() + " (LS)", selBean.getHeight(), selBean.getWidth(), false, true);
        ArrayList<FormatXmlBean> v = new ArrayList<FormatXmlBean>();
        v.addAll(Arrays.asList(this._formats));
        v.add(lsBean);
        this._formats = v.toArray(new FormatXmlBean[v.size()]);
        this._dlg.lstFormats.setListData(this._formats);
        this._dlg.lstFormats.setSelectedValue(lsBean, true);
        this._listener.formatsChanged((FormatXmlBean)this._dlg.lstFormats.getSelectedValue());
        this._dlg.lstFormats.repaint();
    }

    private void onDeleteSeletedListItems() {
        Object[] selFormats = this._dlg.lstFormats.getSelectedValues();
        Vector<FormatXmlBean> remainFormats = new Vector<FormatXmlBean>();
        for (int i = 0; i < this._formats.length; ++i) {
            boolean found = false;
            for (int j = 0; j < selFormats.length; ++j) {
                if (this._formats[i] != selFormats[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            remainFormats.add(this._formats[i]);
        }
        this._formats = 0 == remainFormats.size() ? this.getDefaultFormats() : remainFormats.toArray(new FormatXmlBean[remainFormats.size()]);
        this.saveFormats();
        this._dlg.lstFormats.setListData(this._formats);
    }

    private void maybeShowListPopUp(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.m_lstPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void onUnitChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Unit selUnit = (Unit)this._dlg.cboUnit.getSelectedItem();
            if (selUnit == this.m_currentUnit) {
                return;
            }
            try {
                double widht = Double.parseDouble(this._dlg.txtWidth.getText());
                double height = Double.parseDouble(this._dlg.txtHeight.getText());
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("graph.invalidNumberFormat"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((FormatController)FormatController.this)._dlg.cboUnit.setSelectedItem(FormatController.this.m_currentUnit);
                    }
                });
                return;
            }
            this._dlg.txtWidth.setText("" + (widht *= this.m_currentUnit.getInCm() / selUnit.getInCm()));
            this._dlg.txtHeight.setText("" + (height *= this.m_currentUnit.getInCm() / selUnit.getInCm()));
            this.m_currentUnit = selUnit;
        }
    }

    private void onWindowClosing() {
        this._listener.formatsChanged((FormatXmlBean)this._dlg.lstFormats.getSelectedValue());
        this.saveFormats();
    }

    public FormatXmlBean[] getFormats() {
        if (null == this._formats) {
            this._formats = this.getDefaultFormats();
        }
        return this._formats;
    }

    public void close() {
        if (null != this._dlg) {
            this.saveFormats();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        }
    }

    static /* synthetic */ StringManager access$1000() {
        return s_stringMgr;
    }

    public static class Unit {
        public static final Unit UNIT_CM = new Unit(FormatController.access$1000().getString("graph.cm"), 1.0);
        public static final Unit UNIT_INCH = new Unit(FormatController.access$1000().getString("graph.inch"), 2.54);
        private final String _name;
        private final double _inCm;

        private Unit(String name, double inCm) {
            this._name = name;
            this._inCm = inCm;
        }

        public String getName() {
            return this._name;
        }

        public double getInCm() {
            return this._inCm;
        }

        public String toString() {
            return this._name;
        }
    }
}

