/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.SimpleObjCache;

public class PacUtils {
    public static final int PRECOMPILED_GLOB_CACHE_MAX_ITEMS = 10;
    private static final SimpleObjCache<String, Pattern> PRECOMPILED_GLOB_CACHE = new SimpleObjCache(10);

    public static Pattern createRegexPatternFromGlob(String string) {
        Pattern pattern = PRECOMPILED_GLOB_CACHE.get(string);
        if (pattern != null) {
            return pattern;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("^");
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuilder.append(".*?");
                    continue block7;
                }
                case '?': {
                    stringBuilder.append(".{1}");
                    continue block7;
                }
                case '.': {
                    stringBuilder.append("\\.");
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '!': {
                    if (i > 0 && string.charAt(i - 1) == '[') {
                        stringBuilder.append('^');
                        continue block7;
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append("$");
        pattern = Pattern.compile(stringBuilder.toString());
        PRECOMPILED_GLOB_CACHE.put(string, pattern);
        return pattern;
    }

    public static <T> String toSemiColonList(List<T> list, Function<T, String> function) {
        return list.stream().map(object -> (String)function.apply(object)).collect(Collectors.joining(";"));
    }

    public static <T> String toSemiColonList(List<T> list) {
        return PacUtils.toSemiColonList(list, Object::toString);
    }

    public static String toSemiColonListInetAddress(InetAddress[] inetAddressArray) {
        return PacUtils.toSemiColonList(Arrays.asList(inetAddressArray), InetAddress::getHostAddress);
    }

    public static String toSemiColonListInetAddress(List<InetAddress> list) {
        return PacUtils.toSemiColonList(list, InetAddress::getHostAddress);
    }

    public static boolean ipPrefixMatch(InetAddress inetAddress, String string) {
        Object object;
        if (string.indexOf(47) == -1) {
            return false;
        }
        String[] stringArray = string.trim().split("\\/");
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[1].trim());
            if (n < 0 || n > 128) {
                return false;
            }
            if (inetAddress instanceof Inet4Address && n > 32) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string2 = stringArray[0].trim();
        InetAddress inetAddress2 = null;
        if (inetAddress instanceof Inet4Address && IpAddressUtils.looksLikeIpv4Literal(string2)) {
            try {
                inetAddress2 = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        if (inetAddress instanceof Inet6Address && IpAddressUtils.looksLikeIpv6Literal((String)(object = PacUtils.correctIPv6Str(string2)))) {
            try {
                inetAddress2 = InetAddress.getByName((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        if (inetAddress2 == null) {
            return false;
        }
        if (!inetAddress.getClass().equals(inetAddress2.getClass())) {
            return false;
        }
        object = BigInteger.valueOf(-1L).shiftLeft(inetAddress2.getAddress().length * 8 - n);
        BigInteger bigInteger = new BigInteger(inetAddress2.getAddress()).and((BigInteger)object);
        return new BigInteger(inetAddress.getAddress()).and((BigInteger)object).equals(bigInteger);
    }

    private static String correctIPv6Str(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++n;
            if (i <= 0 || string.charAt(i - 1) != ':') continue;
            return string;
        }
        if (n != 7) {
            return string + "::";
        }
        return string;
    }

    public static String toStrippedURLStr(URI uRI) {
        String string = uRI.getPort() == -1 ? "" : ":" + uRI.getPort();
        return uRI.getScheme() + "://" + uRI.getHost() + string + "/";
    }
}

