/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.generators.DHParametersGenerator;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import org.bouncycastle.crypto.generators.GOST3410KeyPairGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCEDHPrivateKey;
import org.bouncycastle.jce.provider.JCEDHPublicKey;
import org.bouncycastle.jce.provider.JCEElGamalPrivateKey;
import org.bouncycastle.jce.provider.JCEElGamalPublicKey;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.jce.provider.JDKDSAPrivateKey;
import org.bouncycastle.jce.provider.JDKDSAPublicKey;
import org.bouncycastle.jce.provider.JDKGOST3410PrivateKey;
import org.bouncycastle.jce.provider.JDKGOST3410PublicKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String string) {
        super(string);
    }

    @Override
    public abstract void initialize(int var1, SecureRandom var2);

    @Override
    public abstract KeyPair generateKeyPair();

    public static class DH
    extends JDKKeyPairGenerator {
        private static Hashtable params = new Hashtable();
        DHKeyGenerationParameters param;
        DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DH() {
            super("DH");
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new DHKeyGenerationParameters(secureRandom, new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            Object object;
            Object object2;
            if (!this.initialised) {
                object2 = new Integer(this.strength);
                if (params.containsKey(object2)) {
                    this.param = (DHKeyGenerationParameters)params.get(object2);
                } else {
                    object = new DHParametersGenerator();
                    ((DHParametersGenerator)object).init(this.strength, this.certainty, this.random);
                    this.param = new DHKeyGenerationParameters(this.random, ((DHParametersGenerator)object).generateParameters());
                    params.put(object2, this.param);
                }
                this.engine.init(this.param);
                this.initialised = true;
            }
            object2 = this.engine.generateKeyPair();
            object = (DHPublicKeyParameters)((AsymmetricCipherKeyPair)object2).getPublic();
            DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)((AsymmetricCipherKeyPair)object2).getPrivate();
            return new KeyPair(new JCEDHPublicKey((DHPublicKeyParameters)object), new JCEDHPrivateKey(dHPrivateKeyParameters));
        }
    }

    public static class DSA
    extends JDKKeyPairGenerator {
        DSAKeyGenerationParameters param;
        DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DSA() {
            super("DSA");
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            if (n < 512 || n > 1024 || n % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = n;
            this.random = secureRandom;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            Object object;
            if (!this.initialised) {
                object = new DSAParametersGenerator();
                ((DSAParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new DSAKeyGenerationParameters(this.random, ((DSAParametersGenerator)object).generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            object = this.engine.generateKeyPair();
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
            return new KeyPair(new JDKDSAPublicKey(dSAPublicKeyParameters), new JDKDSAPrivateKey(dSAPrivateKeyParameters));
        }
    }

    public static class ElGamal
    extends JDKKeyPairGenerator {
        ElGamalKeyGenerationParameters param;
        ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public ElGamal() {
            super("ElGamal");
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
            }
            if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
                ElGamalParameterSpec elGamalParameterSpec = (ElGamalParameterSpec)algorithmParameterSpec;
                this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(elGamalParameterSpec.getP(), elGamalParameterSpec.getG()));
            } else {
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
                this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL()));
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            Object object;
            if (!this.initialised) {
                object = new ElGamalParametersGenerator();
                ((ElGamalParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, ((ElGamalParametersGenerator)object).generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            object = this.engine.generateKeyPair();
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
            ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
            return new KeyPair(new JCEElGamalPublicKey(elGamalPublicKeyParameters), new JCEElGamalPrivateKey(elGamalPrivateKeyParameters));
        }
    }

    public static class GOST3410
    extends JDKKeyPairGenerator {
        GOST3410KeyGenerationParameters param;
        GOST3410KeyPairGenerator engine = new GOST3410KeyPairGenerator();
        GOST3410ParameterSpec gost3410Params;
        int strength = 1024;
        SecureRandom random = null;
        boolean initialised = false;

        public GOST3410() {
            super("GOST3410");
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        private void init(GOST3410ParameterSpec gOST3410ParameterSpec, SecureRandom secureRandom) {
            GOST3410PublicKeyParameterSetSpec gOST3410PublicKeyParameterSetSpec = gOST3410ParameterSpec.getPublicKeyParameters();
            this.param = new GOST3410KeyGenerationParameters(secureRandom, new GOST3410Parameters(gOST3410PublicKeyParameterSetSpec.getP(), gOST3410PublicKeyParameterSetSpec.getQ(), gOST3410PublicKeyParameterSetSpec.getA()));
            this.engine.init(this.param);
            this.initialised = true;
            this.gost3410Params = gOST3410ParameterSpec;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a GOST3410ParameterSpec");
            }
            this.init((GOST3410ParameterSpec)algorithmParameterSpec, secureRandom);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()), new SecureRandom());
            }
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            GOST3410PublicKeyParameters gOST3410PublicKeyParameters = (GOST3410PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            GOST3410PrivateKeyParameters gOST3410PrivateKeyParameters = (GOST3410PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            return new KeyPair(new JDKGOST3410PublicKey(gOST3410PublicKeyParameters, this.gost3410Params), new JDKGOST3410PrivateKey(gOST3410PrivateKeyParameters, this.gost3410Params));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 12;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init(this.param);
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, secureRandom, n, 12);
            this.engine.init(this.param);
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
            this.param = new RSAKeyGenerationParameters(rSAKeyGenParameterSpec.getPublicExponent(), secureRandom, rSAKeyGenParameterSpec.getKeysize(), 12);
            this.engine.init(this.param);
        }

        @Override
        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
            return new KeyPair(new JCERSAPublicKey(rSAKeyParameters), new JCERSAPrivateCrtKey(rSAPrivateCrtKeyParameters));
        }
    }
}

