/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.edit;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.util.EnumSet;
import javax.swing.Action;
import org.diylc.appframework.undo.IUndoListener;
import org.diylc.appframework.undo.UndoHandler;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.ExpansionMode;
import org.diylc.core.Project;
import org.diylc.images.IconLoader;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.edit.ComponentTransferable;

public class EditMenuPlugin
implements IPlugIn,
ClipboardOwner {
    private static final String EDIT_TITLE = "Edit";
    private static final String RENUMBER_TITLE = "Renumber Selection";
    private static final String EXPAND_TITLE = "Expand Selection";
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;
    private Clipboard clipboard;
    private ActionFactory.CutAction cutAction;
    private ActionFactory.CopyAction copyAction;
    private ActionFactory.PasteAction pasteAction;
    private ActionFactory.EditSelectionAction editSelectionAction;
    private ActionFactory.DeleteSelectionAction deleteSelectionAction;
    private ActionFactory.GroupAction groupAction;
    private ActionFactory.UngroupAction ungroupAction;
    private ActionFactory.SendToBackAction sendToBackAction;
    private ActionFactory.BringToFrontAction bringToFrontAction;
    private ActionFactory.RenumberAction renumberXAxisAction;
    private ActionFactory.RenumberAction renumberYAxisAction;
    private ActionFactory.ExpandSelectionAction expandSelectionAllAction;
    private ActionFactory.ExpandSelectionAction expandSelectionImmediateAction;
    private ActionFactory.ExpandSelectionAction expandSelectionSameTypeAction;
    private ActionFactory.SaveAsTemplateAction saveAsTemplateAction;
    private ActionFactory.RotateSelectionAction rotateClockwiseAction;
    private ActionFactory.RotateSelectionAction rotateCounterClockwiseAction;
    private UndoHandler<Project> undoHandler;

    public EditMenuPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.undoHandler = new UndoHandler((IUndoListener)new IUndoListener<Project>(){

            public void actionPerformed(Project project) {
                EditMenuPlugin.this.plugInPort.loadProject(project, false);
            }
        });
        this.clipboard.addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent flavorEvent) {
                EditMenuPlugin.this.refreshActions();
            }
        });
    }

    public ActionFactory.CutAction getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = ActionFactory.getInstance().createCutAction(this.plugInPort, this.clipboard, this);
        }
        return this.cutAction;
    }

    public ActionFactory.CopyAction getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = ActionFactory.getInstance().createCopyAction(this.plugInPort, this.clipboard, this);
        }
        return this.copyAction;
    }

    public ActionFactory.PasteAction getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = ActionFactory.getInstance().createPasteAction(this.plugInPort, this.clipboard);
        }
        return this.pasteAction;
    }

    public ActionFactory.EditSelectionAction getEditSelectionAction() {
        if (this.editSelectionAction == null) {
            this.editSelectionAction = ActionFactory.getInstance().createEditSelectionAction(this.plugInPort);
        }
        return this.editSelectionAction;
    }

    public ActionFactory.DeleteSelectionAction getDeleteSelectionAction() {
        if (this.deleteSelectionAction == null) {
            this.deleteSelectionAction = ActionFactory.getInstance().createDeleteSelectionAction(this.plugInPort);
        }
        return this.deleteSelectionAction;
    }

    public ActionFactory.GroupAction getGroupAction() {
        if (this.groupAction == null) {
            this.groupAction = ActionFactory.getInstance().createGroupAction(this.plugInPort);
        }
        return this.groupAction;
    }

    public ActionFactory.UngroupAction getUngroupAction() {
        if (this.ungroupAction == null) {
            this.ungroupAction = ActionFactory.getInstance().createUngroupAction(this.plugInPort);
        }
        return this.ungroupAction;
    }

    public ActionFactory.SendToBackAction getSendToBackAction() {
        if (this.sendToBackAction == null) {
            this.sendToBackAction = ActionFactory.getInstance().createSendToBackAction(this.plugInPort);
        }
        return this.sendToBackAction;
    }

    public ActionFactory.BringToFrontAction getBringToFrontAction() {
        if (this.bringToFrontAction == null) {
            this.bringToFrontAction = ActionFactory.getInstance().createBringToFrontAction(this.plugInPort);
        }
        return this.bringToFrontAction;
    }

    public ActionFactory.RenumberAction getRenumberXAxisAction() {
        if (this.renumberXAxisAction == null) {
            this.renumberXAxisAction = ActionFactory.getInstance().createRenumberAction(this.plugInPort, true);
        }
        return this.renumberXAxisAction;
    }

    public ActionFactory.RenumberAction getRenumberYAxisAction() {
        if (this.renumberYAxisAction == null) {
            this.renumberYAxisAction = ActionFactory.getInstance().createRenumberAction(this.plugInPort, false);
        }
        return this.renumberYAxisAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionAllAction() {
        if (this.expandSelectionAllAction == null) {
            this.expandSelectionAllAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.ALL);
        }
        return this.expandSelectionAllAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionImmediateAction() {
        if (this.expandSelectionImmediateAction == null) {
            this.expandSelectionImmediateAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.IMMEDIATE);
        }
        return this.expandSelectionImmediateAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionSameTypeAction() {
        if (this.expandSelectionSameTypeAction == null) {
            this.expandSelectionSameTypeAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.SAME_TYPE);
        }
        return this.expandSelectionSameTypeAction;
    }

    public ActionFactory.SaveAsTemplateAction getSaveAsTemplateAction() {
        if (this.saveAsTemplateAction == null) {
            this.saveAsTemplateAction = ActionFactory.getInstance().createSaveAsTemplateAction(this.plugInPort);
        }
        return this.saveAsTemplateAction;
    }

    public ActionFactory.RotateSelectionAction getRotateClockwiseAction() {
        if (this.rotateClockwiseAction == null) {
            this.rotateClockwiseAction = ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, 1);
        }
        return this.rotateClockwiseAction;
    }

    public ActionFactory.RotateSelectionAction getRotateCounterclockwiseAction() {
        if (this.rotateCounterClockwiseAction == null) {
            this.rotateCounterClockwiseAction = ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, -1);
        }
        return this.rotateCounterClockwiseAction;
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        ActionFactory actionFactory = ActionFactory.getInstance();
        this.swingUI.injectMenuAction((Action)this.undoHandler.getUndoAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction((Action)this.undoHandler.getRedoAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(null, EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getCutAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getCopyAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getPasteAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(null, EDIT_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createSelectAllAction(iPlugInPort), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getEditSelectionAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getDeleteSelectionAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getRotateClockwiseAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getRotateCounterclockwiseAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getSendToBackAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getBringToFrontAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getGroupAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getUngroupAction(), EDIT_TITLE);
        this.swingUI.injectMenuAction(null, EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getSaveAsTemplateAction(), EDIT_TITLE);
        this.swingUI.injectSubmenu(RENUMBER_TITLE, IconLoader.Sort.getIcon(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getRenumberXAxisAction(), RENUMBER_TITLE);
        this.swingUI.injectMenuAction(this.getRenumberYAxisAction(), RENUMBER_TITLE);
        this.swingUI.injectSubmenu(EXPAND_TITLE, IconLoader.BranchAdd.getIcon(), EDIT_TITLE);
        this.swingUI.injectMenuAction(this.getExpandSelectionAllAction(), EXPAND_TITLE);
        this.swingUI.injectMenuAction(this.getExpandSelectionImmediateAction(), EXPAND_TITLE);
        this.swingUI.injectMenuAction(this.getExpandSelectionSameTypeAction(), EXPAND_TITLE);
        this.swingUI.injectMenuAction(null, EDIT_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createEditProjectAction(iPlugInPort), EDIT_TITLE);
        this.refreshActions();
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.SELECTION_CHANGED, EventType.PROJECT_MODIFIED);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        switch (eventType) {
            case SELECTION_CHANGED: {
                this.refreshActions();
                break;
            }
            case PROJECT_MODIFIED: {
                this.undoHandler.stateChanged((Object)((Project)objectArray[0]), (Object)((Project)objectArray[1]), (String)objectArray[2]);
            }
        }
    }

    private void refreshActions() {
        boolean bl = !this.plugInPort.getSelectedComponents().isEmpty();
        this.getCutAction().setEnabled(bl);
        this.getCopyAction().setEnabled(bl);
        try {
            this.getPasteAction().setEnabled(this.clipboard.isDataFlavorAvailable(ComponentTransferable.listFlavor));
        }
        catch (Exception exception) {
            this.getPasteAction().setEnabled(false);
        }
        this.getEditSelectionAction().setEnabled(bl);
        this.getDeleteSelectionAction().setEnabled(bl);
        this.getGroupAction().setEnabled(bl);
        this.getExpandSelectionAllAction().setEnabled(bl);
        this.getExpandSelectionImmediateAction().setEnabled(bl);
        this.getExpandSelectionSameTypeAction().setEnabled(bl);
        this.getUngroupAction().setEnabled(bl);
        this.getSendToBackAction().setEnabled(bl);
        this.getBringToFrontAction().setEnabled(bl);
        this.getRotateClockwiseAction().setEnabled(bl);
        this.getRotateCounterclockwiseAction().setEnabled(bl);
        this.getSaveAsTemplateAction().setEnabled(bl);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.refreshActions();
    }
}

