/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.objecttable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.diylc.swingframework.autofit.AutoFitTable;
import org.diylc.swingframework.objecttable.ActionTableCellRenderer;
import org.diylc.swingframework.objecttable.IActionProcessor;
import org.diylc.swingframework.objecttable.ObjectListTableModel;

public class ObjectListTable<T>
extends AutoFitTable {
    private static final long serialVersionUID = 1L;
    private IActionProcessor<T> clickListener;

    public ObjectListTable(Class<? extends T> dataClass, String[] fields, IActionProcessor<T> clickListener) throws SecurityException, NoSuchMethodException {
        super(new ObjectListTableModel<T>(dataClass, fields));
        this.clickListener = clickListener;
        for (Integer idx : ((ObjectListTableModel)this.getModel()).getActionColumns()) {
            this.getColumnModel().getColumn(idx).setCellRenderer(new ActionTableCellRenderer(this.clickListener.getActionIcon(this.getModel().getColumnName(idx)), this.clickListener.getActionLabel(this.getModel().getColumnName(idx))));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int columnIndex = ObjectListTable.this.columnAtPoint(e.getPoint());
                if (((ObjectListTableModel)ObjectListTable.this.getModel()).getActionColumns().contains(columnIndex)) {
                    int rowIndex = ObjectListTable.this.rowAtPoint(e.getPoint());
                    Object value = ((ObjectListTableModel)ObjectListTable.this.getModel()).getData().get(rowIndex);
                    ObjectListTable.this.clickListener.actionExecuted(value, ObjectListTable.this.getModel().getColumnName(columnIndex));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int columnIndex = ObjectListTable.this.columnAtPoint(e.getPoint());
                if (((ObjectListTableModel)ObjectListTable.this.getModel()).getActionColumns().contains(columnIndex)) {
                    ObjectListTable.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    ObjectListTable.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    public void setData(List<T> data) {
        ((ObjectListTableModel)this.getModel()).setData(data);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    protected Color colorForRow(int row) {
        return row % 2 == 1 ? new Color(240, 240, 240) : this.getBackground();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!((ObjectListTableModel)this.getModel()).getActionColumns().contains(column)) {
            if (!this.isCellSelected(row, column)) {
                c.setBackground(this.colorForRow(row));
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(UIManager.getColor("Table.selectionBackground"));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        }
        return c;
    }
}

