/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import java.util.ArrayList;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.persist.PerspectiveModel;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerspectiveModelSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        PerspectiveModel perspectiveModel = (PerspectiveModel)object;
        Element perspectiveModelElement = document.createElement("PerspectiveModel");
        perspectiveModelElement.setAttribute("currentPerspectiveId", perspectiveModel.getCurrentPerspective());
        perspectiveModelElement.setAttribute("defaultPerspectiveId", perspectiveModel.getDefaultPerspective());
        ISerializer perspectiveSerializer = SerializerRegistry.getSerializer(Perspective.class);
        Perspective[] perspectives = perspectiveModel.getPerspectives();
        for (int i = 0; i < perspectives.length; ++i) {
            Perspective perspective = perspectives[i];
            Element perspectiveElement = perspectiveSerializer.serialize(document, perspective);
            perspectiveModelElement.appendChild(perspectiveElement);
        }
        return perspectiveModelElement;
    }

    public Object deserialize(Element element) {
        String currentPerspectiveId = element.getAttribute("currentPerspectiveId");
        String defaultPerspectiveId = element.getAttribute("defaultPerspectiveId");
        NodeList perspectivesList = element.getElementsByTagName("Perspective");
        ISerializer perspectiveSerializer = SerializerRegistry.getSerializer(Perspective.class);
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        for (int i = 0; i < perspectivesList.getLength(); ++i) {
            Node node = perspectivesList.item(i);
            if (!(node instanceof Element)) continue;
            Element perspectiveElement = (Element)node;
            Perspective perspective = (Perspective)perspectiveSerializer.deserialize(perspectiveElement);
            perspectives.add(perspective);
        }
        Perspective[] perspectivesArray = perspectives.toArray(new Perspective[perspectives.size()]);
        PerspectiveModel perspectiveModel = new PerspectiveModel(defaultPerspectiveId, currentPerspectiveId, perspectivesArray);
        return perspectiveModel;
    }
}

