/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.utils.StringUtils;

public class GameInformation {
    public int m_boardSize;
    public int m_handicap;
    public double m_komi;
    public String m_blackRank;
    public String m_date;
    public String m_playerBlack;
    public String m_playerWhite;
    public String m_result;
    public String m_rules;
    public String m_whiteRank;
    public TimeSettings m_timeSettings;

    public GameInformation(int n) {
        this.m_boardSize = n;
    }

    public String roundKomi() {
        return GameInformation.roundKomi(this.m_komi);
    }

    public static String roundKomi(double d) {
        long l = Math.round(d * 2.0);
        if (l % 2L == 0L) {
            return Long.toString(l / 2L);
        }
        return Long.toString(l / 2L) + ".5";
    }

    public String suggestGameName() {
        boolean bl;
        String string = this.m_playerBlack;
        String string2 = this.m_playerWhite;
        boolean bl2 = string != null && !string.trim().equals("");
        boolean bl3 = bl = string2 != null && !string2.trim().equals("");
        if (!bl2 && !bl) {
            return null;
        }
        string = bl2 ? StringUtils.capitalize(string) : "Unknown";
        string2 = bl ? StringUtils.capitalize(string2) : "Unknown";
        return string2 + " vs " + string + " (B)";
    }
}

