/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.slf4j;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.slf4j.BuildOperationAwareLogger;
import org.gradle.internal.logging.slf4j.ContextAwareTaskLogger;
import org.gradle.internal.operations.OperationIdentifier;

class MessageRewritingBuildOperationAwareLogger
extends BuildOperationAwareLogger {
    private final BuildOperationAwareLogger delegate;
    private final ContextAwareTaskLogger.MessageRewriter messageRewriter;

    MessageRewritingBuildOperationAwareLogger(BuildOperationAwareLogger delegate, ContextAwareTaskLogger.MessageRewriter messageRewriter) {
        this.delegate = delegate;
        this.messageRewriter = messageRewriter;
    }

    ContextAwareTaskLogger.MessageRewriter getMessageRewriter() {
        return this.messageRewriter;
    }

    @Override
    void log(LogLevel logLevel, Throwable throwable, String message, OperationIdentifier operationIdentifier) {
        String rewrittenMessage = this.messageRewriter.rewrite(logLevel, message);
        if (rewrittenMessage == null) {
            return;
        }
        this.delegate.log(logLevel, throwable, rewrittenMessage, operationIdentifier);
    }

    @Override
    boolean isLevelAtMost(LogLevel level) {
        return this.delegate.isLevelAtMost(level);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }
}

