/**
This list is obtained parsing https://docs.microsoft.com/en-us/azure/governance/resource-graph/reference/supported-tables-resources
To programatically get the list, execute in the browser console:
 
 const i = {};
 document.querySelectorAll('li').forEach((li) => { 
    const m = li.textContent.match(/(.*\..*\/.*?)\s\((.*)\)/);
    if (m) {
      i[m[1].toLowerCase()] = m[2];
    }
  });
  i;
 
Note: Validate that the output makes sense, the format of the page may change.
 */
export const resourceTypeDisplayNames: { [k: string]: string } = {
  'microsoft.recoveryservices/vaults/backupfabrics/protectioncontainers/protecteditems': 'Backup Items',
  'microsoft.resources/subscriptions': 'Subscriptions',
  'microsoft.resources/subscriptions/resourcegroups': 'Resource groups',
  'citrix.services/xenappessentials': 'Citrix Virtual Apps Essentials',
  'citrix.services/xendesktopessentials': 'Citrix Virtual Desktops Essentials',
  'dynatrace.observability/monitors': 'Dynatrace',
  'github.enterprise/accounts': 'GitHub AE',
  'microsoft.aad/domainservices': 'Azure AD Domain Services',
  'microsoft.aadiam/privatelinkforazuread': 'Private Link for Azure AD',
  'microsoft.agfoodplatform/farmbeats': 'Azure FarmBeats',
  'microsoft.analysisservices/servers': 'Analysis Services',
  'microsoft.anybuild/clusters': 'AnyBuild clusters',
  'microsoft.apimanagement/service': 'API Management services',
  'microsoft.appconfiguration/configurationstores': 'App Configuration',
  'microsoft.appplatform/spring': 'Azure Spring Cloud',
  'microsoft.attestation/attestationproviders': 'Attestation providers',
  'microsoft.authorization/resourcemanagementprivatelinks': 'Resource management private links',
  'microsoft.automation/automationaccounts': 'Automation Accounts',
  'microsoft.automation/automationaccounts/runbooks': 'Runbook',
  'microsoft.autonomoussystems/workspaces': 'Bonsai',
  'microsoft.avs/privateclouds': 'AVS Private clouds',
  'microsoft.azureactivedirectory/b2cdirectories': 'B2C Tenants',
  'microsoft.azureactivedirectory/guestusages': 'Guest Usages',
  'microsoft.azurearcdata/datacontrollers': 'Azure Arc data controllers',
  'microsoft.azurearcdata/postgresinstances': 'Azure Arc-enabled PostgreSQL Hyperscale server groups',
  'microsoft.azurearcdata/sqlmanagedinstances': 'SQL managed instances - Azure Arc',
  'microsoft.azurearcdata/sqlserverinstances': 'SQL Server - Azure Arc',
  'microsoft.azuredata/sqlserverregistrations': 'SQL Server registries',
  'microsoft.azurepercept/accounts': 'Azure Percept accounts',
  'microsoft.azurestackhci/clusters': 'Azure Stack HCI',
  'microsoft.azurestackhci/virtualmachines': 'Azure Stack HCI virtual machine - Azure Arc',
  'microsoft.baremetal/crayservers': 'Cray Servers',
  'microsoft.baremetal/monitoringservers': 'Monitoring Servers',
  'microsoft.baremetalinfrastructure/baremetalinstances': 'BareMetal Instances',
  'microsoft.batch/batchaccounts': 'Batch accounts',
  'microsoft.bing/accounts': 'Bing Resources',
  'microsoft.botservice/botservices': 'Bot Services',
  'microsoft.cache/redis': 'Azure Cache for Redis',
  'microsoft.cache/redisenterprise': 'Redis Enterprise',
  'microsoft.cdn/cdnwebapplicationfirewallpolicies': 'Content Delivery Network WAF policies',
  'microsoft.cdn/profiles (front doors standard/premium': 'Preview)',
  'microsoft.cdn/profiles/afdendpoints': 'Endpoints',
  'microsoft.cdn/profiles/endpoints': 'Endpoints',
  'microsoft.certificateregistration/certificateorders': 'App Service Certificates',
  'microsoft.chaos/chaosexperiments': 'Chaos Experiments (Classic)',
  'microsoft.chaos/experiments': 'Chaos Experiments',
  'microsoft.classiccompute/domainnames': 'Cloud services (classic)',
  'microsoft.classiccompute/virtualmachines': 'Virtual machines (classic)',
  'microsoft.classicnetwork/networksecuritygroups': 'Network security groups (classic)',
  'microsoft.classicnetwork/reservedips': 'Reserved IP addresses (classic)',
  'microsoft.classicnetwork/virtualnetworks': 'Virtual networks (classic)',
  'microsoft.classicstorage/storageaccounts': 'Storage accounts (classic)',
  'microsoft.cloudtest/accounts': 'CloudTest Accounts',
  'microsoft.cloudtest/hostedpools': '1ES Hosted Pools',
  'microsoft.cloudtest/images': 'CloudTest Images',
  'microsoft.cloudtest/pools': 'CloudTest Pools',
  'microsoft.clusterstor/nodes': 'ClusterStors',
  'microsoft.cognitiveservices/accounts': 'Cognitive Services',
  'microsoft.compute/availabilitysets': 'Availability sets',
  'microsoft.compute/capacityreservationgroups': 'Capacity Reservation Groups',
  'microsoft.compute/cloudservices': 'Cloud services (extended support)',
  'microsoft.compute/diskaccesses': 'Disk Accesses',
  'microsoft.compute/diskencryptionsets': 'Disk Encryption Sets',
  'microsoft.compute/disks': 'Disks',
  'microsoft.compute/galleries': 'Azure compute galleries',
  'microsoft.compute/galleries/applications': 'VM application definitions',
  'microsoft.compute/galleries/applications/versions': 'VM application versions',
  'microsoft.compute/galleries/images': 'VM image definitions',
  'microsoft.compute/galleries/images/versions': 'VM image versions',
  'microsoft.compute/hostgroups': 'Host groups',
  'microsoft.compute/hostgroups/hosts': 'Hosts',
  'microsoft.compute/images': 'Images',
  'microsoft.compute/proximityplacementgroups': 'Proximity placement groups',
  'microsoft.compute/restorepointcollections': 'Restore Point Collections',
  'microsoft.compute/snapshots': 'Snapshots',
  'microsoft.compute/sshpublickeys': 'SSH keys',
  'microsoft.compute/virtualmachines': 'Virtual machines',
  'microsoft.compute/virtualmachinescalesets': 'Virtual machine scale sets',
  'microsoft.confidentialledger/ledgers': 'Confidential Ledgers',
  'microsoft.confluent/organizations': 'Confluent organizations',
  'microsoft.connectedcache/cachenodes': 'Connected Cache Resources',
  'microsoft.connectedcache/enterprisecustomers': 'Connected Cache Resources',
  'microsoft.connectedvehicle/platformaccounts': 'Connected Vehicle Platforms',
  'microsoft.connectedvmwarevsphere/vcenters': 'VMware vCenters',
  'microsoft.connectedvmwarevsphere/virtualmachines': 'VMware + AVS virtual machines',
  'microsoft.containerinstance/containergroups': 'Container instances',
  'microsoft.containerregistry/registries': 'Container registries',
  'microsoft.containerregistry/registries/replications': 'Container registry replications',
  'microsoft.containerregistry/registries/webhooks': 'Container registry webhooks',
  'microsoft.containerservice/managedclusters': 'Kubernetes services',
  'microsoft.dashboard/grafana': 'Grafana Workspaces',
  'microsoft.databox/jobs': 'Azure Data Box',
  'microsoft.databoxedge/databoxedgedevices': 'Azure Stack Edge / Data Box Gateway',
  'microsoft.databricks/workspaces': 'Azure Databricks Services',
  'microsoft.datacatalog/catalogs': 'Data Catalog',
  'microsoft.datacollaboration/workspaces': 'Project CI',
  'microsoft.datadog/monitors': 'Datadog',
  'microsoft.datafactory/datafactories': 'Data factories',
  'microsoft.datafactory/factories': 'Data factories (V2)',
  'microsoft.datalakeanalytics/accounts': 'Data Lake Analytics',
  'microsoft.datalakestore/accounts': 'Data Lake Storage Gen1',
  'microsoft.datamigration/services': 'Azure Database Migration Services',
  'microsoft.datamigration/services/projects': 'Azure Database Migration Projects',
  'microsoft.datamigration/sqlmigrationservices': 'Azure Database Migration Services',
  'microsoft.dataprotection/backupvaults': 'Backup vaults',
  'microsoft.dataprotection/resourceguards': 'Resource Guards (Preview)',
  'microsoft.datareplication/replicationvaults': 'Site Recovery Vaults',
  'microsoft.datashare/accounts': 'Data Shares',
  'microsoft.dbformariadb/servers': 'Azure Database for MariaDB servers',
  'microsoft.dbformysql/flexibleservers': 'Azure Database for MySQL flexible servers',
  'microsoft.dbformysql/servers': 'Azure Database for MySQL servers',
  'microsoft.dbforpostgresql/flexibleservers': 'Azure Database for PostgreSQL flexible servers',
  'microsoft.dbforpostgresql/servergroups': 'Azure Database for PostgreSQL server groups',
  'microsoft.dbforpostgresql/servergroupsv2': 'Azure Database for PostgreSQL server groups',
  'microsoft.dbforpostgresql/servers': 'Azure Database for PostgreSQL servers',
  'microsoft.dbforpostgresql/serversv2': 'Azure Database for PostgreSQL servers v2',
  'microsoft.deploymentmanager/rollouts': 'Rollouts',
  'microsoft.desktopvirtualization/applicationgroups': 'Application groups',
  'microsoft.desktopvirtualization/hostpools': 'Host pools',
  'microsoft.desktopvirtualization/scalingplans': 'Scaling plans',
  'microsoft.desktopvirtualization/workspaces': 'Workspaces',
  'microsoft.devices/iothubs': 'IoT Hub',
  'microsoft.devices/provisioningservices': 'Device Provisioning Services',
  'microsoft.deviceupdate/accounts': 'Device Update for IoT Hubs',
  'microsoft.devops/pipelines': 'DevOps Starter',
  'microsoft.devtestlab/labs': 'DevTest Labs',
  'microsoft.devtestlab/labs/virtualmachines': 'Virtual machines',
  'microsoft.digitaltwins/digitaltwinsinstances': 'Azure Digital Twins',
  'microsoft.documentdb/cassandraclusters': 'Azure Managed Instance for Apache Cassandra',
  'microsoft.documentdb/databaseaccounts': 'Azure Cosmos DB accounts',
  'microsoft.domainregistration/domains': 'App Service Domains',
  'microsoft.edgeorder/addresses': 'Azure Edge Hardware Center Address',
  'microsoft.edgeorder/orderitems': 'Azure Edge Hardware Center',
  'microsoft.elastic/monitors': 'Elasticsearch (Elastic Cloud)',
  'microsoft.eventgrid/domains': 'Event Grid Domains',
  'microsoft.eventgrid/partnernamespaces': 'Event Grid Partner Namespaces',
  'microsoft.eventgrid/partnerregistrations': 'Event Grid Partner Registrations',
  'microsoft.eventgrid/partnertopics': 'Event Grid Partner Topics',
  'microsoft.eventgrid/systemtopics': 'Event Grid System Topics',
  'microsoft.eventgrid/topics': 'Event Grid Topics',
  'microsoft.eventhub/clusters': 'Event Hubs Clusters',
  'microsoft.eventhub/namespaces': 'Event Hubs Namespaces',
  'microsoft.experimentation/experimentworkspaces': 'Experiment Workspaces',
  'microsoft.extendedlocation/customlocations': 'Custom locations',
  'microsoft.fidalgo/devcenters': 'Fidalgo DevCenters',
  'microsoft.fidalgo/networksettings': 'Network Configurations',
  'microsoft.fidalgo/projects': 'Fidalgo Projects',
  'microsoft.fidalgo/projects/environments': 'Fidalgo Environments',
  'microsoft.fluidrelay/fluidrelayservers': 'Fluid Relay',
  'microsoft.genomics/accounts': 'Genomics accounts',
  'microsoft.hanaonazure/hanainstances': 'SAP HANA on Azure',
  'microsoft.hanaonazure/sapmonitors': 'Azure Monitors for SAP Solutions',
  'microsoft.hdinsight/clusterpools': 'HDInsight cluster pools',
  'microsoft.hdinsight/clusterpools/clusters': 'HDInsight gen2 clusters',
  'microsoft.hdinsight/clusterpools/clusters/sessionclusters': 'HDInsight session clusters',
  'microsoft.hdinsight/clusters': 'HDInsight clusters',
  'microsoft.healthbot/healthbots': 'Azure Health Bot',
  'microsoft.healthcareapis/services': 'Azure API for FHIR',
  'microsoft.healthcareapis/workspaces': 'Healthcare APIs Workspaces',
  'microsoft.healthcareapis/workspaces/dicomservices': 'DICOM services',
  'microsoft.healthcareapis/workspaces/fhirservices': 'FHIR services',
  'microsoft.healthcareapis/workspaces/iotconnectors': 'IoT connectors',
  'microsoft.hpcworkbench/instances': 'HPC Workbenches (preview)',
  'microsoft.hpcworkbench/instances/chambers': 'Chambers (preview)',
  'microsoft.hpcworkbench/instances/chambers/accessprofiles': 'Chamber Profiles (preview)',
  'microsoft.hpcworkbench/instances/chambers/workloads': 'Chamber VMs (preview)',
  'microsoft.hpcworkbench/instances/consortiums': 'Consortiums (preview)',
  'microsoft.hybridcompute/machines': 'Servers - Azure Arc',
  'microsoft.hybridcompute/privatelinkscopes': 'Azure Arc Private Link Scopes',
  'microsoft.hybridcontainerservice/provisionedclusters': 'Provisioned clusters',
  'microsoft.hybriddata/datamanagers': 'StorSimple Data Managers',
  'microsoft.hybridnetwork/devices': 'Azure Network Function Manager – Devices',
  'microsoft.hybridnetwork/networkfunctions': 'Azure Network Function Manager – Network Functions',
  'microsoft.importexport/jobs': 'Import/export jobs',
  'microsoft.insights/components': 'Application Insights',
  'microsoft.insights/datacollectionendpoints': 'Data collection endpoints',
  'microsoft.insights/datacollectionrules': 'Data collection rules',
  'microsoft.insights/privatelinkscopes': 'Azure Monitor Private Link Scopes',
  'microsoft.insights/webtests': 'Availability tests',
  'microsoft.insights/workbooks': 'Azure Workbooks',
  'microsoft.insights/workbooktemplates': 'Azure Workbook Templates',
  'microsoft.iotcentral/iotapps': 'IoT Central Applications',
  'microsoft.keyvault/vaults': 'Key vaults',
  'microsoft.kubernetes/connectedclusters': 'Kubernetes - Azure Arc',
  'microsoft.kusto/clusters': 'Azure Data Explorer Clusters',
  'microsoft.kusto/clusters/databases': 'Azure Data Explorer Databases',
  'microsoft.labservices/labaccounts': 'Lab accounts',
  'microsoft.labservices/labplans': 'Lab plans',
  'microsoft.labservices/labs': 'Labs',
  'microsoft.loadtestservice/loadtests': 'Azure Load Testing',
  'microsoft.logic/integrationaccounts': 'Integration accounts',
  'microsoft.logic/integrationserviceenvironments': 'Integration Service Environments',
  'microsoft.logic/integrationserviceenvironments/managedapis': 'Managed Connector',
  'microsoft.logic/workflows': 'Logic apps',
  'microsoft.logz/monitors': 'Logz main account',
  'microsoft.logz/monitors/accounts': 'Logz sub account',
  'microsoft.logz/monitors/metricssource': 'Logz metrics data source',
  'microsoft.machinelearning/commitmentplans': 'Machine Learning Studio (classic) web service plans',
  'microsoft.machinelearning/webservices': 'Machine Learning Studio (classic) web services',
  'microsoft.machinelearning/workspaces': 'Machine Learning Studio (classic) workspaces',
  'microsoft.machinelearningservices/workspaces': 'Machine learning',
  'microsoft.machinelearningservices/workspaces/onlineendpoints': 'Machine learning online endpoints',
  'microsoft.machinelearningservices/workspaces/onlineendpoints/deployments': 'Machine learning online deployments',
  'microsoft.maintenance/maintenanceconfigurations': 'Maintenance Configurations',
  'microsoft.managedidentity/userassignedidentities': 'Managed Identities',
  'microsoft.maps/accounts': 'Azure Maps Accounts',
  'microsoft.maps/accounts/creators': 'Azure Maps Creator Resources',
  'microsoft.media/mediaservices': 'Media Services',
  'microsoft.media/mediaservices/liveevents': 'Live events',
  'microsoft.media/mediaservices/streamingendpoints': 'Streaming Endpoints',
  'microsoft.media/videoanalyzers': 'Video Analyzers',
  'microsoft.migrate/projects': 'Migration projects',
  'microsoft.mixedreality/objectanchorsaccounts': 'Object Anchors Accounts',
  'microsoft.mixedreality/objectunderstandingaccounts': 'Object Understanding Accounts',
  'microsoft.mixedreality/remoterenderingaccounts': 'Remote Rendering Accounts',
  'microsoft.mixedreality/spatialanchorsaccounts': 'Spatial Anchors Accounts',
  'microsoft.mobilenetwork/mobilenetworks': 'Mobile Networks',
  'microsoft.mobilenetwork/mobilenetworks/datanetworks': 'Data Networks',
  'microsoft.mobilenetwork/mobilenetworks/services': 'Services',
  'microsoft.mobilenetwork/mobilenetworks/simpolicies': 'Sim Policies',
  'microsoft.mobilenetwork/mobilenetworks/sites': 'Mobile Network Sites',
  'microsoft.mobilenetwork/mobilenetworks/slices': 'Slices',
  'microsoft.mobilenetwork/packetcorecontrolplanes': 'Packet Core Control Planes',
  'microsoft.mobilenetwork/packetcorecontrolplanes/packetcoredataplanes': 'Packet Core Data Planes',
  'microsoft.mobilenetwork/packetcorecontrolplanes/packetcoredataplanes/attacheddatanetworks': 'Attached Data Networks',
  'microsoft.mobilenetwork/sims': 'Sims',
  'microsoft.netapp/netappaccounts': 'NetApp accounts',
  'microsoft.netapp/netappaccounts/capacitypools': 'Capacity pools',
  'microsoft.netapp/netappaccounts/capacitypools/volumes': 'Volumes',
  'microsoft.netapp/netappaccounts/capacitypools/volumes/snapshots': 'Snapshots',
  'microsoft.netapp/netappaccounts/snapshotpolicies': 'Snapshot policies',
  'microsoft.network/applicationgateways': 'Application gateways',
  'microsoft.network/applicationgatewaywebapplicationfirewallpolicies': 'Application Gateway WAF policies',
  'microsoft.network/applicationsecuritygroups': 'Application security groups',
  'microsoft.network/azurefirewalls': 'Firewalls',
  'microsoft.network/bastionhosts': 'Bastions',
  'microsoft.network/connections': 'Connections',
  'microsoft.network/customipprefixes': 'Custom IP Prefixes',
  'microsoft.network/ddosprotectionplans': 'DDoS protection plans',
  'microsoft.network/dnsforwardingrulesets': 'Dns Forwarding Rulesets',
  'microsoft.network/dnsresolvers': 'DNS Private Resolvers',
  'microsoft.network/dnszones': 'DNS zones',
  'microsoft.network/expressroutecircuits': 'ExpressRoute circuits',
  'microsoft.network/expressrouteports': 'ExpressRoute Direct',
  'microsoft.network/firewallpolicies': 'Firewall Policies',
  'microsoft.network/frontdoors': 'Front Doors',
  'microsoft.network/frontdoorwebapplicationfirewallpolicies': 'Web Application Firewall policies (WAF)',
  'microsoft.network/ipgroups': 'IP Groups',
  'microsoft.network/loadbalancers': 'Load balancers',
  'microsoft.network/localnetworkgateways': 'Local network gateways',
  'microsoft.network/natgateways': 'NAT gateways',
  'microsoft.network/networkexperimentprofiles': 'Internet Analyzer profiles',
  'microsoft.network/networkinterfaces': 'Network interfaces',
  'microsoft.network/networkmanagers': 'Network Managers',
  'microsoft.network/networksecuritygroups': 'Network security groups',
  'microsoft.network/networkwatchers': 'Network Watchers',
  'microsoft.network/networkwatchers/connectionmonitors': 'Connection Monitors',
  'microsoft.network/networkwatchers/flowlogs': 'NSG Flow Logs',
  'microsoft.network/privatednszones': 'Private DNS zones',
  'microsoft.network/privateendpoints': 'Private endpoints',
  'microsoft.network/privatelinkservices': 'Private link services',
  'microsoft.network/publicipaddresses': 'Public IP addresses',
  'microsoft.network/publicipprefixes': 'Public IP Prefixes',
  'microsoft.network/routefilters': 'Route filters',
  'microsoft.network/routetables': 'Route tables',
  'microsoft.network/serviceendpointpolicies': 'Service endpoint policies',
  'microsoft.network/trafficmanagerprofiles': 'Traffic Manager profiles',
  'microsoft.network/virtualnetworkgateways': 'Virtual network gateways',
  'microsoft.network/virtualnetworks': 'Virtual networks',
  'microsoft.network/virtualwans': 'Virtual WANs',
  'microsoft.notificationhubs/namespaces': 'Notification Hub Namespaces',
  'microsoft.notificationhubs/namespaces/notificationhubs': 'Notification Hubs',
  'microsoft.openenergyplatform/energyservices': 'Project Oak Forest',
  'microsoft.openlogisticsplatform/workspaces': 'Open Supply Chain Platform',
  'microsoft.operationalinsights/querypacks': 'Log Analytics query packs',
  'microsoft.operationalinsights/workspaces': 'Log Analytics workspaces',
  'microsoft.operationsmanagement/solutions': 'Solutions',
  'microsoft.orbital/contactprofiles': 'Contact Profiles',
  'microsoft.orbital/edgesites': 'Edge Sites',
  'microsoft.orbital/groundstations': 'Ground Stations',
  'microsoft.orbital/l2connections': 'L2 Connections',
  'microsoft.orbital/spacecrafts': 'Spacecrafts',
  'microsoft.peering/peerings': 'Peerings',
  'microsoft.peering/peeringservices': 'Peering Services',
  'microsoft.playfab/playeraccountpools': 'PlayFab player account pools',
  'microsoft.playfab/titles': 'PlayFab titles',
  'microsoft.portal/dashboards': 'Shared dashboards',
  'microsoft.powerbidedicated/capacities': 'Power BI Embedded',
  'microsoft.purview/accounts': 'Microsoft Purview accounts',
  'microsoft.quantum/workspaces': 'Quantum Workspaces',
  'microsoft.recommendationsservice/accounts': 'Intelligent Recommendations Accounts',
  'microsoft.recommendationsservice/accounts/modeling': 'Modeling',
  'microsoft.recommendationsservice/accounts/serviceendpoints': 'Service Endpoints',
  'microsoft.recoveryservices/vaults': 'Recovery Services vaults',
  'microsoft.redhatopenshift/openshiftclusters': 'Azure Red Hat OpenShift',
  'microsoft.relay/namespaces': 'Relays',
  'microsoft.resourceconnector/appliances': 'Resource bridges',
  'microsoft.resourcegraph/queries': 'Resource Graph queries',
  'microsoft.resources/deploymentscripts': 'Deployment Scripts',
  'microsoft.resources/templatespecs': 'Template specs',
  'microsoft.saas/applications': 'Software as a Service (classic)',
  'microsoft.saas/resources': 'SaaS',
  'microsoft.scom/managedinstances': 'Aquila Instances',
  'microsoft.scvmm/virtualmachines': 'SCVMM virtual machine - Azure Arc',
  'microsoft.scvmm/vmmservers': 'SCVMM management servers',
  'microsoft.search/searchservices': 'Search services',
  'microsoft.securitydetonation/chambers': 'Security Detonation Chambers',
  'microsoft.servicebus/namespaces': 'Service Bus Namespaces',
  'microsoft.servicefabric/clusters': 'Service Fabric clusters',
  'microsoft.servicefabric/managedclusters': 'Service Fabric managed clusters',
  'microsoft.serviceshub/connectors': 'Services Hub Connectors',
  'microsoft.signalrservice/signalr': 'SignalR',
  'microsoft.signalrservice/webpubsub': 'Web PubSub Service',
  'microsoft.solutions/applicationdefinitions': 'Service catalog managed application definitions',
  'microsoft.solutions/applications': 'Managed applications',
  'microsoft.sql/instancepools': 'Instance pools',
  'microsoft.sql/managedinstances': 'SQL managed instances',
  'microsoft.sql/managedinstances/databases': 'Managed databases',
  'microsoft.sql/servers': 'SQL servers',
  'microsoft.sql/servers/databases': 'SQL databases',
  'microsoft.sql/servers/elasticpools': 'SQL elastic pools',
  'microsoft.sql/servers/jobagents': 'Elastic Job agents',
  'microsoft.sql/virtualclusters': 'Virtual clusters',
  'microsoft.sqlvirtualmachine/sqlvirtualmachines': 'SQL virtual machines',
  'microsoft.storage/storageaccounts': 'Storage accounts',
  'microsoft.storagecache/amlfilesystems': 'Lustre File Systems',
  'microsoft.storagecache/caches': 'HPC caches',
  'microsoft.storagepool/diskpools': 'Disk Pools',
  'microsoft.storagesync/storagesyncservices': 'Storage Sync Services',
  'microsoft.storagesyncdev/storagesyncservices': 'Storage Sync Services',
  'microsoft.storagesyncint/storagesyncservices': 'Storage Sync Services',
  'microsoft.storsimple/managers': 'StorSimple Device Managers',
  'microsoft.streamanalytics/clusters': 'Stream Analytics clusters',
  'microsoft.streamanalytics/streamingjobs': 'Stream Analytics jobs',
  'microsoft.synapse/privatelinkhubs': 'Azure Synapse Analytics (private link hubs)',
  'microsoft.synapse/workspaces': 'Azure Synapse Analytics',
  'microsoft.synapse/workspaces/bigdatapools': 'Apache Spark pools',
  'microsoft.synapse/workspaces/kustopools': 'Data Explorer pools (preview)',
  'microsoft.synapse/workspaces/sqlpools': 'Dedicated SQL pools',
  'microsoft.testbase/testbaseaccounts': 'Test Base Accounts',
  'microsoft.testbase/testbaseaccounts/packages': 'Test Base Packages',
  'microsoft.timeseriesinsights/environments': 'Time Series Insights environments',
  'microsoft.timeseriesinsights/environments/eventsources': 'Time Series Insights event sources',
  'microsoft.timeseriesinsights/environments/referencedatasets': 'Time Series Insights reference data sets',
  'microsoft.videoindexer/accounts': 'Video Analyzer for Media',
  'microsoft.virtualmachineimages/imagetemplates': 'Image Templates',
  'microsoft.visualstudio/account': 'Azure DevOps organizations',
  'microsoft.visualstudio/account/project': 'DevOps Starter',
  'microsoft.vmwarecloudsimple/dedicatedcloudnodes': 'CloudSimple Nodes',
  'microsoft.vmwarecloudsimple/dedicatedcloudservices': 'CloudSimple Services',
  'microsoft.vmwarecloudsimple/virtualmachines': 'CloudSimple Virtual Machines',
  'microsoft.vsonline/plans': 'Visual Studio Online Plans',
  'microsoft.web/connectiongateways': 'On-premises data gateways',
  'microsoft.web/connections': 'API Connections',
  'microsoft.web/containerapps': 'Container Apps',
  'microsoft.web/customapis': 'Logic Apps Custom Connector',
  'microsoft.web/hostingenvironments': 'App Service Environments',
  'microsoft.web/kubeenvironments': 'App Service Kubernetes Environments',
  'microsoft.web/serverfarms': 'App Service plans',
  'microsoft.web/sites': 'App Services',
  'microsoft.web/sites/slots': 'App Service (Slots)',
  'microsoft.web/staticsites': 'Static Web Apps',
  'microsoft.windowsesu/multipleactivationkeys': 'Windows Multiple Activation Keys',
  'microsoft.windowsiot/deviceservices': 'Windows 10 IoT Core Services',
  'microsoft.workloads/monitors': 'Azure Monitors for SAP Solutions (v2)',
  'microsoft.workloads/phpworkloads': 'Scalable WordPress on Linux',
  'microsoft.workloads/sapvirtualinstances': 'SAP Virtual Instances',
  'microsoft.workloads/sapvirtualinstances/applicationinstances': 'SAP app server instances',
  'microsoft.workloads/sapvirtualinstances/centralinstances': 'SAP central server instances',
  'microsoft.workloads/sapvirtualinstances/databaseinstances': 'SAP database server instances',
  'nginx.nginxplus/nginxdeployments': 'NGINX Deployment',
  'providers.test/statefulibizaengines': 'VLCentral Help',
  'wandisco.fusion/fusiongroups': 'LiveData Planes',
  'wandisco.fusion/fusiongroups/azurezones': 'Azure Zones',
  'wandisco.fusion/fusiongroups/azurezones/plugins': 'Plugins',
  'wandisco.fusion/fusiongroups/hivereplicationrules': 'Hive Replication Rules',
  'wandisco.fusion/fusiongroups/managedonpremzones': 'On-premises Zones',
  'wandisco.fusion/fusiongroups/replicationrules': 'Replication Rules',
  'wandisco.fusion/migrators': 'LiveData Migrators',
  'wandisco.fusion/migrators/exclusiontemplates': 'Exclusions',
  'wandisco.fusion/migrators/livedatamigrations': 'Migrations',
  'wandisco.fusion/migrators/metadatamigrations': 'Metadata Migrations',
  'wandisco.fusion/migrators/metadatatargets': 'Metadata Targets',
  'wandisco.fusion/migrators/pathmappings': 'Path Mappings',
  'wandisco.fusion/migrators/targets': 'Targets',
  'microsoft.security/insights/classification': 'Data Sensitivity Security Insights (Preview)',
  'microsoft.security/locations/alerts': 'Security Alerts',
};

// This list has been manually written using the Azure Portal as the source.
// Visit https://portal.azure.com/#view/Microsoft_Azure_Monitoring/AzureMonitoringBrowseBlade/~/metrics
// and go to Select a scope > Resource types > Multi-resource compatible (preview)
export const multiResourceCompatibleTypes: { [ns: string]: boolean } = {
  'microsoft.cache/redis': true, // 'Azure Cache for Redis'
  'microsoft.dbforpostgresql/flexibleservers': true, // 'Azure Database for PostgreSQL flexible servers'
  'microsoft.storagecache/amlfilesystems': true, // 'Lustre File Systems'
  'microsoft.databoxedge/databoxedgedevices': true, // 'Azure Stack Edge / Data Box Gateway'
  'microsoft.dataprotection/backupvaults': true, // 'Backup vaults'
  'microsoft.netapp/netappaccounts/capacitypools': true, // 'Capacity pools'
  'microsoft.netapp/netappaccounts/capacitypools/volumes': true, // 'Capacity pool volumes'
  'microsoft.network/networkwatchers/connectionmonitors': true, // 'Connection Monitors'
  'microsoft.keyvault/vaults': true, // 'Key vaults'
  'microsoft.recoveryservices/vaults': true, // 'Recovery Services vaults'
  'microsoft.sql/servers/databases': true, // 'SQL databases'
  'microsoft.sql/servers/elasticpools': true, // 'SQL elastic pools'
  'microsoft.compute/virtualmachinescalesets': true, // 'Virtual machine scale sets'
  'microsoft.compute/virtualmachines': true, // 'Virtual machines'
  'microsoft.signalrservice/webpubsub': true, // 'Web PubSub Service'
};

export const resourceTypes = [
  'microsoft.aad/domainservices',
  'microsoft.aadiam/azureadmetrics',
  'microsoft.analysisservices/servers',
  'microsoft.apimanagement/service',
  'microsoft.app/containerapps',
  'microsoft.app/managedenvironments',
  'microsoft.appconfiguration/configurationstores',
  'microsoft.appplatform/spring',
  'microsoft.automation/automationaccounts',
  'microsoft.avs/privateclouds',
  'microsoft.azuresphere/catalogs',
  'microsoft.azurestackhci/clusters',
  'microsoft.azurestackresourcemonitor/storageaccountmonitor',
  'microsoft.batch/batchaccounts',
  'microsoft.batchai/workspaces',
  'microsoft.bing/accounts',
  'microsoft.botservice/botservices',
  'microsoft.botservice/botservices/channels',
  'microsoft.botservice/botservices/connections',
  'microsoft.botservice/checknameavailability',
  'microsoft.botservice/hostsettings',
  'microsoft.botservice/listauthserviceproviders',
  'microsoft.botservice/listqnamakerendpointkeys',
  'microsoft.cache/redis',
  'microsoft.cache/redisenterprise',
  'microsoft.cdn/cdnwebapplicationfirewallpolicies',
  'microsoft.cdn/profiles',
  'microsoft.classiccompute/domainnames',
  'microsoft.classiccompute/domainnames/slots/roles',
  'microsoft.classiccompute/virtualmachines',
  'microsoft.classicstorage/storageaccounts',
  'microsoft.classicstorage/storageaccounts/blobservices',
  'microsoft.classicstorage/storageaccounts/fileservices',
  'microsoft.classicstorage/storageaccounts/queueservices',
  'microsoft.classicstorage/storageaccounts/tableservices',
  'microsoft.cloudtest/hostedpools',
  'microsoft.cloudtest/pools',
  'microsoft.clusterstor/nodes',
  'microsoft.codesigning/codesigningaccounts',
  'microsoft.cognitiveservices/accounts',
  'microsoft.communication/communicationservices',
  'microsoft.compute/cloudservices',
  'microsoft.compute/cloudservices/roles',
  'microsoft.compute/disks',
  'microsoft.compute/virtualmachines',
  'microsoft.compute/virtualmachinescalesets',
  'microsoft.compute/virtualmachinescalesets/virtualmachines',
  'microsoft.connectedcache/cachenodes',
  'microsoft.connectedcache/enterprisemcccustomers',
  'microsoft.connectedcache/ispcustomers',
  'microsoft.connectedvehicle/platformaccounts',
  'microsoft.containerinstance/containergroups',
  'microsoft.containerinstance/containerscalesets',
  'microsoft.containerregistry/registries',
  'microsoft.containerservice/managedclusters',
  'microsoft.customerinsights/hubs',
  'microsoft.customproviders/resourceproviders',
  'microsoft.dashboard/grafana',
  'microsoft.databoxedge/databoxedgedevices',
  'microsoft.datacollaboration/workspaces',
  'microsoft.datafactory/datafactories',
  'microsoft.datafactory/factories',
  'microsoft.datalakeanalytics/accounts',
  'microsoft.datalakestore/accounts',
  'microsoft.dataprotection/backupvaults',
  'microsoft.datashare/accounts',
  'microsoft.dbformariadb/servers',
  'microsoft.dbformysql/flexibleservers',
  'microsoft.dbformysql/servers',
  'microsoft.dbforpostgresql/flexibleservers',
  'microsoft.dbforpostgresql/servergroupsv2',
  'microsoft.dbforpostgresql/servers',
  'microsoft.dbforpostgresql/serversv2',
  'microsoft.devices/iothubs',
  'microsoft.devices/provisioningservices',
  'microsoft.digitaltwins/digitaltwinsinstances',
  'microsoft.documentdb/cassandraclusters',
  'microsoft.documentdb/databaseaccounts',
  'microsoft.documentdb/mongoclusters',
  'microsoft.edgezones/edgezones',
  'microsoft.enterpriseknowledgegraph/services',
  'microsoft.eventgrid/domains',
  'microsoft.eventgrid/eventsubscriptions',
  'microsoft.eventgrid/extensiontopics',
  'microsoft.eventgrid/namespaces',
  'microsoft.eventgrid/partnernamespaces',
  'microsoft.eventgrid/partnertopics',
  'microsoft.eventgrid/systemtopics',
  'microsoft.eventgrid/topics',
  'microsoft.eventhub/clusters',
  'microsoft.eventhub/namespaces',
  'microsoft.fabric.admin/fabriclocations',
  'microsoft.hdinsight/clusters',
  'microsoft.healthcareapis/services',
  'microsoft.healthcareapis/workspaces/dicomservices',
  'microsoft.healthcareapis/workspaces/fhirservices',
  'microsoft.healthcareapis/workspaces/iotconnectors',
  'microsoft.healthmodel/healthmodels',
  'microsoft.hybridcontainerservice/provisionedclusters',
  'microsoft.hybridnetwork/networkfunctions',
  'microsoft.hybridnetwork/virtualnetworkfunctions',
  'microsoft.insights/autoscalesettings',
  'microsoft.insights/components',
  'microsoft.iotcentral/iotapps',
  'microsoft.iotspaces/graph',
  'microsoft.keyvault/managedhsms',
  'microsoft.keyvault/vaults',
  'microsoft.kubernetes/connectedclusters',
  'microsoft.kubernetesconfiguration/extensions',
  'microsoft.kusto/clusters',
  'microsoft.logic/integrationserviceenvironments',
  'microsoft.logic/workflows',
  'microsoft.machinelearningservices/workspaces',
  'microsoft.machinelearningservices/workspaces/onlineendpoints',
  'microsoft.machinelearningservices/workspaces/onlineendpoints/deployments',
  'microsoft.managednetworkfabric/internetgateways',
  'microsoft.managednetworkfabric/l3isolationdomains',
  'microsoft.managednetworkfabric/networkdevices',
  'microsoft.maps/accounts',
  'microsoft.media/mediaservices',
  'microsoft.media/mediaservices/liveevents',
  'microsoft.media/mediaservices/streamingendpoints',
  'microsoft.media/videoanalyzers',
  'microsoft.mixedreality/remoterenderingaccounts',
  'microsoft.mixedreality/spatialanchorsaccounts',
  'microsoft.mobilenetwork/packetcorecontrolplanes',
  'microsoft.mobilenetwork/packetcorecontrolplanes/packetcoredataplanes',
  'microsoft.monitor/accounts',
  'microsoft.netapp/netappaccounts/capacitypools',
  'microsoft.netapp/netappaccounts/capacitypools/volumes',
  'microsoft.network/applicationgateways',
  'microsoft.network/azurefirewalls',
  'microsoft.network/bastionhosts',
  'microsoft.network/connections',
  'microsoft.network/dnsforwardingrulesets',
  'microsoft.network/dnsresolvers',
  'microsoft.network/dnszones',
  'microsoft.network/expressroutecircuits',
  'microsoft.network/expressroutecircuits/peerings',
  'microsoft.network/expressroutegateways',
  'microsoft.network/expressrouteports',
  'microsoft.network/frontdoors',
  'microsoft.network/loadbalancers',
  'microsoft.network/natgateways',
  'microsoft.network/networkinterfaces',
  'microsoft.network/networkmanagers/ipampools',
  'microsoft.network/networkvirtualappliances',
  'microsoft.network/networkwatchers',
  'microsoft.network/networkwatchers/connectionmonitors',
  'microsoft.network/p2svpngateways',
  'microsoft.network/privatednszones',
  'microsoft.network/privateendpoints',
  'microsoft.network/privatelinkservices',
  'microsoft.network/publicipaddresses',
  'microsoft.network/publicipprefixes',
  'microsoft.network/trafficmanagerprofiles',
  'microsoft.network/virtualhubs',
  'microsoft.network/virtualnetworkgateways',
  'microsoft.network/virtualnetworks',
  'microsoft.network/virtualrouters',
  'microsoft.network/vpngateways',
  'microsoft.networkanalytics/dataconnectors',
  'microsoft.networkcloud/baremetalmachines',
  'microsoft.networkcloud/clusters',
  'microsoft.networkcloud/storageappliances',
  'microsoft.networkfunction/azuretrafficcollectors',
  'microsoft.notificationhubs/namespaces/notificationhubs',
  'microsoft.operationalinsights/workspaces',
  'microsoft.operationsmanagement/solutions',
  'microsoft.orbital/contactprofiles',
  'microsoft.orbital/l2connections',
  'microsoft.orbital/spacecrafts',
  'microsoft.orbital/terminals',
  'microsoft.peering/peerings',
  'microsoft.peering/peeringservices',
  'microsoft.playfab/titles',
  'microsoft.powerbidedicated/capacities',
  'microsoft.purview/accounts',
  'microsoft.recoveryservices/vaults',
  'microsoft.relay/namespaces',
  'microsoft.resources/subscriptions',
  'microsoft.search/searchservices',
  'microsoft.securitydetonation/chambers',
  'microsoft.securitydetonation/securitydetonationchambers',
  'microsoft.servicebus/namespaces',
  'microsoft.servicefabricmesh/applications',
  'microsoft.servicenetworking/trafficcontrollers',
  'microsoft.signalrservice/signalr',
  'microsoft.signalrservice/signalr/replicas',
  'microsoft.signalrservice/webpubsub',
  'microsoft.signalrservice/webpubsub/replicas',
  'microsoft.singularity/accounts',
  'microsoft.sql/managedinstances',
  'microsoft.sql/servers/databases',
  'microsoft.sql/servers/elasticpools',
  'microsoft.sql/servers/jobagents',
  'microsoft.storage/storageaccounts',
  'microsoft.storage/storageaccounts/blobservices',
  'microsoft.storage/storageaccounts/fileservices',
  'microsoft.storage/storageaccounts/objectreplicationpolicies',
  'microsoft.storage/storageaccounts/queueservices',
  'microsoft.storage/storageaccounts/storagetasks',
  'microsoft.storage/storageaccounts/tableservices',
  'microsoft.storage/storagetasks',
  'microsoft.storagecache/amlfilesystems',
  'microsoft.storagecache/caches',
  'microsoft.storagemover/storagemovers',
  'microsoft.storagesync/storagesyncservices',
  'microsoft.storagetasks/storagetasks',
  'microsoft.streamanalytics/streamingjobs',
  'microsoft.synapse/workspaces',
  'microsoft.synapse/workspaces/bigdatapools',
  'microsoft.synapse/workspaces/kustopools',
  'microsoft.synapse/workspaces/scopepools',
  'microsoft.synapse/workspaces/sqlpools',
  'microsoft.timeseriesinsights/environments',
  'microsoft.timeseriesinsights/environments/eventsources',
  'microsoft.vmwarecloudsimple/virtualmachines',
  'microsoft.voiceservices/communicationsgateways',
  'microsoft.web/containerapps',
  'microsoft.web/hostingenvironments',
  'microsoft.web/hostingenvironments/multirolepools',
  'microsoft.web/hostingenvironments/workerpools',
  'microsoft.web/serverfarms',
  'microsoft.web/sites',
  'microsoft.web/sites/slots',
  'microsoft.web/staticsites',
  'nginx.nginxplus/nginxdeployments',
  'wandisco.fusion/migrators',
  'wandisco.fusion/migrators/datatransferagents',
  'wandisco.fusion/migrators/livedatamigrations',
  'wandisco.fusion/migrators/metadatamigrations',
];
