/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.MeasurementUnit;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricType;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GaugeMetric
extends Metric {
    private double last;
    private double min;
    private double max;
    private double sum;
    private int count;

    public GaugeMetric(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        super(MetricType.Gauge, key, unit, tags);
        this.last = value2;
        this.min = value2;
        this.max = value2;
        this.sum = value2;
        this.count = 1;
    }

    @Override
    public void add(double value2) {
        this.last = value2;
        this.min = Math.min(this.min, value2);
        this.max = Math.max(this.max, value2);
        this.sum += value2;
        ++this.count;
    }

    public double getLast() {
        return this.last;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    @NotNull
    public Iterable<?> serialize() {
        return Arrays.asList(this.last, this.min, this.max, this.sum, this.count);
    }
}

