/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.Logger;

final class AsyncQueueHandler<T> {
    private static final Logger logger = Logger.getLogger(AsyncQueueHandler.class);
    private final ExecutorService executor;
    private final BlockingQueue<T> queue;
    private final Handler<T> handler;
    private final String id;
    private final long maxSequentiallyHandledItems;
    private boolean running = true;
    private final Object syncRoot = new Object();
    private Future<?> readerFuture;
    private final boolean interruptOnCancel;
    private final Runnable reader = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long sequentiallyHandledItems = 0L;
            while (AsyncQueueHandler.this.running) {
                Object item;
                if (AsyncQueueHandler.this.maxSequentiallyHandledItems > 0L && sequentiallyHandledItems >= AsyncQueueHandler.this.maxSequentiallyHandledItems) {
                    AsyncQueueHandler.this.onYield();
                    return;
                }
                Object object = AsyncQueueHandler.this.syncRoot;
                synchronized (object) {
                    item = AsyncQueueHandler.this.queue.poll();
                    if (item == null) {
                        AsyncQueueHandler.this.running = false;
                        AsyncQueueHandler.this.readerFuture = null;
                        return;
                    }
                }
                ++sequentiallyHandledItems;
                try {
                    AsyncQueueHandler.this.handler.handleItem(item);
                }
                catch (Throwable e) {
                    logger.error("Failed to handle item: ", e);
                }
            }
        }
    };

    AsyncQueueHandler(@NotNull BlockingQueue<T> queue2, @NotNull Handler<T> handler, @NotNull String id, @NotNull ExecutorService executor, long maxSequentiallyHandledItems, boolean interruptOnCancel) {
        this.executor = executor;
        this.queue = queue2;
        this.handler = handler;
        this.id = id;
        this.maxSequentiallyHandledItems = maxSequentiallyHandledItems;
        this.interruptOnCancel = interruptOnCancel;
    }

    void cancel() {
        this.cancel(this.interruptOnCancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleQueueItemsUntilEmpty() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.readerFuture == null || this.readerFuture.isDone()) {
                this.rescheduleReader();
            }
        }
    }

    private void onYield() {
        if (logger.isDebugEnabled()) {
            logger.debug("Yielding AsyncQueueHandler with ID = " + this.id);
        }
        this.rescheduleReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(boolean mayInterruptIfRunning) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.running = false;
            if (this.readerFuture != null) {
                this.readerFuture.cancel(mayInterruptIfRunning);
                this.readerFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleReader() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.running = true;
            this.readerFuture = this.executor.submit(this.reader);
        }
    }

    static interface Handler<T> {
        public void handleItem(T var1);
    }
}

