/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.AdaptiveSourceProjection;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BitrateController;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J \u0010#\u001a\u00020$*\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jitsi/videobridge/cc/allocation/PacketHandler;", "", "clock", "Ljava/time/Clock;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "<init>", "(Ljava/time/Clock;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/event/EventEmitter;)V", "logger", "firstMedia", "Ljava/time/Instant;", "numDroppedPacketsUnknownSsrc", "Ljava/util/concurrent/atomic/AtomicInteger;", "adaptiveSourceProjectionMap", "", "", "Lorg/jitsi/videobridge/cc/AdaptiveSourceProjection;", "transformRtp", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "accept", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "transformRtcp", "lookupOrCreateAdaptiveSourceProjection", "singleAllocation", "Lorg/jitsi/videobridge/cc/allocation/SingleAllocation;", "timeSinceFirstMedia", "Ljava/time/Duration;", "debugState", "Lorg/json/simple/JSONObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nPacketHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketHandler.kt\norg/jitsi/videobridge/cc/allocation/PacketHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1#2:203\n13309#3,2:204\n215#4,2:206\n1855#5,2:208\n1855#5,2:210\n*S KotlinDebug\n*F\n+ 1 PacketHandler.kt\norg/jitsi/videobridge/cc/allocation/PacketHandler\n*L\n165#1:204,2\n180#1:206,2\n190#1:208,2\n192#1:210,2\n*E\n"})
public final class PacketHandler {
    @NotNull
    private final Clock clock;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final EventEmitter<BitrateController.EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @Nullable
    private Instant firstMedia;
    @NotNull
    private final AtomicInteger numDroppedPacketsUnknownSsrc;
    @NotNull
    private final Map<Long, AdaptiveSourceProjection> adaptiveSourceProjectionMap;

    public PacketHandler(@NotNull Clock clock, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext, @NotNull EventEmitter<BitrateController.EventHandler> eventEmitter) {
        Intrinsics.checkNotNullParameter(clock, "clock");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(eventEmitter, "eventEmitter");
        this.clock = clock;
        this.diagnosticContext = diagnosticContext;
        this.eventEmitter = eventEmitter;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.numDroppedPacketsUnknownSsrc = new AtomicInteger(0);
        this.adaptiveSourceProjectionMap = new ConcurrentHashMap();
    }

    public final boolean transformRtp(@NotNull PacketInfo packetInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        VideoRtpPacket videoPacket = (VideoRtpPacket)packetInfo.packetAs();
        if (this.firstMedia == null) {
            this.firstMedia = this.clock.instant();
        }
        AdaptiveSourceProjection adaptiveSourceProjection = this.adaptiveSourceProjectionMap.get(videoPacket.getSsrc());
        if (adaptiveSourceProjection == null) {
            return false;
        }
        AdaptiveSourceProjection adaptiveSourceProjection2 = adaptiveSourceProjection;
        try {
            adaptiveSourceProjection2.rewriteRtp(packetInfo);
            if (PacketInfo.Companion.getEnablePayloadVerification()) {
                String expected = packetInfo.getPayloadVerification();
                String actual = videoPacket.getPayloadVerification();
                if (!Intrinsics.areEqual("", expected) && !Intrinsics.areEqual(expected, actual)) {
                    this.logger.warn("Payload unexpectedly modified! Expected: " + expected + ", actual: " + actual);
                }
            }
            bl = true;
        }
        catch (RewriteException e) {
            this.logger.warn("Failed to rewrite a packet.", e);
            bl = false;
        }
        return bl;
    }

    public final boolean accept(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        VideoRtpPacket videoPacket = (VideoRtpPacket)packetInfo.packetAs();
        AdaptiveSourceProjection adaptiveSourceProjection = this.adaptiveSourceProjectionMap.get(videoPacket.getSsrc());
        if (adaptiveSourceProjection == null) {
            this.logger.debug(() -> PacketHandler.accept$lambda$0(videoPacket));
            this.numDroppedPacketsUnknownSsrc.incrementAndGet();
            return false;
        }
        return adaptiveSourceProjection.accept(packetInfo);
    }

    public final boolean accept(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        AdaptiveSourceProjection adaptiveSourceProjection = this.adaptiveSourceProjectionMap.get(rtcpSrPacket.getSenderSsrc());
        return adaptiveSourceProjection == null || adaptiveSourceProjection.getTargetSsrc() == rtcpSrPacket.getSenderSsrc();
    }

    public final boolean transformRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        AdaptiveSourceProjection adaptiveSourceProjection = this.adaptiveSourceProjectionMap.get(rtcpSrPacket.getSenderSsrc());
        return adaptiveSourceProjection != null ? adaptiveSourceProjection.rewriteRtcp(rtcpSrPacket) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AdaptiveSourceProjection lookupOrCreateAdaptiveSourceProjection(SingleAllocation singleAllocation) {
        MediaSourceDesc source = singleAllocation.getMediaSource();
        String endpointID = singleAllocation.getEndpointId();
        if (source == null) {
            return null;
        }
        Map<Long, AdaptiveSourceProjection> map = this.adaptiveSourceProjectionMap;
        synchronized (map) {
            block8: {
                block7: {
                    boolean bl = false;
                    AdaptiveSourceProjection adaptiveSourceProjection = this.adaptiveSourceProjectionMap.get(source.getPrimarySSRC());
                    if (adaptiveSourceProjection == null) break block7;
                    AdaptiveSourceProjection it = adaptiveSourceProjection;
                    boolean bl2 = false;
                    AdaptiveSourceProjection adaptiveSourceProjection2 = it;
                    return adaptiveSourceProjection2;
                }
                if (!(source.getRtpEncodings().length == 0)) break block8;
                AdaptiveSourceProjection adaptiveSourceProjection = null;
                return adaptiveSourceProjection;
            }
            AdaptiveSourceProjection adaptiveSourceProjection = new AdaptiveSourceProjection(this.diagnosticContext, source, () -> PacketHandler.lookupOrCreateAdaptiveSourceProjection$lambda$6$lambda$3(this, endpointID, source), this.logger);
            this.logger.debug(() -> PacketHandler.lookupOrCreateAdaptiveSourceProjection$lambda$6$lambda$4(source));
            RtpEncodingDesc[] $this$forEach$iv = source.getRtpEncodings();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                RtpEncodingDesc element$iv;
                RtpEncodingDesc it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.adaptiveSourceProjectionMap.put(it.getPrimarySSRC(), adaptiveSourceProjection);
            }
            AdaptiveSourceProjection adaptiveSourceProjection3 = adaptiveSourceProjection;
            return adaptiveSourceProjection3;
        }
    }

    @NotNull
    public final Duration timeSinceFirstMedia() {
        Comparable<Instant> comparable;
        block3: {
            block2: {
                comparable = this.firstMedia;
                if (comparable == null) break block2;
                Instant it = comparable;
                boolean bl = false;
                Duration duration = Duration.between(it, this.clock.instant());
                comparable = duration;
                if (duration != null) break block3;
            }
            Duration duration = Duration.ZERO;
            comparable = duration;
            Intrinsics.checkNotNullExpressionValue(duration, "ZERO");
        }
        return comparable;
    }

    @NotNull
    public final JSONObject debugState(@NotNull DebugStateMode mode) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        JSONObject $this$debugState_u24lambda_u248 = jSONObject = new JSONObject();
        boolean bl = false;
        ((Map)$this$debugState_u24lambda_u248).put("num_dropped_packets_unknown_ssrc", this.numDroppedPacketsUnknownSsrc.intValue());
        ((Map)$this$debugState_u24lambda_u248).put("adaptive_source_projection_map", this.debugState(this.adaptiveSourceProjectionMap, mode));
        return jSONObject;
    }

    private final JSONObject debugState(Map<Long, ? extends AdaptiveSourceProjection> $this$debugState, DebugStateMode mode) {
        JSONObject jSONObject;
        JSONObject it = jSONObject = new JSONObject();
        boolean bl = false;
        Map<Long, ? extends AdaptiveSourceProjection> $this$forEach$iv = $this$debugState;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, ? extends AdaptiveSourceProjection>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, ? extends AdaptiveSourceProjection> element$iv;
            Map.Entry<Long, ? extends AdaptiveSourceProjection> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            AdaptiveSourceProjection adaptiveSourceProjection = entry.getValue();
            Long l = ssrc;
            ((Map)it).put(l, adaptiveSourceProjection.getDebugState(mode));
        }
        return jSONObject;
    }

    public final void allocationChanged(@NotNull BandwidthAllocation allocation) {
        Intrinsics.checkNotNullParameter(allocation, "allocation");
        if (allocation.getAllocations().isEmpty()) {
            Iterable $this$forEach$iv = this.adaptiveSourceProjectionMap.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdaptiveSourceProjection it = (AdaptiveSourceProjection)element$iv;
                boolean bl = false;
                it.setTargetIndex(-1);
            }
        } else {
            Iterable $this$forEach$iv = allocation.getAllocations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdaptiveSourceProjection adaptiveSourceProjection;
                SingleAllocation it = (SingleAllocation)element$iv;
                boolean bl = false;
                RtpLayerDesc rtpLayerDesc = it.getTargetLayer();
                int sourceTargetIdx = rtpLayerDesc != null ? rtpLayerDesc.getIndex() : -1;
                AdaptiveSourceProjection adaptiveSourceProjection2 = adaptiveSourceProjection = this.lookupOrCreateAdaptiveSourceProjection(it);
                if (adaptiveSourceProjection2 == null) continue;
                adaptiveSourceProjection2.setTargetIndex(sourceTargetIdx);
            }
        }
    }

    private static final String accept$lambda$0(VideoRtpPacket $videoPacket) {
        Intrinsics.checkNotNullParameter($videoPacket, "$videoPacket");
        return "Dropping an RTP packet for an unknown SSRC: " + $videoPacket.getSsrc();
    }

    private static final Unit lookupOrCreateAdaptiveSourceProjection$lambda$6$lambda$3$lambda$2(String $endpointID, MediaSourceDesc $source, BitrateController.EventHandler $this$fireEvent) {
        Intrinsics.checkNotNullParameter($endpointID, "$endpointID");
        Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
        $this$fireEvent.keyframeNeeded($endpointID, $source.getPrimarySSRC());
        return Unit.INSTANCE;
    }

    private static final void lookupOrCreateAdaptiveSourceProjection$lambda$6$lambda$3(PacketHandler this$0, String $endpointID, MediaSourceDesc $source) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($endpointID, "$endpointID");
        this$0.eventEmitter.fireEvent(arg_0 -> PacketHandler.lookupOrCreateAdaptiveSourceProjection$lambda$6$lambda$3$lambda$2($endpointID, $source, arg_0));
    }

    private static final String lookupOrCreateAdaptiveSourceProjection$lambda$6$lambda$4(MediaSourceDesc $source) {
        return "new source projection for " + $source;
    }
}

