/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.export;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jitsi.mediajson.Event;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.export.Exporter;
import org.jitsi.videobridge.export.MediaJsonSerializer;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001\u0011\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/videobridge/export/Exporter;", "", "url", "Ljava/net/URI;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Ljava/net/URI;Lorg/jitsi/utils/logging2/Logger;)V", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "queue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "getQueue", "()Lorg/jitsi/nlj/util/PacketInfoQueue;", "queue$delegate", "Lkotlin/Lazy;", "recorderWebSocket", "org/jitsi/videobridge/export/Exporter$recorderWebSocket$1", "Lorg/jitsi/videobridge/export/Exporter$recorderWebSocket$1;", "serializer", "Lorg/jitsi/videobridge/export/MediaJsonSerializer;", "isConnected", "", "doHandlePacket", "packet", "Lorg/jitsi/nlj/PacketInfo;", "send", "", "start", "stop", "Companion", "jitsi-videobridge"})
public final class Exporter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final URI url;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy queue$delegate;
    @NotNull
    private final recorderWebSocket.1 recorderWebSocket;
    @NotNull
    private final MediaJsonSerializer serializer;
    @NotNull
    private static final WebSocketClient webSocketClient;
    @NotNull
    private static final CounterMetric webSocketFailures;

    public Exporter(@NotNull URI url, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.url = url;
        this.logger = logger;
        this.queue$delegate = LazyKt.lazy(() -> Exporter.queue_delegate$lambda$0(this));
        this.recorderWebSocket = new WebSocketAdapter(this){
            final /* synthetic */ Exporter this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebSocketClose(int statusCode, String reason) {
                super.onWebSocketClose(statusCode, reason);
                Unit unit = Unit.INSTANCE;
                Exporter exporter = this.this$0;
                Unit it = unit;
                boolean bl = false;
                exporter.getLogger().info("Websocket closed with status " + statusCode + ", reason: " + reason);
            }

            public void onWebSocketConnect(Session session) {
                super.onWebSocketConnect(session);
                Unit unit = Unit.INSTANCE;
                Exporter exporter = this.this$0;
                Unit it = unit;
                boolean bl = false;
                exporter.getLogger().info("Websocket connected: " + this.isConnected());
            }

            public void onWebSocketError(Throwable cause) {
                super.onWebSocketError(cause);
                Unit unit = Unit.INSTANCE;
                Exporter exporter = this.this$0;
                Unit it = unit;
                boolean bl = false;
                exporter.getLogger().error("Websocket error", cause);
                CounterMetric.inc$default(Exporter.access$getWebSocketFailures$cp(), null, 1, null);
            }
        };
        this.serializer = new MediaJsonSerializer(arg_0 -> Exporter.serializer$lambda$1(this, arg_0));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final PacketInfoQueue getQueue() {
        Lazy lazy = this.queue$delegate;
        return (PacketInfoQueue)lazy.getValue();
    }

    public final boolean isConnected() {
        return this.recorderWebSocket.isConnected();
    }

    private final boolean doHandlePacket(PacketInfo packet) {
        if (this.recorderWebSocket.isConnected()) {
            AudioRtpPacket audioRtpPacket = (AudioRtpPacket)packet.packetAs();
            String string = packet.getEndpointId();
            Intrinsics.checkNotNull(string);
            this.serializer.encode(audioRtpPacket, string);
        }
        ByteBufferPool.returnBuffer(packet.getPacket().buffer);
        return true;
    }

    public final void send(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (this.recorderWebSocket.isConnected()) {
            this.getQueue().add(packet);
        } else {
            ByteBufferPool.returnBuffer(packet.getPacket().buffer);
        }
    }

    public final void start() {
        webSocketClient.connect(this.recorderWebSocket, this.url, new ClientUpgradeRequest());
    }

    public final void stop() {
        Session session = this.recorderWebSocket.getSession();
        if (session != null) {
            session.close(1001, "closing");
        }
        Session session2 = this.recorderWebSocket.getSession();
        if (session2 != null) {
            session2.disconnect();
        }
        this.getQueue().close();
    }

    private static final PacketInfoQueue queue_delegate$lambda$0(Exporter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        String string = this$0.getClass().getSimpleName() + "-packet-queue";
        ExecutorService executorService = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "IO_POOL");
        return new PacketInfoQueue(string, executorService, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this$0){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return Exporter.access$doHandlePacket((Exporter)this.receiver, p0);
            }
        }, 1024);
    }

    private static final Unit serializer$lambda$1(Exporter this$0, Event it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (this$0.recorderWebSocket.isConnected()) {
            RemoteEndpoint remoteEndpoint = this$0.recorderWebSocket.getRemote();
            if (remoteEndpoint != null) {
                remoteEndpoint.sendString(it.toJson());
            } else {
                this$0.logger.warn("Websocket is connected, but remote is null");
            }
        } else {
            this$0.logger.warn("Not connected, cannot send event: " + it);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$doHandlePacket(Exporter $this, PacketInfo packet) {
        return $this.doHandlePacket(packet);
    }

    public static final /* synthetic */ CounterMetric access$getWebSocketFailures$cp() {
        return webSocketFailures;
    }

    static {
        WebSocketClient webSocketClient;
        Companion = new Companion(null);
        WebSocketClient $this$webSocketClient_u24lambda_u242 = webSocketClient = new WebSocketClient();
        boolean bl = false;
        $this$webSocketClient_u24lambda_u242.setIdleTimeout(WebsocketServiceConfig.config.getIdleTimeout());
        $this$webSocketClient_u24lambda_u242.start();
        Exporter.webSocketClient = webSocketClient;
        webSocketFailures = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "exporter_websocket_failures", "Number of websocket connection failures from Exporter", 0L, null, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/export/Exporter$Companion;", "", "<init>", "()V", "webSocketClient", "Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "webSocketFailures", "Lorg/jitsi/metrics/CounterMetric;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

