/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataNs
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -5232680288519805322L;
    private final DnsDomainName nsDName;

    public static DnsRDataNs newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataNs(rawData, offset, length);
    }

    private DnsRDataNs(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.nsDName = DnsDomainName.newInstance(rawData, offset, length);
    }

    private DnsRDataNs(Builder builder2) {
        if (builder2 == null || builder2.nsDName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.nsDName: ").append(builder2.nsDName);
            throw new NullPointerException(sb.toString());
        }
        this.nsDName = builder2.nsDName;
    }

    public DnsDomainName getNsDName() {
        return this.nsDName;
    }

    @Override
    public int length() {
        return this.nsDName.length();
    }

    @Override
    public byte[] getRawData() {
        return this.nsDName.getRawData();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("NS RDATA:").append(ls).append(indent).append("  NSDNAME: ").append(headerRawData != null ? this.nsDName.toString(headerRawData) : this.nsDName.toString()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.nsDName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataNs other = (DnsRDataNs)obj;
        return this.nsDName.equals(other.nsDName);
    }

    public static final class Builder {
        private DnsDomainName nsDName;

        public Builder() {
        }

        private Builder(DnsRDataNs obj) {
            this.nsDName = obj.nsDName;
        }

        public Builder nsDName(DnsDomainName nsDName) {
            this.nsDName = nsDName;
            return this;
        }

        public DnsRDataNs build() {
            return new DnsRDataNs(this);
        }
    }
}

