/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BannerPanel
extends JPanel {
    private static final long serialVersionUID = -7191474275030489327L;
    protected String _title;
    protected String _subtitle;
    protected ImageIcon _titleIcon;
    public static final String TITLE_PROPERTY = "title";
    public static final String SUBTITLE_PROPERTY = "subTitle";
    public static final String ICON_PROPERTY = "icon";
    public static final String ICON_COMPONENT_PROPERTY = "iconComponent";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_SUBTITLE_FONT = "subTitleFont";
    public static final String PROPERTY_TITLE_ICON_LOCATION = "titleIconLocation";
    private JComponent _iconComponent;
    protected int _subTitleIndent = 20;
    protected Font _titleFont;
    protected Color _titleColor;
    protected Font _subTitleFont;
    protected Color _subTitleColor;
    protected Paint _backgroundPaint;
    protected PropertyChangeListener _propertyListener;
    private JLabel _titleLabel;
    private JComponent _subtitleLabel;
    protected Color _startColor;
    protected Color _endColor;
    protected boolean _isVertical;
    private int _titleIconLocation = 11;
    public JPanel _textPanel;

    public BannerPanel() {
        this.lazyInitialize();
    }

    public BannerPanel(String title) {
        this.setTitle(title);
        this.lazyInitialize();
    }

    public BannerPanel(String title, String subtitle) {
        this.setTitle(title);
        this.setSubtitle(subtitle);
        this.lazyInitialize();
    }

    public BannerPanel(String title, String subtitle, ImageIcon titleIcon) {
        this.setTitle(title);
        this.setSubtitle(subtitle);
        this.setTitleIcon(titleIcon);
        this.lazyInitialize();
    }

    public BannerPanel(String title, String subtitle, JComponent iconComponent) {
        this.setTitle(title);
        this.setSubtitle(subtitle);
        this._iconComponent = iconComponent;
        this.lazyInitialize();
    }

    public void lazyInitialize() {
        this.removeAll();
        this._textPanel = new JPanel(new BorderLayout(5, 5));
        this._textPanel.setOpaque(false);
        this._textPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 2, 10));
        if (this.getSubTitleFont() == null) {
            this.setSubTitleFont(this.getFont());
        }
        this._subtitleLabel = this.createSubtitleLabel();
        this._subtitleLabel.setFont(this.getSubTitleFont());
        if (this.getSubTitleColor() == null) {
            this.setSubTitleColor(this.getForeground());
        }
        this._subtitleLabel.setForeground(this.getSubTitleColor());
        this._subtitleLabel.setBorder(BorderFactory.createEmptyBorder(0, this.getSubTitleIndent(), 0, 0));
        this._textPanel.add((Component)this._subtitleLabel, "Center");
        this._titleLabel = new JLabel(this.getTitle()){
            private static final long serialVersionUID = -5832474694740336965L;

            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        if (this.getTitleFont() == null) {
            this.setTitleFont(SecurityUtils.createFont(this.getFont().getFontName(), 1, this.getFont().getSize() + 2));
        }
        this._titleLabel.setFont(this.getTitleFont());
        if (this.getTitleColor() == null) {
            this.setTitleColor(this.getForeground());
        }
        this._titleLabel.setForeground(this.getTitleColor());
        if (this.getSubtitle() != null && this.getSubtitle().length() != 0) {
            this._textPanel.add((Component)this._titleLabel, "First");
        } else {
            this._textPanel.add((Component)this._titleLabel, "Center");
        }
        if (this.getTitleIcon() == null && this._iconComponent == null) {
            this._iconComponent = new JLabel("");
        } else if (this.getTitleIcon() != null || this._iconComponent == null) {
            this._iconComponent = new JLabel(this.getTitleIcon());
        }
        this._iconComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)this._textPanel, "Center");
        this.addIconComponent(this._iconComponent);
        this._propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (BannerPanel.this._titleLabel != null && BannerPanel.TITLE_PROPERTY.equals(evt.getPropertyName())) {
                    BannerPanel.this._titleLabel.setText((String)evt.getNewValue());
                } else if (BannerPanel.this._subtitleLabel != null && BannerPanel.SUBTITLE_PROPERTY.equals(evt.getPropertyName())) {
                    String text = (String)evt.getNewValue();
                    if (BannerPanel.this._subtitleLabel instanceof JTextArea) {
                        ((JTextArea)BannerPanel.this._subtitleLabel).setText(text);
                    } else if (BannerPanel.this._subtitleLabel instanceof JLabel) {
                        ((JLabel)BannerPanel.this._subtitleLabel).setText(text);
                    }
                    if (text != null && text.length() != 0) {
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this._titleLabel, "First");
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this._subtitleLabel, "Center");
                    } else {
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this._titleLabel, "Center");
                    }
                } else if (BannerPanel.ICON_PROPERTY.equals(evt.getPropertyName())) {
                    if (BannerPanel.this._iconComponent instanceof JLabel) {
                        ((JLabel)BannerPanel.this._iconComponent).setIcon(BannerPanel.this.getTitleIcon());
                    }
                } else if (BannerPanel.ICON_COMPONENT_PROPERTY.equals(evt.getPropertyName())) {
                    if (evt.getOldValue() instanceof JComponent) {
                        BannerPanel.this._textPanel.remove((JComponent)evt.getOldValue());
                    }
                    if (evt.getNewValue() instanceof JComponent) {
                        BannerPanel.this.addIconComponent((JComponent)evt.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_TITLE_FONT.equals(evt.getPropertyName())) {
                    if (BannerPanel.this._titleLabel != null) {
                        BannerPanel.this._titleLabel.setFont((Font)evt.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_SUBTITLE_FONT.equals(evt.getPropertyName())) {
                    if (BannerPanel.this._subtitleLabel != null) {
                        BannerPanel.this._subtitleLabel.setFont((Font)evt.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_TITLE_ICON_LOCATION.equals(evt.getPropertyName())) {
                    BannerPanel.this.addIconComponent(BannerPanel.this._iconComponent);
                }
            }
        };
        this.addPropertyChangeListener(this._propertyListener);
    }

    protected JComponent createSubtitleLabel() {
        return new MultilineLabel(this.getSubtitle()){
            private static final long serialVersionUID = -1609681547852636926L;

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
    }

    private void addIconComponent(JComponent component) {
        if (component != null) {
            switch (this.getTitleIconLocation()) {
                case 3: {
                    this.add((Component)component, "East");
                    break;
                }
                case 7: {
                    this.add((Component)component, "West");
                    break;
                }
                case 10: {
                    this.add((Component)component, "Before");
                    break;
                }
                case 11: {
                    this.add((Component)component, "After");
                }
            }
        }
    }

    protected ImageIcon prepareTitleIcon(ImageIcon icon) {
        return icon;
    }

    public Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this._backgroundPaint = backgroundPaint;
    }

    public void setGradientPaint(Color startColor, Color endColor, boolean isVertical) {
        this.setStartColor(startColor);
        this.setEndColor(endColor);
        this.setVertical(isVertical);
    }

    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.getStartColor() != null && this.getEndColor() != null) {
            JideSwingUtilities.fillGradient((Graphics2D)g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.getStartColor(), this.getEndColor(), this.isVertical());
        } else if (this.getBackgroundPaint() != null) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setPaint(this.getBackgroundPaint());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        String old = this._title;
        this._title = title;
        this.firePropertyChange(TITLE_PROPERTY, old, this._title);
    }

    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        String old = this._subtitle;
        this._subtitle = subtitle;
        this.firePropertyChange(SUBTITLE_PROPERTY, old, this._subtitle);
    }

    public ImageIcon getTitleIcon() {
        return this._titleIcon;
    }

    public void setTitleIcon(ImageIcon titleIcon) {
        ImageIcon old = this._titleIcon;
        this._titleIcon = this.prepareTitleIcon(titleIcon);
        this.firePropertyChange(ICON_PROPERTY, old, this._titleIcon);
    }

    public JComponent getIconComponent() {
        return this._iconComponent;
    }

    public void setIconComponent(JComponent iconComponent) {
        JComponent old = this._iconComponent;
        this._iconComponent = iconComponent;
        this.firePropertyChange(ICON_COMPONENT_PROPERTY, old, this._iconComponent);
    }

    public Font getSubTitleFont() {
        return this._subTitleFont;
    }

    public void setSubTitleFont(Font subTitleFont) {
        Font old = this._subTitleFont;
        this._subTitleFont = subTitleFont;
        this.firePropertyChange(PROPERTY_SUBTITLE_FONT, old, this._subTitleFont);
    }

    public Font getTitleFont() {
        return this._titleFont;
    }

    public void setTitleFont(Font titleFont) {
        Font old = this._titleFont;
        this._titleFont = titleFont;
        this.firePropertyChange(PROPERTY_TITLE_FONT, old, this._titleFont);
    }

    public int getSubTitleIndent() {
        return this._subTitleIndent;
    }

    public void setSubTitleIndent(int subTitleIndent) {
        this._subTitleIndent = subTitleIndent;
    }

    public Color getTitleColor() {
        return this._titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this._titleColor = titleColor;
        if (this._titleLabel != null) {
            this._titleLabel.setForeground(titleColor);
        }
    }

    public Color getSubTitleColor() {
        return this._subTitleColor;
    }

    public void setSubTitleColor(Color subTitleColor) {
        this._subTitleColor = subTitleColor;
        if (this._subtitleLabel != null) {
            this._subtitleLabel.setForeground(subTitleColor);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this._titleLabel != null) {
            this._titleLabel.setBackground(bg);
        }
        if (this._subtitleLabel != null) {
            this._subtitleLabel.setBackground(bg);
        }
        if (this._iconComponent != null) {
            this._iconComponent.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.setTitleColor(fg);
        this.setSubTitleColor(fg);
        if (this._iconComponent != null) {
            this._iconComponent.setForeground(fg);
        }
    }

    public Color getStartColor() {
        return this._startColor;
    }

    public void setStartColor(Color startColor) {
        this._startColor = startColor;
    }

    public Color getEndColor() {
        return this._endColor;
    }

    public void setEndColor(Color endColor) {
        this._endColor = endColor;
    }

    public boolean isVertical() {
        return this._isVertical;
    }

    public void setVertical(boolean vertical) {
        this._isVertical = vertical;
    }

    public int getTitleIconLocation() {
        return this._titleIconLocation;
    }

    public void setTitleIconLocation(int titleIconLocation) {
        int old = this._titleIconLocation;
        if (old != titleIconLocation) {
            this._titleIconLocation = titleIconLocation;
            this.firePropertyChange(PROPERTY_TITLE_ICON_LOCATION, old, this._titleIconLocation);
        }
    }

    public JComponent getTitleLabel() {
        return this._titleLabel;
    }

    public JComponent getSubtitleLabel() {
        return this._subtitleLabel;
    }
}

