# Supporting local rules of EPUB files

EPUB files that generated by Re:VIEW (review-epubmaker) should be valid in eubcheck in IDPF.

But some e-book stores have their own rules, so they reject EPUB files by Re:VIEW.  To pass their rules, you can customize OPF file with config.yml.

## EBPAJ EPUB 3 File Creation Guide

* http://ebpaj.jp/counsel/guide

EBPAJ, the Electronic Book Publishers Association of Japan, releases the guide for publishers to create EPUB files that make nothing of trouble in major EPUB readers.

To pass their guide, you can add some settings into config.yml:

```yaml
opf_prefix: {ebpaj: "http://www.ebpaj.jp/"}
opf_meta: {"ebpaj:guide-version": "1.1.3"}
```

With this settings, Re:VIEW generates OPF files with epbaj attributes:

```xml
<package ... prefix="ebpaj: http://www.ebpaj.jp/">
  ...
    <meta property="ebpaj:guide-version">1.1.3</meta>
```

But EPUB files that Re:VIEW generates are not the same of name and structure to EBPAJ guide.


## iBookStore

Without special setting, iBooks has a margin between right page and left page in double-page spread.

To remove it, you can add some settings in config.yml.

```yaml
opf_prefix: {ibooks: "http://vocabulary.itunes.apple.com/rdf/ibooks/vocabulary-extensions-1.0/"}
opf_meta: {"ibooks:binding": "false"}
```

If you have already some settings, merge them:

```yaml
opf_prefix: {ebpaj: "http://www.ebpaj.jp/", ibooks: "http://vocabulary.itunes.apple.com/rdf/ibooks/vocabulary-extensions-1.0/"}
opf_meta: {"ebpaj:guide-version": "1.1.3", "ibooks:binding": "false"}
```

## Amazon Kindle

For Kindle, you need to convert EPUB to mobi format using KindleGen, which Amazon distributes.

- https://www.amazon.com/gp/feature.html?ie=UTF8&docId=1000765211

After installation, you can convert EPUB with `kindlegen EPUB file`.

KindleGen is also included in Kindle Previewer.

- https://kdp.amazon.co.jp/ja_JP/help/topic/G202131170

Note: if there is only a "logical" table of contents, KindleGen reports a strange error.  To include "physical" table of contents, set config.yml as follows.

```yaml
epubmaker:
  toc: true
```

You may be warned about some CSS can't be handled in Kindle. "Amazon Kindle Publishing Guidelines" describes in detail the usable characters, restrictions on hyperlinks to the outside, usage of colors, image size, and so on.

- http://kindlegen.s3.amazonaws.com/AmazonKindlePublishingGuidelines_JP.pdf
