/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public final class VMID
implements Serializable {
    static final long serialVersionUID = -538642295484486218L;
    static final boolean areWeUnique;
    static byte[] localAddr;
    private byte[] addr = localAddr;
    private UID uid = new UID();

    public static final boolean isUnique() {
        return areWeUnique;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof VMID)) {
            return false;
        }
        VMID other = (VMID)obj;
        if (this.addr.length != other.addr.length) {
            return false;
        }
        int i = this.addr.length - 1;
        while (i >= 0) {
            if (this.addr[i] != other.addr[i]) {
                return false;
            }
            --i;
        }
        return this.uid.equals(other.uid);
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("[VMID: ");
        int i = 0;
        while (i < this.addr.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(Integer.toString(this.addr[i]));
            ++i;
        }
        buf.append(" ");
        buf.append(this.uid.toString());
        buf.append("]");
        return buf.toString();
    }

    static {
        byte[] addr;
        boolean awu = true;
        try {
            addr = InetAddress.getLocalHost().getAddress();
            if (addr[0] == 127 && addr[1] == 0 && addr[2] == 0 && addr[3] == 1) {
                awu = false;
            }
        }
        catch (UnknownHostException _) {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            addr = byArray;
            awu = false;
        }
        localAddr = addr;
        areWeUnique = awu;
    }
}

