/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

public class XSLAnalyzeString
extends StyleElement {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private StyleElement matching;
    private StyleElement nonMatching;
    private RegularExpression pattern;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        String regexAtt = null;
        String flagsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("regex")) {
                regexAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("flags")) {
                flagsAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
            selectAtt = ".";
        }
        this.select = this.makeExpression(selectAtt);
        if (regexAtt == null) {
            this.reportAbsence("regex");
            regexAtt = "xxx";
        }
        this.regex = this.makeAttributeValueTemplate(regexAtt);
        if (flagsAtt == null) {
            flagsAtt = "";
        }
        this.flags = this.makeAttributeValueTemplate(flagsAtt);
        if (this.regex instanceof StringLiteral && this.flags instanceof StringLiteral) {
            try {
                String regex = ((StringLiteral)this.regex).getStringValue();
                String flagstr = ((StringLiteral)this.flags).getStringValue();
                ArrayList<String> warnings = new ArrayList<String>();
                this.pattern = Configuration.getPlatform().compileRegularExpression(regex, flagstr, this.getEffectiveVersion().equals(DecimalValue.THREE) ? "XP30" : "XP20", warnings);
                for (String w : warnings) {
                    this.issueWarning(w, this);
                }
                if (this.pattern.matches("")) {
                    this.invalidRegex("The regular expression must not be one that matches a zero-length string", "XTDE1150");
                }
            }
            catch (XPathException err) {
                if ("FORX0001".equals(err.getErrorCodeLocalPart())) {
                    this.invalidRegex("Error in regular expression flags: " + err, "XTDE1145");
                }
                this.invalidRegex("Error in regular expression: " + err, "XTDE1140");
            }
        }
    }

    private void invalidRegex(String message, String errorCode) throws XPathException {
        this.compileError(message, errorCode);
        this.pattern = Configuration.getPlatform().compileRegularExpression("x", "", "XP20", null);
    }

    public void validate(Declaration decl) throws XPathException {
        Object curr;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (curr instanceof XSLFallback) continue;
            if (curr instanceof XSLMatchingSubstring) {
                boolean b = curr.getLocalPart().equals("matching-substring");
                if (b) {
                    if (this.matching != null) {
                        this.compileError("xsl:matching-substring element must only appear once", "XTSE0010");
                    }
                    this.matching = (StyleElement)curr;
                    continue;
                }
                if (this.nonMatching != null) {
                    this.compileError("xsl:non-matching-substring element must only appear once", "XTSE0010");
                }
                this.nonMatching = (StyleElement)curr;
                continue;
            }
            this.compileError("Only xsl:matching-substring and xsl:non-matching-substring are allowed here", "XTSE0010");
        }
        if (this.matching == null && this.nonMatching == null) {
            this.compileError("At least one xsl:matching-substring or xsl:non-matching-substring element must be present", "XTSE1130");
        }
        this.select = this.typeCheck("select", this.select);
        this.regex = this.typeCheck("regex", this.regex);
        this.flags = this.typeCheck("flags", this.flags);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Expression matchingBlock = null;
        if (this.matching != null) {
            matchingBlock = this.matching.compileSequenceConstructor(exec, decl, this.matching.iterateAxis((byte)3), false);
        }
        Expression nonMatchingBlock = null;
        if (this.nonMatching != null) {
            nonMatchingBlock = this.nonMatching.compileSequenceConstructor(exec, decl, this.nonMatching.iterateAxis((byte)3), false);
        }
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            return new AnalyzeString(this.select, this.regex, this.flags, matchingBlock == null ? null : matchingBlock.simplify(visitor), nonMatchingBlock == null ? null : nonMatchingBlock.simplify(visitor), this.pattern);
        }
        catch (XPathException e) {
            this.compileError(e);
            return null;
        }
    }
}

