'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH job n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
job \- Invoke Tcl procedures at regular intervals.
.BE

.SH DESCRIPTION
The \fBjob\fR command provides a convenient mechanism to implement Tcl
procedures that are invoked at regular intervals. Jobs are activated
from the Tcl event loop. Every job can have arbitrary attributes to
store job specific state information between two invocations. These
attributes help to avoid global variables in order to keep the Tcl
name-space clean.

The job scheduler itself relies heavily on the Tcl timer interface
which itself depends on the system clock. Moving the system clock
backwards can have the effect that jobs are not activated for the
amount of time the system clock was moved backwards. Similarly, moving
the system clock forward can have the effect that jobs are activated
earlier for the amount of time the system clock was moved forward.

.SH JOB COMMAND
The \fBjob\fR command allows to create new jobs and to wait for jobs
to complete. The \fBjob\fR command can also be used to retrieve status
information from the job scheduler.
.TP
.B job create \fR[\fIoption value\fR ...]
The \fBjob create\fR command creates a new job object. The
\fIoptions\fR can be used to configure the behaviour of the new
job. See the configure command below for the details.
.TP
.B job current
The \fBjob current\fR command returns the name of the currently
running job. An empty string is returned if no job is running.
.TP
.B job info
The \fBjob info\fR command returns a list of all job names. The list
will be empty if there are no jobs known in this Tcl interpreter.
.TP
.B job schedule
The \fBjob schedule\fR command invoke the scheduler. This is usually
done automatically from the event loop. This command may be used
during long computations since the scheduler is not preemptive. Note,
this command can cause arbitrary side effects and should be used with
care.
.TP
.B job wait
The \fBjob wait\fR command blocks until all existing jobs have been
finished. The command will wait infinitely if there is at least one
job left. Events are processed while waiting for the jobs to finish
which can have arbitrary side effects.

.SH JOB INSTANCE COMMAND
Every job is represented by a job object command which allows to
manipulate the job.
.TP
.B job# attribute \fR[\fIname \fR[\fIvalue\fR]\fR]
The \fBjob# attribute\fR command allows to save job specific data in
job attributes. If called without any arguments, all existing
attribute names for this job will be returned. If called with a name
argument, the current value of the attribute will be
returned. Non-existing attributes do not produce an error. Instead, an
empty string is returned. Calling the option with a name and a value
causes the value to be saved in the job attribute.
.TP
.B job# cget \fIoption\fR
The \fBjob# cget\fR command returns the current value of a
configuration option. See the description of supported options below.
.TP
.B job# configure \fR[\fIoption value\fR ...]
The \fBjob# configure\fR command manipulates configuration options.
See the description of supported options below. A list describing all
current options is returns if the \fIoptions\fR argument is missing.
.TP
.B job# destroy
The \fBjob# destroy\fR command destroys the job object. This command
forces the object to change into the expired state. The scheduler will
cleanup this object the next time it is active.
.TP
.B job# wait
The \fBjob# wait\fR command blocks and processes events until the
current job changes into the expired state.

.SH JOB OPTIONS
Every job has associated configuration options which control when a
job is activated and which Tcl command is bound to the job.
.TP
.BI "-command " command
The \fB-command\fR option defines the Tcl command that is evaluated 
whenever the job is activated.
.TP
.BI "-interval " time
The \fB-interval\fR option defines the time interval between two job 
activations in milliseconds. 
.TP
.BI "-iterations " number
The \fB-iterations\fR option defines the total number of times that a
job is activated. If this value reaches 0, the job will change its
state to expired. Note, if the iterations options is never used, it
will also have the value 0 but nothing special happens to the job
object.
.TP
.BI "-status " state
The \fB-status\fR option provides access to the current job state. A
job is always in one of the states waiting, suspended, running and
expired. A job in the expired state will be removed from the system
once the scheduler gets activated again. Suspended jobs are not
activated by the job scheduler. A suspended job can be resumed by
changing its state to running.
.TP
.BI "-time " time
The \fB-time\fR option returns the number of milliseconds until this
job is activated the next time. This option is read-only.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
