/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import java.nio.ByteBuffer;

public class ByteBufferFactory {
    public static int defaultCapacity = 8192;
    public static int capacity = 4000000;
    private static ByteBuffer directByteBuffer;
    private static ByteBuffer heapByteBuffer;

    private ByteBufferFactory() {
    }

    public static synchronized ByteBuffer allocateView(int size, boolean direct) {
        if (direct && (directByteBuffer == null || directByteBuffer.capacity() - directByteBuffer.limit() < size)) {
            directByteBuffer = ByteBuffer.allocateDirect(capacity);
        } else if (heapByteBuffer == null || heapByteBuffer.capacity() - heapByteBuffer.limit() < size) {
            heapByteBuffer = ByteBuffer.allocate(capacity);
        }
        ByteBuffer byteBuffer = direct ? directByteBuffer : heapByteBuffer;
        byteBuffer.limit(byteBuffer.position() + size);
        ByteBuffer view = byteBuffer.slice();
        byteBuffer.position(byteBuffer.limit());
        return view;
    }

    public static synchronized ByteBuffer allocateView(boolean direct) {
        return ByteBufferFactory.allocateView(defaultCapacity, direct);
    }

    public static ByteBuffer allocate(ByteBufferType type, int size) {
        if (type == ByteBufferType.HEAP) {
            return ByteBuffer.allocate(size);
        }
        if (type == ByteBufferType.HEAP_VIEW) {
            return ByteBufferFactory.allocateView(size, false);
        }
        if (type == ByteBufferType.HEAP_ARRAY) {
            return ByteBuffer.wrap(new byte[size]);
        }
        if (type == ByteBufferType.DIRECT) {
            return ByteBuffer.allocateDirect(size);
        }
        if (type == ByteBufferType.DIRECT_VIEW) {
            return ByteBufferFactory.allocateView(size, true);
        }
        throw new IllegalStateException("Invalid ByteBuffer Type");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ByteBufferType {
        DIRECT,
        HEAP,
        DIRECT_VIEW,
        HEAP_VIEW,
        HEAP_ARRAY;

    }
}

