/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/
// with a little help of Jakob Calero ( nelien @ sf.net )
package GoGrinder.ui;

import java.awt.*;
import javax.swing.*;
import java.nio.charset.Charset;
import java.awt.event.*;
import java.io.File;
import java.util.*;

import GoGrinder.*;

/**
 *
 * @author  Tim
 * @author  Ruediger Klehn
 */
public class SettingsDialog extends javax.swing.JDialog {
    private JTextField sgfTF1;
    private JTextField sgfTF2;
//    private boolean textEditAllowed = GS.getAllowTextEdit();
    private JCheckBox show2ndEditorButtonCB;
//    private boolean show2ndEditorButton = GS.getShow2ndEditorButton();
    
//    private boolean enableWGFEditor = GS.getEnableWGFEditor();
    private JCheckBox allowTextEditCB;
    private JCheckBox enableWGFEditorCB;
    private JCheckBox rightAdvCB;
    private JCheckBox autoAdvCB;
    private JCheckBox clickSoundCB;
    private JCheckBox flipCB;
    private JCheckBox flipColorsCB;
    private JCheckBox showGhostCB;
    private JCheckBox showWrongPathCB;
    private JCheckBox soundCB;
    private JCheckBox sortDirsCB;
    private JComboBox charSetComBox;
        
    /** Creates new form SettingsDialog */
    public SettingsDialog(Frame parent) {
        super(parent, true);
        setTitle(Messages.getString("gg_settings")); //$NON-NLS-1$
        Container cp = getContentPane();
        
        Box topPanel = new Box(BoxLayout.Y_AXIS);
        Box boxTopCBs = new Box(BoxLayout.X_AXIS);
        Box topLeftPanel = new Box(BoxLayout.Y_AXIS);
        
        
        autoAdvCB = new JCheckBox();
        autoAdvCB.setText(Messages.getString("auto_adv_to_next_prob")); //$NON-NLS-1$
        topLeftPanel.add(autoAdvCB);
        
        rightAdvCB = new JCheckBox();
        rightAdvCB.setText(Messages.getString("SettingsDialog.AdvanceOnRightClick")); //$NON-NLS-1$
        topLeftPanel.add(rightAdvCB);
         
         // HERE COULD BE a bar between the checkboxes (first part is navigation, second is presentation
        
        flipCB = new JCheckBox();
        flipCB.setText(Messages.getString("rand_rot_flip")); //$NON-NLS-1$
        topLeftPanel.add(flipCB);

        flipColorsCB = new JCheckBox();
        flipColorsCB.setText(Messages.getString("rand_swap_colors")); //$NON-NLS-1$
        topLeftPanel.add(flipColorsCB);
        
         // HERE COULD BE a bar between the checkboxes : display ... action

        showGhostCB = new JCheckBox();
        showGhostCB.setText("Ghost stone"); //$NON-NLS-1$
        showGhostCB.setToolTipText(Messages.getString("show_ghost"));
        topLeftPanel.add(showGhostCB);

        showWrongPathCB = new JCheckBox();
        showWrongPathCB.setText(Messages.getString("disp_failed_early")); //$NON-NLS-1$
        topLeftPanel.add(showWrongPathCB);

         // HERE COULD BE a bar between the checkboxes : sound
         
        clickSoundCB = new JCheckBox();
        clickSoundCB.setText(Messages.getString("enable_stone_sound")); //$NON-NLS-1$
        topLeftPanel.add(clickSoundCB);

        soundCB = new JCheckBox();
        soundCB.setText(Messages.getString("enable_right_wrong_sound")); //$NON-NLS-1$
        topLeftPanel.add(soundCB);
        boxTopCBs.add(topLeftPanel);
        
        sortDirsCB = new JCheckBox();
        sortDirsCB.setText("Sort entries (selection window)"); //$NON-NLS-1$
        sortDirsCB.setToolTipText("<HTML>Sorted directory entries, update the display with <BR>" 
                                + "the refresh button in the selection window</HTML>");
        topLeftPanel.add(sortDirsCB);

        boxTopCBs.add(Box.createHorizontalGlue());
   // ######################## select MyDefaultCharset begin #####################################
/*##*/  Box topRightPanel = new Box(BoxLayout.Y_AXIS);
        topRightPanel.add(Box.createVerticalStrut(5));
        
/*##*/  Box boxCharsetLabel = new Box(BoxLayout.X_AXIS);
        
        JLabel charsetsLabel = new JLabel("Standard decoding:");
        boxCharsetLabel.add(charsetsLabel);
        topRightPanel.add(boxCharsetLabel);

        String[] availCharSetsStrA;
        //JComboBox charSetComBox; // JComboBox(Vector<?> items) so e.g. Set
//        String selectedEncoding = "";
        Set<String> availCharSets = new HashSet<String>();
        availCharSets.addAll(Charset.availableCharsets().keySet());
        availCharSetsStrA = availCharSets.toArray(new String [availCharSets.size()]);
        Arrays.sort(availCharSetsStrA);
/*##*/  charSetComBox = new JComboBox (availCharSetsStrA);
        charSetComBox.setSelectedItem(GS.getMyDefaultCharset());
        
        Dimension dim2 = new Dimension(150,30);
        charSetComBox.setMaximumSize(dim2);
        

//        boxCharsetCB.add(charsetsLabel);

        String charsetToolTip = "<HTML>This setting is interesting, when you use MyGoGrinder as <BR>"
                              + "portable application from e.g. a USB stick: in Windows systems <BR>"
                              + "Java decodes text from files usually with a local decoding, while <BR>"
                              + "in Linux and MacOS UTF-8 is used. This changes the default decoding <BR>"
                              + "for SGF files and import tags files (export is done with UTF-8).</HTML>";
        charSetComBox.setToolTipText(charsetToolTip);
/*##*/  Box boxCharsetCB = new Box(BoxLayout.Y_AXIS);
        boxCharsetCB.add(charSetComBox, BorderLayout.NORTH);
        boxCharsetCB.add(Box.createVerticalGlue());
        topRightPanel.add(boxCharsetCB);
   // ######################### select MyDefaultCharset end ##############################
        boxTopCBs.add(topRightPanel);
        boxTopCBs.add(Box.createHorizontalStrut(5));

         // HERE COULD BE a bar between the chapters : editors
        topPanel.add(boxTopCBs);
        topPanel.add(Box.createVerticalStrut(10));
        
//        Component verticalStrut = Box.createVerticalStrut(2);
//        verticalStrut.setBackground(Color.GRAY); 
// doesn't work: I want to have a dividing line between the chapters
//        topPanel.add(verticalStrut);
//        topPanel.add(Box.createVerticalStrut(3));
        
        //topPanel.add(Box.createVerticalStrut(3));
        
        // set the preferred editor as button (selected from settings with radio button (one or the other) or checkbox)
        // all editors in a menu (cgoban, multigo, quarry, jedit, notepad2, fast editors in Lnx/Mac?)
        // when an editor is not set, there is "editor 2 not set" etc. in the menu
        Box box1stEd1stLine = new Box(BoxLayout.X_AXIS);

        String sgfTFToolTip = "<HTML>Browse to the desired editor or edit the text field <BR/>"
                           + "(enter the <B>full</B> path to the editor!);<BR/>" // "\n" doesn't work in tooltips
                           + "<b>switches</b> (eg. -edit) <B>and composed starters</B> <BR/>"
                           + "(e.g. \"/path/to/java\" -jar \"/path/to/cgoban.jar\" -edit) <B>are possible</B>! <BR/>"
                           + "No more need to use a .bat/.cmd file resp. a shell script (.sh) instead.</HTML>";
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        // the user gets 10 seconds to read the tooltip - we reset this to 4 seconds, when we close this window

        box1stEd1stLine.add(Box.createHorizontalStrut(5));
        box1stEd1stLine.add(new JLabel("1st " + Messages.getString("SettingsDialog.SGFEditor") + " ")); //$NON-NLS-1$
        box1stEd1stLine.add(Box.createHorizontalGlue());
        
        JButton browse = new JButton(Messages.getString("SettingsDialog.Browse")); //$NON-NLS-1$
        browse.setToolTipText(sgfTFToolTip);
        browse.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              sgfTF1.setText(onBrowseEditor(sgfTF1.getText()));
            }
        });
        box1stEd1stLine.add(browse);
        box1stEd1stLine.add(Box.createHorizontalStrut(3));
        JButton testEditor1 = new JButton("Test editor 1"); //$NON-NLS-1$ // Messages.getString("SettingsDialog.Browse")
        testEditor1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              onTestEditorStarter(sgfTF1.getText());
            }
        });
        box1stEd1stLine.add(testEditor1);
        box1stEd1stLine.add(Box.createHorizontalStrut(5));
        topPanel.add(box1stEd1stLine);
         
        Box box1stEd2ndLine = new Box(BoxLayout.X_AXIS);
        sgfTF1 = new JTextField();
        sgfTF1.setToolTipText(sgfTFToolTip);
        box1stEd2ndLine.add(Box.createHorizontalStrut(20));
        box1stEd2ndLine.add(sgfTF1);
        box1stEd2ndLine.add(Box.createHorizontalGlue());
        box1stEd2ndLine.add(Box.createHorizontalStrut(10));
        topPanel.add(box1stEd2ndLine);

        topPanel.add(Box.createVerticalStrut(5));
        
// ############# 2ND EDITOR begin #########################
       // BOX2B TEXT FIELD 2ND EDITOR + BUTTONS BROWSE + TEST 
        Box box2ndEd1stLine = new Box(BoxLayout.X_AXIS);
        box2ndEd1stLine.add(Box.createHorizontalStrut(5));
        
        box2ndEd1stLine.add(new JLabel("2nd SGF editor (or text editor): ")); // Messages.getString("SettingsDialog.SGFEditor")
        
        box2ndEd1stLine.add(Box.createHorizontalGlue());
        
        JButton browse2 = new JButton(Messages.getString("SettingsDialog.Browse")); //$NON-NLS-1$
        browse2.setToolTipText(sgfTFToolTip);
        browse2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              sgfTF2.setText(onBrowseEditor(sgfTF2.getText()));
            }
        });
        box2ndEd1stLine.add(browse2);
        box2ndEd1stLine.add(Box.createHorizontalStrut(3));
        
        JButton testEditor2 = new JButton("Test editor 2");//$NON-NLS-1$ 
                                                //$NON-NLS-1$ // Messages.getString("SettingsDialog.Browse")
        testEditor2.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) { // 
            onTestEditorStarter(sgfTF2.getText());
          }
        });
        box2ndEd1stLine.add(testEditor2);

        box2ndEd1stLine.add(Box.createHorizontalStrut(5));
        topPanel.add(box2ndEd1stLine);

        Box box2ndEd2ndLine = new Box(BoxLayout.X_AXIS);

        sgfTF2 = new JTextField();
        sgfTF2.setToolTipText(sgfTFToolTip);
        box2ndEd2ndLine.add(Box.createHorizontalStrut(20));
        box2ndEd2ndLine.add(sgfTF2);

        box2ndEd2ndLine.add(Box.createHorizontalGlue());
        box2ndEd2ndLine.add(Box.createHorizontalStrut(10));
        topPanel.add(box2ndEd2ndLine);

       // BOX2A CHECKBOX
        Box boxCBs2ndEd = new Box(BoxLayout.Y_AXIS);

        allowTextEditCB = new JCheckBox();
        if (!GS.getParserMoveDefectFile() ){
          allowTextEditCB.setText("Allow text edit of a defect problem file"); //$NON-NLS-1$
          allowTextEditCB.setSelected(GS.getAllowTextEdit());
          allowTextEditCB.setEnabled(true);
        }
        else{
          allowTextEditCB.setText("Allow text edit... move defect files is active");
          allowTextEditCB.setSelected(!GS.getAllowTextEdit());
          allowTextEditCB.setEnabled(false);
        }
        boxCBs2ndEd.add(allowTextEditCB);
        
        show2ndEditorButtonCB = new JCheckBox();
        show2ndEditorButtonCB.setText("Show tool bar button for 2nd editor"); //$NON-NLS-1$
        show2ndEditorButtonCB.setSelected(GS.getShow2ndEditorButton()); // dubblemubble?
        boxCBs2ndEd.add(show2ndEditorButtonCB);
        Box boxCBs2ndEdOuter = new Box(BoxLayout.X_AXIS);
        boxCBs2ndEdOuter.add(boxCBs2ndEd); // I don't like this extra box, but seemingly it is needed
        boxCBs2ndEdOuter.add(Box.createHorizontalGlue());
//        boxCBs2ndEd.setAlignmentX(Component.LEFT_ALIGNMENT); // this didn't do it
        topPanel.add(boxCBs2ndEdOuter);
        topPanel.add(Box.createVerticalStrut(5));
// ############# 2ND EDITOR end #######################################################################
        Box boxWGFEnable = new Box(BoxLayout.Y_AXIS); // only for enableWGFEditorCB
        enableWGFEditorCB = new JCheckBox();
        enableWGFEditorCB.setText("Enable WGF editor");
        enableWGFEditorCB.setSelected(GS.getEnableWGFEditor());
        boxWGFEnable.add(enableWGFEditorCB); // this need not be part of the program; warnUser, if this was set to true?
//
//        topPanel.add(boxWGFEnable);
//        topPanel.add(Box.createVerticalStrut(5));
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));

      // BUTTON OK
        JButton okButton = new JButton();
        okButton.setText(Messages.getString("ok")); //$NON-NLS-1$

        ActionListener okListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onOK();
            }
        };
        okButton.registerKeyboardAction(okListener, 
                                        KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), 
                                        JComponent.WHEN_FOCUSED); // WHEN_IN_FOCUSED_WINDOW doesn't work
        okButton.addActionListener(okListener);

        buttonPanel.add(okButton);
        
      // BUTTON CANCEL (CONTINUE WITH PREVIOUS SELECTION)
        JButton cancelButton = new JButton(Messages.getString("cancel")); //$NON-NLS-1$
        cancelButton.setToolTipText(Messages.getString("cancel"));

        ActionListener cancelListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        };
        cancelButton.registerKeyboardAction(cancelListener,
                                            KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                                            JComponent.WHEN_IN_FOCUSED_WINDOW);
        cancelButton.addActionListener(cancelListener);

        buttonPanel.add(cancelButton);
        
        setDefaultCloseOperation(DISPOSE_ON_CLOSE); // for closing with the [x]
        // but this doesn't reset ToolTipManager.sharedInstance().setDismissDelay(...)


        cp.add(topPanel, BorderLayout.NORTH);
        
        cp.add(buttonPanel, BorderLayout.SOUTH);

        // COULD THIS HERE BE a method "init" or similar?
        autoAdvCB.setSelected(GS.getAutoAdv());
        rightAdvCB.setSelected(GS.getRightClickAdvance());
        flipCB.setSelected(GS.getFlip());
        flipColorsCB.setSelected(GS.getFlipColors());
        showGhostCB.setSelected(GS.getShowGhost());
        sortDirsCB.setSelected(GS.getSelectionOrderedDirs());
        showWrongPathCB.setSelected(GS.getShowWrongPath());
        clickSoundCB.setSelected(GS.getClickSoundEnabled());
        soundCB.setSelected(GS.getSoundEnabled());

        String editor1 = GS.getSGFEditor1Str();
        sgfTF1.setText(editor1);
        // we want the textfield to have a minimum size
        int sgfTF1Cols;
        if(editor1.length() < 15){
          sgfTF1Cols = 15;
          sgfTF1.setColumns(sgfTF1Cols);
        }
        
        String editor2 = GS.getSGFEditor2Str();
        sgfTF2.setText(editor2);
        int sgfTF2Cols;
        if(editor2.length() < 15){
          sgfTF2Cols = 15;
          sgfTF2.setColumns(sgfTF2Cols);
        }

        pack();
        setLocationRelativeTo(parent);

        cancelButton.requestFocusInWindow();
        getRootPane().setDefaultButton(cancelButton);

        setVisible(true);
    }// end constr. SettingsDialog
    
 // ####################################################################################################################
    private String onBrowseEditor(String changeThis){  // no filter (ok, in Lnx and Mac is no need of *.exe, but 
      JFileChooser choose = new JFileChooser();        // maybe set filter to all_executable, depending on the OS?)
      choose.setDialogTitle(Messages.getString("SettingsDialog.SelectSGFEditor")); //$NON-NLS-1$
      String choosen = "";
      File changeThisF = new File(changeThis);
      String[] cmdParts = null;
       // we want to begin in the same directory, where we found the 
       // previous program - when not set: begin in the settings folder (?: better in "/"?)
       // the StartHere should be set to this - else the other editor's parent file
       // first we have to split the start string
      if (changeThis.startsWith("\"")) cmdParts = changeThis.substring(1).split("\"", 2); // in Win this works, but if the program 
                                                // doesn't like two spaces between the command and the parameter (switch or file)...
      else cmdParts = changeThis.split(" ", 2);
      File execPartF = new File(cmdParts[0]);
      if (execPartF.exists()) choose.setCurrentDirectory(execPartF.getParentFile());
      else choose.setCurrentDirectory(Main.pathToSettingsF);
      if(choose.showOpenDialog(this) == JFileChooser.APPROVE_OPTION){
        choosen = choose.getSelectedFile().getAbsolutePath();
        if(choosen.indexOf(" ")!= -1) choosen = "\"" + choosen + "\"";
      }
      else 
        choosen = changeThis;
      return choosen;
    }
 // ####################################################################################################################
    
    private void onTestEditorStarter(String startString){
      String validMiniSgf = "(;SZ[19]AB[rs][rq][qr]AW[rp][qp][pq][pr]C[tmpFile];B[sr]C[RIGHT])";
      String tmpSgf = Main.pathToSettings + Main.SLASH + "test-editor-tmp.sgf";
      File tmpSgfF = new File(tmpSgf);

      JOptionPane.showMessageDialog(null, "Should be a test for the editor here. Start string is:\n"
                                        + startString + "\n"
                                        + "with a temporary file \n"
                                        + tmpSgf);
      if (!FileWReadWrite.writeFileLine(tmpSgf, validMiniSgf)){
        JOptionPane.showMessageDialog(null, "Cannot create a test file: \n"
                                            + tmpSgf + "\n"
                                            + "We try without!");
      }
      else {
        tmpSgfF.deleteOnExit();
      }
      boolean result = EditorStarter.editorStarter(startString, tmpSgf);
    }

    private void onOK() {
        GS.setAutoAdv(autoAdvCB.isSelected());
        GS.setRightClickAdvance(rightAdvCB.isSelected());
        GS.setFlip(flipCB.isSelected());
        GS.setFlipColors(flipColorsCB.isSelected());
        GS.setShowGhost(showGhostCB.isSelected());
        GS.setSelectionOrderedDirs(sortDirsCB.isSelected());
        GS.setShowWrongPath(showWrongPathCB.isSelected());
        GS.setClickSoundEnabled(clickSoundCB.isSelected());
        GS.setSoundEnabled(soundCB.isSelected());
        GS.setCheckForUpdates(false); // (checkUpdateCB.isSelected()); // 
        GS.setMyDefaultCharset((String)charSetComBox.getSelectedItem());

        String editor1 = sgfTF1.getText();
        //if(editor1.length() > 0)        // this makes it difficult to unset an editor: 
          GS.setSGFEditor1Str(editor1); // need to enter one character as minimum, e.g." " 
                                        // this was coded this way by T.K.
        String editor2 = sgfTF2.getText();
        //if(editor2.length() > 0)
          GS.setSGFEditor2Str(editor2);
          
        if (editor2.trim().length() < 2){
          allowTextEditCB.setSelected(false);
          GS.setAllowTextEdit(false);
          show2ndEditorButtonCB.setSelected(false);
          GS.setShow2ndEditorButton(false);
        }

        GS.setAllowTextEdit(allowTextEditCB.isSelected());
        GS.setShow2ndEditorButton(show2ndEditorButtonCB.isSelected());
        GS.setEnableWGFEditor(enableWGFEditorCB.isSelected());
        dispose();
    }

    private void onCancel() {
        dispose();
    }
  
    @Override public void dispose(){
        ToolTipManager.sharedInstance().setDismissDelay(4000);
        super.dispose();
    }
}
