/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.model.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.loomchild.maligna.model.translation.SourceData;
import net.loomchild.maligna.model.translation.TargetData;
import net.loomchild.maligna.model.translation.TargetDataProbabilityComparator;

class MutableSourceData
implements SourceData {
    private List<TargetData> translationList = new ArrayList<TargetData>();

    @Override
    public double getTranslationProbability(int targetWid) {
        int index = this.findTargetData(targetWid);
        if (index != -1) {
            return this.translationList.get(index).getProbability();
        }
        return 0.0;
    }

    @Override
    public List<TargetData> getTranslationList() {
        return this.translationList;
    }

    public void setTranslationProbability(int targetWid, double probability) {
        TargetData newData = new TargetData(targetWid, probability);
        int index = this.findTargetData(targetWid);
        if (index != -1) {
            this.translationList.set(index, newData);
        } else {
            this.translationList.add(newData);
        }
    }

    public void normalize() {
        double totalProbability = 0.0;
        for (TargetData data : this.translationList) {
            totalProbability += data.getProbability();
        }
        int index = 0;
        for (TargetData data : this.translationList) {
            double newProbability = data.getProbability() / totalProbability;
            TargetData newData = new TargetData(data.getWid(), newProbability);
            this.translationList.set(index, newData);
            ++index;
        }
    }

    public void sort() {
        Collections.sort(this.translationList, new TargetDataProbabilityComparator());
    }

    private int findTargetData(int targetWid) {
        int index = 0;
        for (TargetData data : this.translationList) {
            if (data.getWid() == targetWid) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

