/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLDirEntryHandler
extends AbstractXMLHandler
implements ISVNDirEntryHandler,
Comparator {
    public static final String EXPIRES_TAG = "expires";
    public static final String CREATED_TAG = "created";
    public static final String COMMENT_TAG = "comment";
    public static final String OWNER_TAG = "owner";
    public static final String TOKEN_TAG = "token";
    public static final String LOCK_TAG = "lock";
    public static final String PATH_ATTR = "path";
    public static final String REVISION_ATTR = "revision";
    public static final String LISTS_TAG = "lists";
    public static final String LIST_TAG = "list";
    public static final String ENTRY_TAG = "entry";
    public static final String NAME_TAG = "name";
    public static final String SIZE_TAG = "size";
    public static final String COMMIT_TAG = "commit";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    private Collection myDirEntries;

    public SVNXMLDirEntryHandler(ContentHandler saxHandler) {
        this(saxHandler, null);
    }

    public SVNXMLDirEntryHandler(ContentHandler saxHandler, ISVNDebugLog log) {
        super(saxHandler, log);
    }

    public void startTarget(String path) {
        this.myDirEntries = new TreeSet(this);
        try {
            this.addAttribute(PATH_ATTR, path == null || path.length() == 9 ? "." : path);
            this.openTag(LIST_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    @Override
    public void handleDirEntry(SVNDirEntry entry) throws SVNException {
        this.myDirEntries.add(entry);
    }

    public void endTarget() {
        try {
            for (SVNDirEntry entry : this.myDirEntries) {
                this.sendToHandler(entry);
            }
            this.myDirEntries = null;
            this.closeTag(LIST_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    private void sendToHandler(SVNDirEntry entry) throws SAXException {
        if ("".equals(entry.getRelativePath()) && entry.getKind() == SVNNodeKind.DIR) {
            return;
        }
        this.openTag(ENTRY_TAG);
        this.addTag(NAME_TAG, entry.getRelativePath());
        if (entry.getKind() == SVNNodeKind.FILE) {
            this.addTag(SIZE_TAG, entry.getSize() + "");
        }
        this.addAttribute(REVISION_ATTR, entry.getRevision() + "");
        this.openTag(COMMIT_TAG);
        this.addTag(AUTHOR_TAG, entry.getAuthor());
        this.addTag(DATE_TAG, SVNDate.formatDate(entry.getDate()));
        this.closeTag(COMMIT_TAG);
        SVNLock lock = entry.getLock();
        if (lock != null) {
            this.openTag(LOCK_TAG);
            this.addTag(TOKEN_TAG, lock.getID());
            this.addTag(OWNER_TAG, lock.getOwner());
            this.addTag(COMMENT_TAG, lock.getComment());
            this.addTag(CREATED_TAG, SVNDate.formatDate(lock.getCreationDate()));
            if (lock.getExpirationDate() != null && lock.getExpirationDate().getTime() > 0L) {
                this.addTag(EXPIRES_TAG, SVNDate.formatDate(lock.getExpirationDate()));
            }
            this.closeTag(LOCK_TAG);
        }
        this.closeTag(ENTRY_TAG);
    }

    @Override
    protected String getHeaderName() {
        return LISTS_TAG;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        SVNDirEntry e1 = (SVNDirEntry)o1;
        SVNDirEntry e2 = (SVNDirEntry)o2;
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        return SVNPathUtil.PATH_COMPARATOR.compare(e1.getRelativePath(), e2.getRelativePath());
    }
}

