/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.properties;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.properties.ISegmentPropertiesView;
import org.omegat.gui.properties.SegmentPropertiesListView;
import org.omegat.gui.properties.SegmentPropertiesTableView;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.Styles;

public class SegmentPropertiesArea
implements IPaneMenu {
    private static final Pattern SPLIT_COMMAS = Pattern.compile("\\s*,\\s*");
    private final DateFormat dateFormat = DateFormat.getDateInstance();
    private final DateFormat timeFormat = DateFormat.getTimeInstance();
    private static final String KEY_ISDUP = "isDup";
    private static final String KEY_FILE = "file";
    private static final String KEY_ID = "id";
    private static final String KEY_TRANSLATION = "translation";
    private static final String KEY_TRANSLATIONISFUZZY = "translationIsFuzzy";
    private static final String KEY_PATH = "path";
    private static final String KEY_HASNOTE = "hasNote";
    private static final String KEY_HASCOMMENT = "hasComment";
    private static final String KEY_CHANGED = "changed";
    private static final String KEY_CHANGER = "changer";
    private static final String KEY_CREATED = "created";
    private static final String KEY_CREATOR = "creator";
    private static final String KEY_ISALT = "isAlt";
    private static final String KEY_LINKED = "linked";
    private static final String KEY_ORIGIN = "origin";
    private static final String PROP_ORIGIN = "origin";
    final List<String> properties = new ArrayList<String>();
    final DockableScrollPane scrollPane;
    private ISegmentPropertiesView viewImpl;
    final MouseListener contextMenuListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e);
            }
        }

        private void doPopup(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), SegmentPropertiesArea.this.scrollPane);
            SegmentPropertiesArea.this.showContextMenu(p);
        }
    };

    public SegmentPropertiesArea(IMainWindow mw) {
        this.scrollPane = new DockableScrollPane("SEGMENTPROPERTIES", OStrings.getString("SEGPROP_PANE_TITLE"), null, true);
        mw.addDockable(this.scrollPane);
        this.scrollPane.setMenuProvider(this);
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                SegmentPropertiesArea.this.scrollPane.stopNotifying();
                SegmentPropertiesArea.this.setProperties(newEntry);
                SegmentPropertiesArea.this.doNotify(SegmentPropertiesArea.this.getKeysToNotify());
            }
        });
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                this.setProperties(null);
            }
        });
        CoreEvents.registerFontChangedEventListener(newFont -> this.viewImpl.getViewComponent().setFont(newFont));
        this.scrollPane.setForeground(Styles.EditorColor.COLOR_FOREGROUND.getColor());
        this.scrollPane.setBackground(Styles.EditorColor.COLOR_BACKGROUND.getColor());
        this.scrollPane.getViewport().setBackground(Styles.EditorColor.COLOR_BACKGROUND.getColor());
        Class initModeClass = SegmentPropertiesTableView.class;
        String initModeClassName = Preferences.getPreferenceDefault("segment_properties_initial_mode", null);
        if (initModeClassName != null) {
            try {
                initModeClass = this.getClass().getClassLoader().loadClass(initModeClassName);
            }
            catch (ClassNotFoundException e1) {
                Log.log(e1);
            }
        }
        this.installView(initModeClass);
        this.scrollPane.addMouseListener(this.contextMenuListener);
    }

    private void installView(Class<?> viewClass) {
        ISegmentPropertiesView newImpl;
        if (this.viewImpl != null && this.viewImpl.getClass().equals(viewClass)) {
            return;
        }
        try {
            Constructor<?> constructor = viewClass.getConstructor(new Class[0]);
            newImpl = (ISegmentPropertiesView)constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, e.getMessage());
            return;
        }
        this.viewImpl = newImpl;
        this.viewImpl.install(this);
    }

    private void toggleMode(Class<?> newMode) {
        this.installView(newMode);
        Preferences.setPreference("segment_properties_initial_mode", newMode.getName());
        this.viewImpl.update();
    }

    void showContextMenu(Point p) {
        JPopupMenu menu = new JPopupMenu();
        this.populateLocalContextMenuOptions(menu, p);
        try {
            menu.show(this.scrollPane, p.x, p.y);
        }
        catch (IllegalComponentStateException e) {
            e.printStackTrace();
        }
    }

    private void populateLocalContextMenuOptions(JPopupMenu contextMenu, Point p) {
        String key = this.viewImpl.getKeyAtPoint(p);
        if (key == null) {
            return;
        }
        String displayKey = key;
        if (!Preferences.isPreference("segment_properties_show_raw_keys")) {
            try {
                displayKey = OStrings.getString("SEGPROP_KEY_" + key.toUpperCase(Locale.ENGLISH));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        String label = StringUtil.format(OStrings.getString("SEGPROP_CONTEXTMENU_NOTIFY_ON_PROP"), displayKey);
        JCheckBoxMenuItem notifyOnItem = new JCheckBoxMenuItem(label);
        notifyOnItem.setSelected(this.getKeysToNotify().contains(key));
        notifyOnItem.addActionListener(e -> this.setKeyToNotify(key, notifyOnItem.isSelected()));
        contextMenu.add(notifyOnItem);
    }

    @Override
    public void populatePaneMenu(JPopupMenu contextMenu) {
        JCheckBoxMenuItem tableModeItem = new JCheckBoxMenuItem(OStrings.getString("SEGPROP_CONTEXTMENU_TABLE_MODE"));
        tableModeItem.setSelected(this.viewImpl.getClass().equals(SegmentPropertiesTableView.class));
        tableModeItem.addActionListener(e -> this.toggleMode(SegmentPropertiesTableView.class));
        JCheckBoxMenuItem listModeItem = new JCheckBoxMenuItem(OStrings.getString("SEGPROP_CONTEXTMENU_LIST_MODE"));
        listModeItem.setSelected(this.viewImpl.getClass().equals(SegmentPropertiesListView.class));
        listModeItem.addActionListener(e -> this.toggleMode(SegmentPropertiesListView.class));
        ButtonGroup group = new ButtonGroup();
        group.add(tableModeItem);
        group.add(listModeItem);
        contextMenu.add(tableModeItem);
        contextMenu.add(listModeItem);
        contextMenu.addSeparator();
        JCheckBoxMenuItem toggleKeyTranslationItem = new JCheckBoxMenuItem(OStrings.getString("SEGPROP_CONTEXTMENU_RAW_KEYS"));
        toggleKeyTranslationItem.setSelected(Preferences.isPreference("segment_properties_show_raw_keys"));
        toggleKeyTranslationItem.addActionListener(e -> {
            Preferences.setPreference("segment_properties_show_raw_keys", toggleKeyTranslationItem.isSelected());
            this.viewImpl.update();
        });
        contextMenu.add(toggleKeyTranslationItem);
    }

    private List<String> getKeysToNotify() {
        if (!Preferences.existsPreference("segment_properties_notify_props")) {
            Preferences.setPreference("segment_properties_notify_props", "hasComment, hasNote");
        }
        String rawProps = Preferences.getPreference("segment_properties_notify_props");
        return Arrays.asList(SPLIT_COMMAS.split(rawProps));
    }

    private void setKeyToNotify(String key, boolean enabled) {
        ArrayList<String> currentKeys = new ArrayList<String>(this.getKeysToNotify());
        if (enabled && !currentKeys.contains(key)) {
            currentKeys.add(key);
        }
        if (!enabled) {
            currentKeys.remove(key);
        }
        Preferences.setPreference("segment_properties_notify_props", StringUtils.join(currentKeys, (String)", "));
    }

    private void doNotify(List<String> keys) {
        ArrayList<Integer> notify = new ArrayList<Integer>();
        for (int i = 0; i < this.properties.size(); i += 2) {
            String prop = this.properties.get(i);
            if (!keys.contains(prop)) continue;
            notify.add(i);
        }
        if (notify.isEmpty()) {
            return;
        }
        Collections.sort(notify);
        this.scrollPane.notify(true);
        SwingUtilities.invokeLater(() -> this.viewImpl.notifyUser(notify));
    }

    private void setProperty(String key, String value) {
        if (value != null) {
            this.properties.add(key);
            this.properties.add(value);
        }
    }

    private void setProperty(String key, Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                this.setProperty(key, this.getBooleanValueVerb(key, (Boolean)value));
            } else {
                this.setProperty(key, value.toString());
            }
        }
    }

    private String getBooleanValueVerb(String key, boolean value) {
        try {
            if (value) {
                return OStrings.getString("SEGPROP_VERB_" + key.toUpperCase());
            }
            return OStrings.getString("SEGPROP_NVERB_" + key.toUpperCase());
        }
        catch (MissingResourceException ex) {
            if (value) {
                return OStrings.getString("SEGPROP_VERB_YES");
            }
            return OStrings.getString("SEGPROP_VERB_NO");
        }
    }

    private void setProperties(SourceTextEntry ste) {
        this.properties.clear();
        if (ste != null) {
            if (ste.getComment() != null) {
                this.setProperty(KEY_HASCOMMENT, true);
            }
            if (ste.getDuplicate() != SourceTextEntry.DUPLICATE.NONE) {
                this.setProperty(KEY_ISDUP, (Object)ste.getDuplicate());
            }
            if (ste.getSourceTranslation() != null) {
                this.setProperty(KEY_TRANSLATION, ste.getSourceTranslation());
                if (ste.isSourceTranslationFuzzy()) {
                    this.setProperty(KEY_TRANSLATIONISFUZZY, true);
                }
            }
            this.setKeyProperties(ste.getKey());
            IProject project = Core.getProject();
            if (project.isProjectLoaded()) {
                TMXEntry trg = project.getTranslationInfo(ste);
                this.setTranslationProperties(trg);
            }
        }
        this.viewImpl.update();
    }

    private void setKeyProperties(EntryKey key) {
        this.setProperty(KEY_FILE, key.file);
        this.setProperty(KEY_ID, key.id);
        this.setProperty(KEY_PATH, key.path);
    }

    private void setTranslationProperties(TMXEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.hasNote()) {
            this.setProperty(KEY_HASNOTE, true);
        }
        if (!entry.isTranslated()) {
            return;
        }
        if (entry.changeDate != 0L) {
            this.setProperty(KEY_CHANGED, this.dateFormat.format(new Date(entry.changeDate)) + " " + this.timeFormat.format(new Date(entry.changeDate)));
        }
        this.setProperty(KEY_CHANGER, entry.changer);
        if (entry.creationDate != 0L) {
            this.setProperty(KEY_CREATED, this.dateFormat.format(new Date(entry.creationDate)) + " " + this.timeFormat.format(new Date(entry.creationDate)));
        }
        this.setProperty(KEY_CREATOR, entry.creator);
        if (!entry.defaultTranslation) {
            this.setProperty(KEY_ISALT, true);
        }
        this.setProperty(KEY_LINKED, (Object)entry.linked);
        if (entry.getPropValue("origin") != null) {
            this.setProperty("origin", entry.getPropValue("origin"));
        } else {
            this.setProperty("origin", OStrings.getString("SEGPROP_ORIGIN_UNKNOWN"));
        }
    }
}

