/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.omegat.util.Platform;

public final class DesktopWrapper {
    private static final boolean useXDGOpen;

    public static void browse(URI uri) throws IOException {
        if (useXDGOpen) {
            DesktopWrapper.xdgOpen(uri.toString(), false);
        } else {
            Desktop.getDesktop().browse(uri);
        }
    }

    public static void open(File file) throws IOException {
        if (useXDGOpen) {
            DesktopWrapper.xdgOpen(file.getPath(), false);
        } else {
            Desktop.getDesktop().open(file);
        }
    }

    private static boolean xdgOpen(String s, boolean doWait) throws IOException {
        File devNull = new File("/dev/null");
        ProcessBuilder pb = new ProcessBuilder("xdg-open", s);
        pb.redirectOutput(devNull);
        pb.redirectError(devNull);
        Process p = pb.start();
        if (doWait) {
            try {
                return p.waitFor() == 0;
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return false;
    }

    private DesktopWrapper() {
    }

    static {
        boolean hasXDGOpen = false;
        if (Platform.isLinux()) {
            try {
                hasXDGOpen = DesktopWrapper.xdgOpen("--help", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        useXDGOpen = hasXDGOpen;
    }
}

