/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import java.util.BitSet;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

public class BaseCountTrimmer
extends AbstractSingleRecordTrimmer {
    private int minCount = 0;
    private Integer maxCount = null;
    private BitSet baseSet;

    public BaseCountTrimmer(String args) {
        String[] split = args.split(":");
        this.baseSet = new BitSet();
        String bases = split[0];
        for (int i = 0; i < bases.length(); ++i) {
            char c = bases.charAt(i);
            this.baseSet.set(c);
        }
        if (split.length > 1) {
            this.minCount = Integer.parseInt(split[1]);
            if (split.length > 2) {
                this.maxCount = new Integer(split[2]);
            }
        }
    }

    public FastqRecord processRecord(FastqRecord in) {
        int count = 0;
        String seq = in.getSequence();
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (!this.baseSet.get(c)) continue;
            ++count;
        }
        if (count < this.minCount) {
            return null;
        }
        if (this.maxCount != null && count > this.maxCount) {
            return null;
        }
        return in;
    }
}

