/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.MarshalException;

public interface OnDiskAtom {
    public Composite name();

    public long timestamp();

    public int getLocalDeletionTime();

    public void validateFields(CFMetaData var1) throws MarshalException;

    public void updateDigest(MessageDigest var1);

    public static class Serializer
    implements ISSTableSerializer<OnDiskAtom>,
    SerializerForWriting {
        private final CellNameType type;

        public Serializer(CellNameType type) {
            this.type = type;
        }

        @Override
        public void serializeForSSTable(OnDiskAtom atom, DataOutputPlus out) throws IOException {
            if (atom instanceof Cell) {
                this.type.columnSerializer().serialize((Cell)atom, out);
            } else {
                assert (atom instanceof RangeTombstone);
                this.type.rangeTombstoneSerializer().serializeForSSTable((RangeTombstone)atom, out);
            }
        }

        @Override
        public OnDiskAtom deserializeFromSSTable(DataInput in, Version version) throws IOException {
            return this.deserializeFromSSTable(in, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
        }

        public OnDiskAtom deserializeFromSSTable(DataInput in, ColumnSerializer.Flag flag, int expireBefore, Version version) throws IOException {
            Composite name = (Composite)this.type.serializer().deserialize(in);
            if (name.isEmpty()) {
                return null;
            }
            int b = in.readUnsignedByte();
            if ((b & 0x10) != 0) {
                return this.type.rangeTombstoneSerializer().deserializeBody(in, name, version);
            }
            return this.type.columnSerializer().deserializeColumnBody(in, (CellName)name, b, flag, expireBefore);
        }

        @Override
        public long serializedSizeForSSTable(OnDiskAtom atom) {
            if (atom instanceof Cell) {
                return this.type.columnSerializer().serializedSize((Cell)atom, TypeSizes.NATIVE);
            }
            assert (atom instanceof RangeTombstone);
            return this.type.rangeTombstoneSerializer().serializedSizeForSSTable((RangeTombstone)atom);
        }
    }

    public static interface SerializerForWriting {
        public void serializeForSSTable(OnDiskAtom var1, DataOutputPlus var2) throws IOException;

        public long serializedSizeForSSTable(OnDiskAtom var1);
    }
}

