/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.CqlOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.StressSettings;

public class CqlReader
extends CqlOperation<ByteBuffer[][]> {
    public CqlReader(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(Command.READ, timer, generator, seedManager, settings);
    }

    @Override
    protected String buildQuery() {
        StringBuilder query = new StringBuilder("SELECT ");
        if (this.settings.columns.slice) {
            query.append("*");
        } else {
            for (int i = 0; i < this.settings.columns.maxColumnsPerKey; ++i) {
                if (i > 0) {
                    query.append(",");
                }
                query.append(this.wrapInQuotes(this.settings.columns.namestrs.get(i)));
            }
        }
        query.append(" FROM ").append(this.wrapInQuotes(this.type.table));
        query.append(" WHERE KEY=?");
        return query.toString();
    }

    @Override
    protected List<Object> getQueryParameters(byte[] key) {
        return Collections.singletonList(ByteBuffer.wrap(key));
    }

    @Override
    protected CqlOperation.CqlRunOp<ByteBuffer[][]> buildRunOp(CqlOperation.ClientWrapper client, String query, Object queryId, List<Object> params, ByteBuffer key) {
        List<ByteBuffer> expectRow = this.getColumnValues();
        return new CqlOperation.CqlRunOpMatchResults(client, query, queryId, params, key, Arrays.asList(expectRow));
    }
}

