/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.ClusterData;

public class ObjectReader {
    private SocketChannel channel;
    private Selector selector;
    private ListenCallback callback;
    private XByteBuffer buffer;

    public ObjectReader(SocketChannel channel, Selector selector, ListenCallback callback) {
        this.channel = channel;
        this.selector = selector;
        this.callback = callback;
        this.buffer = new XByteBuffer();
    }

    public ListenCallback getCallback() {
        return this.callback;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public int append(byte[] data, int off, int len) throws IOException {
        this.buffer.append(data, off, len);
        int pkgCnt = this.buffer.countPackages();
        return pkgCnt;
    }

    public int execute() throws IOException {
        int pkgCnt = 0;
        boolean pkgExists = this.buffer.doesPackageExist();
        while (pkgExists) {
            ClusterData data = this.buffer.extractPackage(true);
            this.getCallback().messageDataReceived(data);
            ++pkgCnt;
            pkgExists = this.buffer.doesPackageExist();
        }
        return pkgCnt;
    }

    public int write(ByteBuffer buf) throws IOException {
        return this.getChannel().write(buf);
    }
}

