/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import java.util.Arrays;
import phase.BasicPhaseStates;
import phase.FixedPhaseData;
import phase.HmmUpdater;
import phase.ParamEstimates;
import phase.PbwtPhaseIbs;
import phase.PhaseData;
import vcf.GT;

public class HmmParamData {
    private final PhaseData phaseData;
    private final GT gt;
    private final int nMarkers;
    private final FloatArray genDist;
    private final FloatArray pRecomb;
    private final byte[][][] alMatch;
    private final BasicPhaseStates states;
    private final float[] fwd;
    private final float[] bwd;
    private final float[][] savedBwd;
    private final float[] emProbs;
    private final boolean[] isHom;
    private final float maxErrMaf;
    private final FloatArray markerToMaf;
    private int mismatchCnt;
    private double sumMismatchProb;
    private double sumGenDist;
    private double sumSwitchProb;

    public HmmParamData(PbwtPhaseIbs pbwtPhaseIbs, float f) {
        if ((double)f <= 0.0 || (double)f >= 1.0 || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        this.phaseData = pbwtPhaseIbs.phaseData();
        FixedPhaseData fixedPhaseData = this.phaseData.fpd();
        this.gt = fixedPhaseData.stage1TargGT();
        int n = fixedPhaseData.par().phase_states();
        this.nMarkers = fixedPhaseData.stage1TargGT().nMarkers();
        this.genDist = fixedPhaseData.stage1Map().genDist();
        this.alMatch = new byte[2][this.nMarkers][n];
        this.pRecomb = this.phaseData.pRecomb();
        this.states = new BasicPhaseStates(pbwtPhaseIbs, n);
        this.fwd = new float[n];
        this.bwd = new float[n];
        this.savedBwd = new float[this.nMarkers][n];
        float f2 = this.phaseData.pMismatch();
        this.emProbs = new float[]{1.0f - f2, f2};
        this.isHom = new boolean[this.nMarkers];
        this.markerToMaf = fixedPhaseData.stage1Maf();
        this.maxErrMaf = f;
        this.mismatchCnt = 0;
        this.sumMismatchProb = 0.0;
        this.sumGenDist = 0.0;
        this.sumSwitchProb = 0.0;
    }

    public int nTargSamples() {
        return this.gt.nSamples();
    }

    public void addEstimationData(ParamEstimates paramEstimates) {
        paramEstimates.addMismatchData(this.mismatchCnt, this.sumMismatchProb);
        paramEstimates.addSwitchData(this.sumGenDist, this.sumSwitchProb);
    }

    public double sumSwitchProbs() {
        return this.sumSwitchProb;
    }

    public void update(int n) {
        this.setIsHom(n);
        int n2 = this.states.ibsStates(n, this.alMatch);
        if (n2 > 1) {
            this.getParamData(this.alMatch[0], n2);
            this.getParamData(this.alMatch[1], n2);
        }
    }

    private void getParamData(byte[][] byArray, int n) {
        Arrays.fill(this.bwd, 0, n, 1.0f);
        Arrays.fill(this.savedBwd[this.nMarkers - 1], 0, n, 1.0f);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            int n2 = i + 1;
            HmmUpdater.bwdUpdate(this.bwd, this.pRecomb.get(n2), this.emProbs, byArray[n2], n);
            System.arraycopy(this.bwd, 0, this.savedBwd[i], 0, n);
        }
        float f = (float)n / ((float)n - 1.0f);
        Arrays.fill(this.fwd, 0, n, 1.0f / (float)n);
        float f2 = 1.0f;
        for (int i = 0; i < this.nMarkers; ++i) {
            f2 = this.fwdUpdate(i, byArray[i], n, f2, f);
        }
    }

    private float fwdUpdate(int n, byte[] byArray, int n2, float f, float f2) {
        double d;
        float f3 = this.pRecomb.get(n);
        float f4 = f3 / (float)n2;
        float f5 = (1.0f - f3) / f;
        float f6 = (1.0f - f3 + f4) / f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float[] fArray = this.savedBwd[n];
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            float f11 = this.emProbs[byArray[i]];
            f7 += fArray[i] * f11 * f6 * this.fwd[i];
            this.fwd[i] = f11 * (f5 * this.fwd[i] + f4);
            f9 += this.fwd[i];
            float f12 = this.fwd[i] * fArray[i];
            f8 += f12;
            if (byArray[i] <= 0) continue;
            f10 += f12;
        }
        if (this.isHom[n] && this.markerToMaf.get(n) <= this.maxErrMaf) {
            ++this.mismatchCnt;
            this.sumMismatchProb += (double)(f10 / f8);
        }
        if ((d = (double)(f2 * (1.0f - f7 / f8))) > 0.0) {
            this.sumGenDist += (double)this.genDist.get(n);
            this.sumSwitchProb += d;
        }
        return f9;
    }

    private void setIsHom(int n) {
        for (int i = 0; i < this.isHom.length; ++i) {
            int n2 = this.gt.allele1(i, n);
            int n3 = this.gt.allele2(i, n);
            this.isHom[i] = n2 >= 0 && n2 == n3;
        }
    }
}

