/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.PlayerWidget;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;

public class SetPrefsWindow
extends DFrame
implements ActionListener {
    public static final String ANTI_SKID_ON_PREF = "sF)R3377";
    public static final int MAX_FONT_SIZE = 32;
    public static final short FLAGS_ANTISKID = 1;
    public static final short FLAGS_NOISYMOVES = 2;
    public static final short FLAGS_NOCOORDINATES = 4;
    public static final short FLAGS_HIDEKOS = 32;
    public static final short FLAGS_NOWOODGRAIN = 64;
    public static final short FLAGS_SHOWRATEDRESULTSONLY = 1024;
    public static final short FLAGS_ALLGAMESNOISY = 2048;
    public static final short FLAGS_ALARMFORTELLS = 16384;
    public static final short SORT_USERS_BY_NAME = 0;
    public static final short SORT_USERS_BY_RANK = 128;
    public static final short SORT_USERS_MASK = 128;
    public static final short SORT_GAMES_BY_RANK = 0;
    public static final short SORT_GAMES_BY_WNAME = 256;
    public static final short SORT_GAMES_BY_BNAME = 512;
    public static final short SORT_GAMES_BY_OBSERVERS = 768;
    public static final short SORT_GAMES_MASK = 768;
    protected final JButton okBut;
    private final JButton cancelBut;
    private final JButton helpBut;
    private final ATextField timeWarningLevelIn;
    private final ATextField byTimeWarningLevelIn;
    private final ATextField fontSizeIn;
    private final JCheckBox antiSkidIn;
    private final JComboBox<String> soundOptions = new JComboBox();
    private final JCheckBox warnFlash;
    private final JComboBox<String> warnSoundChoice;
    private final JCheckBox alarmForTellsIn;
    private final JCheckBox soundEnabledIn;
    private JButton testRecordBut;
    private final JCheckBox boardCoordsIn;
    private final JCheckBox texturedBoardIn;
    private final JCheckBox showKosIn;
    protected final JPanel appConfigPanel;

    public SetPrefsWindow(AFrame parent) {
        this(Defs.getString(-903340558), parent);
    }

    public SetPrefsWindow(String title, AFrame parent) {
        super(title, parent);
        if (Defs.isApp()) {
            this.appConfigPanel = new JPanel(new GCLayout());
            this.getMainPanel().add("xSpan=2", this.appConfigPanel);
        } else {
            this.appConfigPanel = null;
        }
        this.getMainPanel().add("x=0,xSpan=1", new JLabel(Defs.getString(-903340580)));
        this.timeWarningLevelIn = new ATextField(Integer.toString(PlayerWidget.getTimeWarningLevel(1)), (ActionListener)this);
        this.getMainPanel().add("xGrow=t", this.timeWarningLevelIn);
        this.getMainPanel().add("x=0,xSpan=1", new JLabel(Defs.getString(-903340791)));
        this.byTimeWarningLevelIn = new ATextField(Integer.toString(PlayerWidget.getTimeWarningLevel(2)), (ActionListener)this);
        this.getMainPanel().add("xGrow=t", this.byTimeWarningLevelIn);
        this.getMainPanel().add("x=0,xGrow=f", new JLabel(Defs.getString(-903340546)));
        this.warnFlash = new JCheckBox(Defs.getString(-903340738), PlayerWidget.getWarningFlashOption());
        this.getMainPanel().add("x=0", this.warnFlash);
        this.warnSoundChoice = new JComboBox();
        for (PlayerWidget.WarnSoundOption option : PlayerWidget.WarnSoundOption.values()) {
            this.warnSoundChoice.addItem(Defs.getString(option.uiRes));
            if (option != PlayerWidget.getWarningSoundOption()) continue;
            this.warnSoundChoice.setSelectedItem(Defs.getString(option.uiRes));
        }
        this.getMainPanel().add(this.warnSoundChoice);
        if (Defs.isApp()) {
            this.getMainPanel().add("x=0,xGrow=f", new JLabel(Defs.getString(-903340737)));
            this.fontSizeIn = new ATextField(Integer.toString(Prefs.getInt("v.93.DUX", 12)));
            this.getMainPanel().add(this.fontSizeIn);
        } else {
            this.fontSizeIn = null;
        }
        this.antiSkidIn = new JCheckBox(Defs.getString(-903340686), Prefs.getBoolean(ANTI_SKID_ON_PREF, false));
        this.getMainPanel().add("x=0,xSpan=2", this.antiSkidIn);
        boolean soundOn = Defs.isSoundEnabled();
        this.soundEnabledIn = new JCheckBox(Defs.getString(-903340510), soundOn);
        this.getMainPanel().add("x=0", this.soundEnabledIn);
        this.soundEnabledIn.addActionListener(this);
        this.getMainPanel().add("x=0,xSpan=1", new JLabel(Defs.getString(-903340590)));
        this.getMainPanel().add(this.soundOptions);
        this.soundOptions.addItem(Defs.getString(-903340674));
        this.soundOptions.addItem(Defs.getString(-903340682));
        this.soundOptions.addItem(Defs.getString(-903340807));
        if (Prefs.getBoolean("bPL-wjB5", true)) {
            if (Prefs.getBoolean("$gr^6i1Q", false)) {
                this.soundOptions.setSelectedIndex(2);
            } else {
                this.soundOptions.setSelectedIndex(1);
            }
        }
        this.alarmForTellsIn = new JCheckBox(Defs.getString(-903340809), Prefs.getBoolean(":14_`9Lf", true));
        this.getMainPanel().add("x=0,xSpan=2", this.alarmForTellsIn);
        this.alarmForTellsIn.setEnabled(soundOn);
        this.soundOptions.setEnabled(soundOn);
        this.boardCoordsIn = new JCheckBox(Defs.getString(-903340478), GobanWidget.getShowBoardCoords());
        this.getMainPanel().add("x=0", this.boardCoordsIn);
        this.texturedBoardIn = new JCheckBox(Defs.getString(-903340659), GobanWidget.getBoardsTextured());
        this.getMainPanel().add("x=0", this.texturedBoardIn);
        this.showKosIn = new JCheckBox(Defs.getString(-903340599), GobanWidget.getKosMarked());
        this.getMainPanel().add("x=0", this.showKosIn);
        if (this.isRecordSupported()) {
            this.testRecordBut = new JButton(Defs.getString(-903340503));
            this.getMainPanel().add("x=0", this.testRecordBut);
            this.testRecordBut.addActionListener(this);
        }
        this.okBut = this.addButton(Defs.getString(1436228518), this);
        this.cancelBut = this.addButton(Defs.getString(1436228510), this);
        this.helpBut = this.addButton(Defs.getString(1436228516), this);
        if (this.appConfigPanel == null) {
            this.pack(parent);
            this.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.timeWarningLevelIn) {
            this.parseTimeWarningLevel(this.timeWarningLevelIn, 1);
        } else if (source == this.byTimeWarningLevelIn) {
            this.parseTimeWarningLevel(this.byTimeWarningLevelIn, 2);
        } else if (source == this.okBut) {
            if (this.fontSizeIn != null) {
                int newFontSize = -1;
                try {
                    newFontSize = Short.parseShort(this.fontSizeIn.getText());
                }
                catch (NumberFormatException excep) {
                    newFontSize = -1;
                }
                if (newFontSize < 8 || newFontSize > 32) {
                    new Errout(Defs.getString(-903340794, this.fontSizeIn.getText()), this);
                    return;
                }
                if (newFontSize != UIManager.getFont("Label.font").getSize()) {
                    new MsgOut(Defs.getString(-903340709), Defs.getString(-903340736), 1);
                }
                Prefs.putInt("v.93.DUX", newFontSize);
            }
            if (this.parseTimeWarningLevel(this.timeWarningLevelIn, 1) && this.parseTimeWarningLevel(this.byTimeWarningLevelIn, 2)) {
                Prefs.putBoolean(ANTI_SKID_ON_PREF, this.antiSkidIn.isSelected());
                Prefs.putBoolean("bPL-wjB5", this.soundOptions.getSelectedIndex() > 0);
                Prefs.putBoolean("$gr^6i1Q", this.soundOptions.getSelectedIndex() > 1);
                GobanWidget.setShowBoardCoords(this.boardCoordsIn.isSelected());
                GobanWidget.setBoardsTextured(this.texturedBoardIn.isSelected());
                GobanWidget.setKosMarked(this.showKosIn.isSelected());
                Prefs.putBoolean(":14_`9Lf", this.alarmForTellsIn.isSelected());
                PlayerWidget.setWarningFlashOption(this.warnFlash.isSelected());
                PlayerWidget.setWarningSoundOption(PlayerWidget.WarnSoundOption.values()[this.warnSoundChoice.getSelectedIndex()]);
                this.dispose();
            }
        } else if (source == this.cancelBut) {
            this.dispose();
        } else if (source == this.testRecordBut) {
            this.createRecordTestWindow();
        } else if (source == this.soundEnabledIn) {
            boolean isOn = this.soundEnabledIn.isSelected();
            Prefs.putBoolean("?x,`>/$bI_", isOn);
            Defs.setSoundEnabled(isOn);
            this.alarmForTellsIn.setEnabled(isOn);
            this.soundOptions.setEnabled(isOn);
        } else if (source == this.helpBut) {
            GuiUtil.loadHelp("setPrefsWin.html");
        } else {
            throw new RuntimeException();
        }
    }

    private boolean parseTimeWarningLevel(ATextField source, int timeSystem) {
        int newLimit = -1;
        String val = source.getText();
        try {
            newLimit = Integer.parseInt(val);
        }
        catch (NumberFormatException excep) {
            newLimit = -1;
        }
        if (newLimit < 0) {
            new Errout(Defs.getString(-903340793, val), this);
            return false;
        }
        PlayerWidget.setTimeWarningLevel(timeSystem, newLimit);
        return true;
    }

    protected boolean isRecordSupported() {
        return false;
    }

    protected void createRecordTestWindow() {
        throw new UnsupportedOperationException();
    }
}

