/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.snapshots.SnapshotId;

public abstract class FileRestoreContext {
    protected static final Logger logger = LogManager.getLogger(FileRestoreContext.class);
    protected final String repositoryName;
    protected final IndexShard indexShard;
    protected final RecoveryState recoveryState;
    protected final SnapshotId snapshotId;
    protected final ShardId shardId;
    protected final int bufferSize;

    protected FileRestoreContext(String repositoryName, IndexShard indexShard, SnapshotId snapshotId, RecoveryState recoveryState, int bufferSize) {
        this.repositoryName = repositoryName;
        this.recoveryState = recoveryState;
        this.indexShard = indexShard;
        this.snapshotId = snapshotId;
        this.shardId = indexShard.shardId();
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(SnapshotFiles snapshotFiles) throws IOException {
        Store store = this.indexShard.store();
        store.incRef();
        try {
            SegmentInfos segmentCommitInfos;
            BlobStoreIndexShardSnapshot.FileInfo fileInfo;
            Store.MetadataSnapshot recoveryTargetMetadata;
            logger.debug("[{}] [{}] restoring to [{}] ...", (Object)this.snapshotId, (Object)this.repositoryName, (Object)this.shardId);
            if (snapshotFiles.indexFiles().size() == 1 && snapshotFiles.indexFiles().get(0).physicalName().startsWith("segments_") && snapshotFiles.indexFiles().get(0).hasUnknownChecksum()) {
                store.createEmpty();
                return;
            }
            try {
                recoveryTargetMetadata = this.indexShard.snapshotStoreMetadata();
            }
            catch (IndexNotFoundException e) {
                logger.trace("[{}] [{}] restoring from to an empty shard", (Object)this.shardId, (Object)this.snapshotId);
                recoveryTargetMetadata = Store.MetadataSnapshot.EMPTY;
            }
            catch (IOException e) {
                logger.warn((Message)new ParameterizedMessage("[{}] [{}] Can't read metadata from store, will not reuse local files during restore", (Object)this.shardId, (Object)this.snapshotId), (Throwable)e);
                recoveryTargetMetadata = Store.MetadataSnapshot.EMPTY;
            }
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            HashMap<String, StoreFileMetaData> snapshotMetaData = new HashMap<String, StoreFileMetaData>();
            HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo2 : snapshotFiles.indexFiles()) {
                try {
                    this.maybeRecalculateMetadataHash(fileInfo2, recoveryTargetMetadata);
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("[{}] Can't calculate hash from blog for file [{}] [{}]", new Object[]{this.shardId, fileInfo2.physicalName(), fileInfo2.metadata()}), (Throwable)e);
                }
                snapshotMetaData.put(fileInfo2.metadata().name(), fileInfo2.metadata());
                fileInfos.put(fileInfo2.metadata().name(), fileInfo2);
            }
            Store.MetadataSnapshot sourceMetaData = new Store.MetadataSnapshot(Collections.unmodifiableMap(snapshotMetaData), Collections.emptyMap(), 0L);
            StoreFileMetaData restoredSegmentsFile = sourceMetaData.getSegmentsFile();
            if (restoredSegmentsFile == null) {
                throw new IndexShardRestoreFailedException(this.shardId, "Snapshot has no segments file");
            }
            Store.RecoveryDiff diff = sourceMetaData.recoveryDiff(recoveryTargetMetadata);
            for (StoreFileMetaData storeFileMetaData : diff.identical) {
                fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(storeFileMetaData.name());
                this.recoveryState.getIndex().addFileDetail(fileInfo.name(), fileInfo.length(), true);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("[{}] [{}] not_recovering file [{}] from [{}], exists in local store and is same", (Object)this.shardId, (Object)this.snapshotId, (Object)fileInfo.physicalName(), (Object)fileInfo.name());
            }
            for (StoreFileMetaData storeFileMetaData : this.concat(diff)) {
                fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(storeFileMetaData.name());
                filesToRecover.add(fileInfo);
                this.recoveryState.getIndex().addFileDetail(fileInfo.name(), fileInfo.length(), false);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("[{}] [{}] recovering [{}] from [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)fileInfo.physicalName(), (Object)fileInfo.name());
            }
            if (filesToRecover.isEmpty()) {
                logger.trace("[{}] [{}] no files to recover, all exist within the local store", (Object)this.shardId, (Object)this.snapshotId);
            }
            try {
                List<String> deleteIfExistFiles = Arrays.asList(store.directory().listAll());
                for (BlobStoreIndexShardSnapshot.FileInfo fileToRecover : filesToRecover) {
                    String physicalName = fileToRecover.physicalName();
                    if (!deleteIfExistFiles.contains(physicalName)) continue;
                    logger.trace("[{}] [{}] deleting pre-existing file [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)physicalName);
                    store.directory().deleteFile(physicalName);
                }
                this.restoreFiles(filesToRecover, store);
            }
            catch (IOException ex) {
                throw new IndexShardRestoreFailedException(this.shardId, "Failed to recover index", ex);
            }
            try {
                segmentCommitInfos = Lucene.pruneUnreferencedFiles(restoredSegmentsFile.name(), store.directory());
            }
            catch (IOException iOException) {
                throw new IndexShardRestoreFailedException(this.shardId, "Failed to fetch index version after copying it over", iOException);
            }
            this.recoveryState.getIndex().updateVersion(segmentCommitInfos.getVersion());
            try {
                for (String storeFile : store.directory().listAll()) {
                    if (Store.isAutogenerated(storeFile) || snapshotFiles.containPhysicalIndexFile(storeFile)) continue;
                    try {
                        store.deleteQuiet("restore", storeFile);
                        store.directory().deleteFile(storeFile);
                    }
                    catch (IOException e) {
                        logger.warn("[{}] [{}] failed to delete file [{}] during snapshot cleanup", (Object)this.shardId, (Object)this.snapshotId, (Object)storeFile);
                    }
                }
            }
            catch (IOException iOException) {
                logger.warn("[{}] [{}] failed to list directory - some of files might not be deleted", (Object)this.shardId, (Object)this.snapshotId);
            }
        }
        finally {
            store.decRef();
        }
    }

    protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store) throws IOException {
        for (BlobStoreIndexShardSnapshot.FileInfo fileToRecover : filesToRecover) {
            logger.trace("[{}] [{}] restoring file [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)fileToRecover.name());
            this.restoreFile(fileToRecover, store);
        }
    }

    protected abstract InputStream fileInputStream(BlobStoreIndexShardSnapshot.FileInfo var1);

    private Iterable<StoreFileMetaData> concat(Store.RecoveryDiff diff) {
        return Iterables.concat(diff.different, diff.missing);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreFile(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) throws IOException {
        boolean success = false;
        try (InputStream stream = this.fileInputStream(fileInfo);){
            try {
                try (IndexOutput indexOutput = store.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                    int length;
                    byte[] buffer = new byte[this.bufferSize];
                    while ((length = stream.read(buffer)) > 0) {
                        indexOutput.writeBytes(buffer, 0, length);
                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.name(), length);
                    }
                    Store.verify(indexOutput);
                    indexOutput.close();
                    store.directory().sync(Collections.singleton(fileInfo.physicalName()));
                    success = true;
                }
                if (success) return;
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                try {
                    try {
                        store.markStoreCorrupted((IOException)ex);
                        throw ex;
                    }
                    catch (IOException e) {
                        logger.warn("store cannot be marked as corrupted", (Throwable)e);
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    store.deleteQuiet(fileInfo.physicalName());
                    throw throwable;
                }
            }
            store.deleteQuiet(fileInfo.physicalName());
            return;
        }
    }

    private void maybeRecalculateMetadataHash(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store.MetadataSnapshot snapshot) throws IOException {
        StoreFileMetaData metadata;
        if (fileInfo != null && (metadata = snapshot.get(fileInfo.physicalName())) != null && metadata.hash().length > 0 && fileInfo.metadata().hash().length == 0) {
            try (InputStream stream = this.fileInputStream(fileInfo);){
                BytesRefBuilder builder = new BytesRefBuilder();
                Store.MetadataSnapshot.hashFile(builder, stream, fileInfo.length());
                BytesRef hash = fileInfo.metadata().hash();
                assert (hash.length == 0);
                hash.bytes = builder.bytes();
                hash.offset = 0;
                hash.length = builder.length();
            }
        }
    }
}

