/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.querydsl.container.FieldReference;
import org.elasticsearch.xpack.sql.type.DataType;

public class SearchHitFieldRef
extends FieldReference {
    private final String name;
    private final DataType dataType;
    private final boolean docValue;
    private final String hitName;

    public SearchHitFieldRef(String name, DataType dataType, boolean useDocValueInsteadOfSource) {
        this(name, dataType, useDocValueInsteadOfSource, null);
    }

    public SearchHitFieldRef(String name, DataType dataType, boolean useDocValueInsteadOfSource, String hitName) {
        this.name = name;
        this.dataType = dataType;
        this.docValue = useDocValueInsteadOfSource;
        this.hitName = hitName;
    }

    public String hitName() {
        return this.hitName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean useDocValue() {
        return this.docValue;
    }

    @Override
    public void collectFields(SqlSourceBuilder sourceBuilder) {
        if (this.hitName != null) {
            return;
        }
        if (this.docValue) {
            sourceBuilder.addDocField(this.name, this.dataType.format());
        } else {
            sourceBuilder.addSourceField(this.name);
        }
    }

    public String toString() {
        return this.name;
    }
}

