/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.privilege;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesResponse;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportDeletePrivilegesAction
extends HandledTransportAction<DeletePrivilegesRequest, DeletePrivilegesResponse> {
    private final NativePrivilegeStore privilegeStore;

    @Inject
    public TransportDeletePrivilegesAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver resolver, NativePrivilegeStore privilegeStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/privilege/delete", threadPool, transportService, actionFilters, resolver, DeletePrivilegesRequest::new);
        this.privilegeStore = privilegeStore;
    }

    protected void doExecute(DeletePrivilegesRequest request, ActionListener<DeletePrivilegesResponse> listener) {
        if (request.privileges() == null || request.privileges().length == 0) {
            listener.onResponse((Object)new DeletePrivilegesResponse(Collections.emptyList()));
            return;
        }
        HashSet names = Sets.newHashSet((Object[])request.privileges());
        this.privilegeStore.deletePrivileges(request.application(), names, request.getRefreshPolicy(), (ActionListener<Map<String, List<String>>>)ActionListener.wrap(privileges -> listener.onResponse((Object)new DeletePrivilegesResponse((Collection)privileges.getOrDefault(request.application(), Collections.emptyList()))), arg_0 -> listener.onFailure(arg_0)));
    }
}

