/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingResponse;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class TransportDeleteRoleMappingAction
extends HandledTransportAction<DeleteRoleMappingRequest, DeleteRoleMappingResponse> {
    private final NativeRoleMappingStore roleMappingStore;

    @Inject
    public TransportDeleteRoleMappingAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportService transportService, NativeRoleMappingStore roleMappingStore) {
        super(settings, "cluster:admin/xpack/security/role_mapping/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteRoleMappingRequest::new);
        this.roleMappingStore = roleMappingStore;
    }

    protected void doExecute(DeleteRoleMappingRequest request, final ActionListener<DeleteRoleMappingResponse> listener) {
        this.roleMappingStore.deleteRoleMapping(request, new ActionListener<Boolean>(){

            public void onResponse(Boolean found) {
                listener.onResponse((Object)new DeleteRoleMappingResponse(found.booleanValue()));
            }

            public void onFailure(Exception t) {
                listener.onFailure(t);
            }
        });
    }
}

