/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.Pre67PutFollow;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public final class TransportPutFollowAction
extends TransportMasterNodeAction<PutFollowAction.Request, PutFollowAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutFollowAction.class);
    private final Client client;
    private final RestoreService restoreService;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final ActiveShardsObserver activeShardsObserver;
    private final Pre67PutFollow pre67PutFollow;

    @Inject
    public TransportPutFollowAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, RestoreService restoreService, AllocationService allocationService, CcrLicenseChecker ccrLicenseChecker) {
        super(settings, "indices:admin/xpack/ccr/put_follow", transportService, clusterService, threadPool, actionFilters, PutFollowAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.restoreService = restoreService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.pre67PutFollow = new Pre67PutFollow(client, clusterService, allocationService, this.activeShardsObserver);
    }

    protected String executor() {
        return "same";
    }

    protected PutFollowAction.Response newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    protected PutFollowAction.Response read(StreamInput in) throws IOException {
        return new PutFollowAction.Response(in);
    }

    protected void masterOperation(PutFollowAction.Request request, ClusterState state, ActionListener<PutFollowAction.Response> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        String remoteCluster = request.getRemoteCluster();
        this.client.getRemoteClusterClient(remoteCluster);
        String leaderIndex = request.getLeaderIndex();
        Version minNodeVersion = state.getNodes().getMinNodeVersion();
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterStateLeaderIndexMetadataAndHistoryUUIDs(this.client, remoteCluster, true, leaderIndex, arg_0 -> listener.onFailure(arg_0), (historyUUID, metaDataTuple) -> this.createFollowerIndex((Tuple<ClusterState, IndexMetaData>)metaDataTuple, (String[])historyUUID, request, listener, minNodeVersion));
    }

    private void createFollowerIndex(Tuple<ClusterState, IndexMetaData> metaDataTuple, String[] historyUUID, final PutFollowAction.Request request, final ActionListener<PutFollowAction.Response> listener, Version localClusterMinNodeVersion) {
        boolean pre67CompatibilityMode;
        IndexMetaData leaderIndexMetaData = (IndexMetaData)metaDataTuple.v2();
        if (leaderIndexMetaData == null) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] does not exist"));
            return;
        }
        if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(leaderIndexMetaData.getSettings())).booleanValue()) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] does not have soft deletes enabled. soft deletes must be enabled when the index is created by setting " + IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey() + " to true"));
            return;
        }
        boolean bl = pre67CompatibilityMode = localClusterMinNodeVersion.before(Version.V_6_7_0) || ((ClusterState)metaDataTuple.v1()).getNodes().getMinNodeVersion().before(Version.V_6_7_0);
        if (pre67CompatibilityMode) {
            logger.debug("Pre-6.7 nodes present in local/remote cluster. Cannot bootstrap from remote. Creating empty follower index [{}] and initiating following [{}, {}].", (Object)request.getFollowerIndex(), (Object)request.getRemoteCluster(), (Object)request.getLeaderIndex());
            this.pre67PutFollow.doPre67PutFollow(request, leaderIndexMetaData, historyUUID, listener);
        } else {
            Settings.Builder settingsBuilder = Settings.builder().put("index.provided_name", request.getFollowerIndex()).put(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey(), true);
            String leaderClusterRepoName = "_ccr_" + request.getRemoteCluster();
            final RestoreSnapshotRequest restoreRequest = ((RestoreSnapshotRequest)new RestoreSnapshotRequest(leaderClusterRepoName, "_latest_").indices(new String[]{request.getLeaderIndex()}).indicesOptions(request.indicesOptions()).renamePattern("^(.*)$").renameReplacement(request.getFollowerIndex()).masterNodeTimeout(request.masterNodeTimeout())).indexSettings(settingsBuilder);
            final Client clientWithHeaders = CcrLicenseChecker.wrapClient(this.client, this.threadPool.getThreadContext().getHeaders());
            this.threadPool.executor("snapshot").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                protected void doRun() throws Exception {
                    TransportPutFollowAction.this.restoreService.restoreSnapshot(restoreRequest, (ActionListener)new ActionListener<RestoreService.RestoreCompletionResponse>(){

                        public void onResponse(RestoreService.RestoreCompletionResponse response) {
                            TransportPutFollowAction.this.afterRestoreStarted(clientWithHeaders, request, (ActionListener<PutFollowAction.Response>)listener, response);
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    });
                }
            });
        }
    }

    private void afterRestoreStarted(final Client clientWithHeaders, final PutFollowAction.Request request, ActionListener<PutFollowAction.Response> originalListener, RestoreService.RestoreCompletionResponse response) {
        ActionListener<PutFollowAction.Response> listener;
        if (ActiveShardCount.NONE.equals((Object)request.waitForActiveShards())) {
            originalListener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            listener = new ActionListener<PutFollowAction.Response>(){

                public void onResponse(PutFollowAction.Response response) {
                    logger.debug("put follow {} completed with {}", (Object)request, (Object)response);
                }

                public void onFailure(Exception e) {
                    logger.debug(() -> new ParameterizedMessage("put follow {} failed during the restore process", (Object)request), (Throwable)e);
                }
            };
        } else {
            listener = originalListener;
        }
        RestoreClusterStateListener.createAndRegisterListener((ClusterService)this.clusterService, (RestoreService.RestoreCompletionResponse)response, (ActionListener)new ActionListener<RestoreSnapshotResponse>(){

            public void onResponse(RestoreSnapshotResponse restoreSnapshotResponse) {
                RestoreInfo restoreInfo = restoreSnapshotResponse.getRestoreInfo();
                if (restoreInfo == null) {
                    listener.onResponse((Object)new PutFollowAction.Response(true, false, false));
                } else if (restoreInfo.failedShards() == 0) {
                    TransportPutFollowAction.this.initiateFollowing(clientWithHeaders, request, (ActionListener<PutFollowAction.Response>)listener);
                } else {
                    assert (restoreInfo.failedShards() > 0) : "Should have failed shards";
                    listener.onResponse((Object)new PutFollowAction.Response(true, false, false));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void initiateFollowing(Client client, PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        assert (request.waitForActiveShards() != ActiveShardCount.DEFAULT) : "PutFollowAction does not support DEFAULT.";
        FollowParameters parameters = request.getParameters();
        ResumeFollowAction.Request resumeFollowRequest = new ResumeFollowAction.Request();
        resumeFollowRequest.setFollowerIndex(request.getFollowerIndex());
        resumeFollowRequest.setParameters(new FollowParameters(parameters));
        client.execute((Action)ResumeFollowAction.INSTANCE, (ActionRequest)resumeFollowRequest, ActionListener.wrap(r -> this.activeShardsObserver.waitForActiveShards(new String[]{request.getFollowerIndex()}, request.waitForActiveShards(), request.timeout(), result -> listener.onResponse((Object)new PutFollowAction.Response(true, result.booleanValue(), r.isAcknowledged())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(PutFollowAction.Request request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getFollowerIndex());
    }
}

