/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.process.logging.CppLogMessageHandler;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeController {
    private static final Logger LOGGER = LogManager.getLogger(NativeController.class);
    private static final String CONTROLLER = "controller";
    private static final Duration CONTROLLER_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private static final String START_COMMAND = "start";
    private static final String KILL_COMMAND = "kill";
    public static final Map<String, Object> UNKNOWN_NATIVE_CODE_INFO;
    private final CppLogMessageHandler cppLogHandler;
    private final OutputStream commandStream;

    NativeController(Environment env, NamedPipeHelper namedPipeHelper) throws IOException {
        ProcessPipes processPipes = new ProcessPipes(env, namedPipeHelper, CONTROLLER, null, true, true, false, false, false, false);
        processPipes.connectStreams(CONTROLLER_CONNECT_TIMEOUT);
        this.cppLogHandler = new CppLogMessageHandler(null, processPipes.getLogStream().get());
        this.commandStream = new BufferedOutputStream(processPipes.getCommandStream().get());
    }

    void tailLogsInThread() {
        Thread logTailThread = new Thread(() -> {
            try {
                this.cppLogHandler.tailStream();
                this.cppLogHandler.close();
            }
            catch (IOException e) {
                LOGGER.error("Error tailing C++ controller logs", (Throwable)e);
            }
            LOGGER.info("Native controller process has stopped - no new native processes can be started");
        }, "ml-cpp-log-tail-thread");
        logTailThread.setDaemon(true);
        logTailThread.start();
    }

    public long getPid() throws TimeoutException {
        return this.cppLogHandler.getPid(CONTROLLER_CONNECT_TIMEOUT);
    }

    public Map<String, Object> getNativeCodeInfo() throws TimeoutException {
        return this.cppLogHandler.getNativeCodeInfo(CONTROLLER_CONNECT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(List<String> command) throws IOException {
        if (command.isEmpty()) {
            throw new IllegalArgumentException("Cannot start process: no command supplied");
        }
        for (String arg : command) {
            if (arg.contains("\t")) {
                throw new IllegalArgumentException("argument contains a tab character: " + arg + " in " + command);
            }
            if (!arg.contains("\n")) continue;
            throw new IllegalArgumentException("argument contains a newline character: " + arg + " in " + command);
        }
        if (this.cppLogHandler.hasLogStreamEnded()) {
            String msg = "Cannot start process [" + command.get(0) + "]: native controller process has stopped";
            LOGGER.error(msg);
            throw new ElasticsearchException(msg, new Object[0]);
        }
        OutputStream outputStream = this.commandStream;
        synchronized (outputStream) {
            LOGGER.debug("Starting process with command: " + command);
            this.commandStream.write(START_COMMAND.getBytes(StandardCharsets.UTF_8));
            for (String arg : command) {
                this.commandStream.write(9);
                this.commandStream.write(arg.getBytes(StandardCharsets.UTF_8));
            }
            this.commandStream.write(10);
            this.commandStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(long pid) throws TimeoutException, IOException {
        if (pid <= 0L) {
            throw new IllegalArgumentException("invalid PID to kill: " + pid);
        }
        if (pid == this.getPid()) {
            throw new IllegalArgumentException("native controller will not kill self: " + pid);
        }
        if (this.cppLogHandler.hasLogStreamEnded()) {
            String msg = "Cannot kill process with PID [" + pid + "]: native controller process has stopped";
            LOGGER.error(msg);
            throw new ElasticsearchException(msg, new Object[0]);
        }
        OutputStream outputStream = this.commandStream;
        synchronized (outputStream) {
            LOGGER.debug("Killing process with PID: " + pid);
            this.commandStream.write(KILL_COMMAND.getBytes(StandardCharsets.UTF_8));
            this.commandStream.write(9);
            this.commandStream.write(Long.toString(pid).getBytes(StandardCharsets.UTF_8));
            this.commandStream.write(10);
            this.commandStream.flush();
        }
    }

    public void stop() throws IOException {
        this.commandStream.close();
    }

    static {
        HashMap<String, String> unknownInfo = new HashMap<String, String>(2);
        unknownInfo.put("version", "N/A");
        unknownInfo.put("build_hash", "N/A");
        UNKNOWN_NATIVE_CODE_INFO = Collections.unmodifiableMap(unknownInfo);
    }
}

