/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public class VersionHttpResource
extends HttpResource {
    private static final Logger logger = LogManager.getLogger(VersionHttpResource.class);
    private final Version minimumVersion;

    public VersionHttpResource(String resourceOwnerName, Version minimumVersion) {
        super(resourceOwnerName);
        this.minimumVersion = Objects.requireNonNull(minimumVersion);
    }

    @Override
    protected void doCheckAndPublish(RestClient client, final ActionListener<Boolean> listener) {
        logger.trace("checking [{}] to ensure that it supports the minimum version [{}]", (Object)this.resourceOwnerName, (Object)this.minimumVersion);
        Request request = new Request("GET", "/");
        request.addParameter("filter_path", "version.number");
        client.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    listener.onResponse((Object)VersionHttpResource.this.validateVersion(response));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception exception) {
                logger.error(() -> new ParameterizedMessage("failed to verify minimum version [{}] on the [{}] monitoring cluster", (Object)VersionHttpResource.this.minimumVersion, (Object)VersionHttpResource.this.resourceOwnerName), (Throwable)exception);
                listener.onFailure(exception);
            }
        });
    }

    private boolean validateVersion(Response response) throws IOException {
        Map map = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (InputStream)response.getEntity().getContent(), (boolean)false);
        String versionNumber = (String)((Map)map.get("version")).get("number");
        Version version = Version.fromString((String)versionNumber);
        if (version.onOrAfter(this.minimumVersion)) {
            logger.debug("version [{}] >= [{}] and supported for [{}]", (Object)version, (Object)this.minimumVersion, (Object)this.resourceOwnerName);
            return true;
        }
        logger.error("version [{}] < [{}] and NOT supported for [{}]", (Object)version, (Object)this.minimumVersion, (Object)this.resourceOwnerName);
        return false;
    }
}

