/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ValuedAIObject;
import org.w3c.dom.Element;

public class TileImprovementPlan
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(TileImprovementPlan.class.getName());
    private TileImprovementType type;
    private Tile target;
    private AIUnit pioneer = null;
    private static final String PIONEER_TAG = "pioneer";
    private static final String TARGET_TAG = "target";
    private static final String TYPE_TAG = "type";

    public TileImprovementPlan(AIMain aiMain, String id) throws XMLStreamException {
        super(aiMain, id);
        this.type = null;
        this.target = null;
        this.pioneer = null;
    }

    public TileImprovementPlan(AIMain aiMain, Tile target, TileImprovementType type, int value) {
        super(aiMain, TileImprovementPlan.getXMLElementTagName() + ":" + aiMain.getNextId());
        this.target = target;
        this.type = type;
        this.pioneer = null;
        this.setValue(value);
        this.uninitialized = this.getType() == null || this.getTarget() == null;
    }

    public TileImprovementPlan(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.getType() == null || this.getTarget() == null;
    }

    public TileImprovementPlan(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.getType() == null || this.getTarget() == null;
    }

    public final AIUnit getPioneer() {
        return this.pioneer;
    }

    public final void setPioneer(AIUnit pioneer) {
        this.pioneer = pioneer;
    }

    public final TileImprovementType getType() {
        return this.type;
    }

    public final void setType(TileImprovementType type) {
        this.type = type;
    }

    public final Tile getTarget() {
        return this.target;
    }

    public static TileImprovementType getBestTileImprovementType(Tile tile, GoodsType goodsType) {
        int bestValue = 0;
        TileImprovementType bestType = null;
        for (TileImprovementType impType : tile.getSpecification().getTileImprovementTypeList()) {
            int value;
            if (impType.isNatural() || !impType.isTileTypeAllowed(tile.getType()) || impType.getExpendedAmount() > 1 || tile.getTileImprovement(impType) != null || (value = impType.getImprovementValue(tile, goodsType)) <= bestValue) continue;
            bestValue = value;
            bestType = impType;
        }
        return bestType;
    }

    public boolean update(GoodsType goodsType) {
        TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(this.target, goodsType);
        if (type == null) {
            return false;
        }
        this.setType(type);
        this.setValue(type.getImprovementValue(this.target, goodsType));
        return true;
    }

    public boolean isComplete() {
        return this.target != null && this.target.hasTileImprovement(this.getType());
    }

    public boolean validate() {
        if (this.type == null) {
            logger.warning("Removing typeless TileImprovementPlan");
            this.dispose();
            return false;
        }
        if (this.target == null) {
            logger.warning("Removing targetless TileImprovementPlan");
            this.dispose();
            return false;
        }
        if (this.getPioneer() != null && (this.getPioneer().getUnit() == null || this.getPioneer().getUnit().isDisposed())) {
            logger.warning("Clearing broken pioneer for TileImprovementPlan");
            this.setPioneer(null);
        }
        return true;
    }

    @Override
    public void dispose() {
        this.pioneer = null;
        super.dispose();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.pioneer != null) {
            result = Math.min(result, this.pioneer.checkIntegrity(fix));
        }
        if (this.type == null || this.target == null) {
            result = -1;
        }
        return result;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.validate()) {
            this.toXML(xw, this.getXMLTagName());
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TYPE_TAG, this.type);
        xw.writeAttribute(TARGET_TAG, this.target);
        if (this.pioneer != null && this.pioneer.checkIntegrity(false) > 0) {
            xw.writeAttribute(PIONEER_TAG, this.pioneer);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        Specification spec = this.getSpecification();
        this.type = xr.getType(spec, TYPE_TAG, TileImprovementType.class, null);
        this.pioneer = xr.hasAttribute(PIONEER_TAG) ? xr.makeAIObject(aiMain, PIONEER_TAG, AIUnit.class, null, true) : null;
        this.target = xr.getAttribute(this.getGame(), TARGET_TAG, Tile.class, (Tile)null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        if (this.type != null && this.target != null) {
            this.uninitialized = false;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" ").append(this.type == null ? "null" : this.type.getSuffix()).append(" at ").append(this.target == null ? "null" : this.target.toShortString()).append("/").append(this.getValue()).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TileImprovementPlan.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tileImprovementPlan";
    }
}

