/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyConstraintFactoryInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.notations.DependencyConstraintNotationParser;
import org.gradle.api.model.ObjectFactory;

public class DefaultDependencyConstraintFactory
implements DependencyConstraintFactoryInternal {
    private final ObjectFactory objectFactory;
    private final DependencyConstraintNotationParser dependencyConstraintNotationParser;
    private final ImmutableAttributesFactory attributesFactory;

    public DefaultDependencyConstraintFactory(ObjectFactory objectFactory, DependencyConstraintNotationParser dependencyConstraintNotationParser, ImmutableAttributesFactory attributesFactory) {
        this.objectFactory = objectFactory;
        this.dependencyConstraintNotationParser = dependencyConstraintNotationParser;
        this.attributesFactory = attributesFactory;
    }

    public DependencyConstraint createDependencyConstraint(Object dependencyNotation) {
        DependencyConstraint dependencyConstraint = (DependencyConstraint)this.dependencyConstraintNotationParser.getNotationParser().parseNotation(dependencyNotation);
        this.injectServices(dependencyConstraint);
        return dependencyConstraint;
    }

    private void injectServices(DependencyConstraint dependency) {
        if (dependency instanceof DefaultDependencyConstraint) {
            ((DefaultDependencyConstraint)dependency).setAttributesFactory(this.attributesFactory);
        }
    }

    public DependencyConstraint create(CharSequence dependencyNotation) {
        DependencyConstraint dependencyConstraint = (DependencyConstraint)this.dependencyConstraintNotationParser.getStringNotationParser().parseNotation((Object)dependencyNotation.toString());
        this.injectServices(dependencyConstraint);
        return dependencyConstraint;
    }

    public DependencyConstraint create(@Nullable String group, String name, @Nullable String version) {
        DefaultDependencyConstraint dependencyConstraint = (DefaultDependencyConstraint)this.objectFactory.newInstance(DefaultDependencyConstraint.class, new Object[]{group, name, version});
        this.injectServices((DependencyConstraint)dependencyConstraint);
        return dependencyConstraint;
    }

    public DependencyConstraint create(MinimalExternalModuleDependency dependency) {
        DependencyConstraint dependencyConstraint = (DependencyConstraint)this.dependencyConstraintNotationParser.getMinimalExternalModuleDependencyNotationParser().parseNotation((Object)dependency);
        this.injectServices(dependencyConstraint);
        return dependencyConstraint;
    }

    public DependencyConstraint create(ProjectDependency project) {
        DependencyConstraint dependencyConstraint = (DependencyConstraint)this.dependencyConstraintNotationParser.getProjectDependencyNotationParser().parseNotation((Object)project);
        this.injectServices(dependencyConstraint);
        return dependencyConstraint;
    }
}

