/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import com.google.common.util.concurrent.Callables;
import groovy.lang.Closure;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;

public class Signature
extends AbstractPublishArtifact {
    private SignatureSpec signatureSpec;
    private Buildable source;
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private Callable<File> toSignGenerator;
    private Callable<String> classifierGenerator;
    @Nullable
    private Callable<String> nameGenerator;

    public Signature(PublishArtifact toSign, SignatureSpec signatureSpec, Object ... tasks) {
        this((Buildable)toSign, () -> ((PublishArtifact)toSign).getFile(), () -> ((PublishArtifact)toSign).getClassifier(), () -> ((PublishArtifact)toSign).getName(), signatureSpec, tasks);
    }

    Signature(Buildable source, Callable<File> toSign, Callable<String> classifier, Callable<String> name, SignatureSpec signatureSpec, Object ... tasks) {
        super(DefaultTaskDependencyFactory.withNoAssociatedProject(), tasks);
        this.init(toSign, classifier, name, signatureSpec);
        this.source = source;
    }

    public Signature(File toSign, SignatureSpec signatureSpec, Object ... tasks) {
        super(DefaultTaskDependencyFactory.withNoAssociatedProject(), tasks);
        this.init(Callables.returning((Object)toSign), null, null, signatureSpec);
    }

    public Signature(File toSign, String classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(DefaultTaskDependencyFactory.withNoAssociatedProject(), tasks);
        this.init(Callables.returning((Object)toSign), Callables.returning((Object)classifier), null, signatureSpec);
    }

    public Signature(Closure<File> toSign, Closure<String> classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(DefaultTaskDependencyFactory.withNoAssociatedProject(), tasks);
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.signatureSpec = signatureSpec;
    }

    public Signature(Callable<File> toSign, Callable<String> classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(DefaultTaskDependencyFactory.withNoAssociatedProject(), tasks);
        this.init(toSign, classifier, null, signatureSpec);
    }

    private void init(Callable<File> toSign, Callable<String> classifier, @Nullable Callable<String> name, SignatureSpec signatureSpec) {
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.nameGenerator = name;
        this.signatureSpec = signatureSpec;
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @ToBeReplacedByLazyProperty
    public File getToSign() {
        return (File)UncheckedException.uncheckedCall(this.toSignGenerator);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getName() {
        return this.name != null ? this.name : this.defaultName();
    }

    @Nullable
    private String defaultName() {
        return this.nameGenerator != null ? (String)UncheckedException.uncheckedCall(this.nameGenerator) : this.fileName();
    }

    @Nullable
    private String fileName() {
        File file = this.getFile();
        return file != null ? file.getName() : null;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getExtension() {
        return this.extension != null ? this.extension : this.signatureTypeExtension();
    }

    @Nullable
    private String signatureTypeExtension() {
        SignatureType signatureType = this.getSignatureType();
        return signatureType != null ? signatureType.getExtension() : null;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getType() {
        return this.type != null ? this.type : this.defaultType();
    }

    @Nullable
    private String defaultType() {
        File toSign = this.getToSign();
        SignatureType signatureType = this.getSignatureType();
        return toSign != null && signatureType != null ? signatureType.combinedExtension(toSign) : null;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getClassifier() {
        return this.classifier != null ? this.classifier : this.defaultClassifier();
    }

    private String defaultClassifier() {
        return this.classifierGenerator == null ? null : (String)UncheckedException.uncheckedCall(this.classifierGenerator);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Date getDate() {
        return this.date != null ? this.date : this.defaultDate();
    }

    @Nullable
    private Date defaultDate() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        long modified = file.lastModified();
        if (modified == 0L) {
            return null;
        }
        return new Date(modified);
    }

    @OutputFile
    @ToBeReplacedByLazyProperty
    public File getFile() {
        File toSign = this.getToSign();
        SignatureType signatureType = this.getSignatureType();
        return toSign != null && signatureType != null ? signatureType.fileFor(toSign) : null;
    }

    @Internal(value="already tracked as part of the Sign task")
    @ToBeReplacedByLazyProperty
    public Signatory getSignatory() {
        return this.signatureSpec.getSignatory();
    }

    @Internal(value="already tracked as part of the Sign task")
    @ToBeReplacedByLazyProperty
    public SignatureType getSignatureType() {
        return this.signatureSpec.getSignatureType();
    }

    public void setSignatureSpec(SignatureSpec signatureSpec) {
        this.signatureSpec = signatureSpec;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public SignatureSpec getSignatureSpec() {
        return this.signatureSpec;
    }

    @Internal
    Buildable getSource() {
        return this.source;
    }

    @Internal
    public TaskDependency getBuildDependencies() {
        return super.getBuildDependencies();
    }

    public boolean shouldBePublished() {
        return true;
    }

    public void generate() {
        Generator generator = this.getGenerator();
        if (generator == null) {
            return;
        }
        generator.generate();
    }

    @Nullable
    Generator getGenerator() {
        File toSign = this.getToSign();
        if (toSign == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature as the file to sign has not been specified");
            }
            return null;
        }
        Signatory signatory = this.getSignatory();
        if (signatory == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature for '" + toSign + "' as no signatory is available to sign");
            }
            return null;
        }
        SignatureType signatureType = this.getSignatureType();
        if (signatureType == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature for '" + toSign + "' as no signature type has been configured");
            }
            return null;
        }
        return new Generator(signatureType, signatory, toSign);
    }

    @Incubating
    public static class Generator {
        private final SignatureType signatureType;
        private final Signatory signatory;
        private final File toSign;

        public Generator(SignatureType signatureType, Signatory signatory, File toSign) {
            this.signatureType = signatureType;
            this.signatory = signatory;
            this.toSign = toSign;
        }

        @PathSensitive(value=PathSensitivity.NONE)
        @InputFile
        public File getToSign() {
            return this.toSign;
        }

        @OutputFile
        public File getFile() {
            return this.signatureType.fileFor(this.toSign);
        }

        public void generate() {
            this.signatureType.sign(this.signatory, this.toSign);
        }
    }
}

