/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.Closeable;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ProjectScopeServices;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Project.class})
public class ProjectLifecycleController
implements Closeable {
    private final ServiceRegistry buildServices;
    private final StateTransitionController<State> controller;
    private ProjectInternal project;
    private CloseableServiceRegistry projectScopeServices;

    public ProjectLifecycleController(DisplayName displayName, StateTransitionControllerFactory factory, ServiceRegistry buildServices) {
        this.buildServices = buildServices;
        this.controller = factory.newController(displayName, State.NotCreated);
    }

    public boolean isCreated() {
        return this.project != null;
    }

    public void createMutableModel(DefaultProjectDescriptor descriptor, BuildState build, ProjectState owner, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope, IProjectFactory projectFactory) {
        this.controller.transition(State.NotCreated, State.Created, () -> {
            ProjectState parent = owner.getBuildParent();
            ProjectInternal parentModel = parent == null ? null : parent.getMutableModel();
            ServiceRegistryFactory serviceRegistryFactory = domainObject -> {
                Factory loggingManagerFactory = this.buildServices.getFactory(LoggingManagerInternal.class);
                this.projectScopeServices = ProjectScopeServices.create(this.buildServices, (ProjectInternal)domainObject, (Factory<LoggingManagerInternal>)loggingManagerFactory);
                return this.projectScopeServices;
            };
            this.project = projectFactory.createProject(build.getMutableModel(), descriptor, owner, parentModel, serviceRegistryFactory, selfClassLoaderScope, baseClassLoaderScope);
        });
    }

    public ProjectInternal getMutableModel() {
        this.controller.assertInStateOrLater(State.Created);
        return this.project;
    }

    public void ensureSelfConfigured() {
        this.controller.maybeTransitionIfNotCurrentlyTransitioning(State.Created, State.Configured, () -> this.project.evaluateUnchecked());
    }

    public void ensureTasksDiscovered() {
        this.ensureSelfConfigured();
        this.project.getTasks().discoverTasks();
        this.project.bindAllModelRules();
    }

    @Override
    public void close() {
        if (this.project != null) {
            try {
                this.projectScopeServices.close();
            }
            finally {
                this.project = null;
                this.projectScopeServices = null;
            }
        }
    }

    private static enum State implements StateTransitionController.State
    {
        NotCreated,
        Created,
        Configured;

    }
}

