/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util.barcode;

import it.unimi.dsi.lang.MutableString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.util.barcode.BarcodeMatcher;
import org.campagnelab.goby.util.barcode.BarcodeMatcherResult;
import org.campagnelab.goby.util.barcode.OverlapResult;

public class PostBarcodeMatcher
extends BarcodeMatcher {
    private static final Log LOG = LogFactory.getLog(PostBarcodeMatcher.class);

    public PostBarcodeMatcher(String[] barcodesStrArray, int barcodeLength, int allowedMismatches) {
        this.init(barcodesStrArray, barcodeLength, allowedMismatches);
    }

    @Override
    BarcodeMatcherResult bestMatch(MutableString sequence, MutableString toFind, int barcodeIndex, int minMatchLength) {
        OverlapResult overlapResult = this.overlapPortion(sequence, toFind);
        int leastNumDiffs = Integer.MAX_VALUE;
        int leastNumDiffsBarcodeStartPos = 0;
        int pos = 0;
        int matchLength = overlapResult.length;
        while (matchLength >= minMatchLength) {
            int numDiffs = this.numDifferences(sequence, toFind, overlapResult.start + pos, 0, matchLength);
            if (numDiffs <= leastNumDiffs) {
                leastNumDiffs = numDiffs;
                leastNumDiffsBarcodeStartPos = sequence.length() - matchLength;
                if (leastNumDiffs == 0) break;
            }
            --matchLength;
            ++pos;
        }
        int preMatchSequenceLength = sequence.length();
        int barcodeMatchedLength = preMatchSequenceLength - leastNumDiffsBarcodeStartPos;
        int actualSequenceLength = preMatchSequenceLength - barcodeMatchedLength;
        return new BarcodeMatcherResult(barcodeIndex, leastNumDiffs, 0, actualSequenceLength, leastNumDiffsBarcodeStartPos, barcodeMatchedLength);
    }

    OverlapResult overlapPortion(MutableString sequence, MutableString toFind) {
        int toFindLength;
        OverlapResult overlapResult = new OverlapResult();
        int sequenceLength = sequence.length();
        if (sequenceLength >= (toFindLength = toFind.length())) {
            overlapResult.start = sequenceLength - toFindLength;
            overlapResult.length = toFindLength;
        } else if (sequenceLength < toFindLength) {
            overlapResult.start = 0;
            overlapResult.length = sequenceLength;
        }
        return overlapResult;
    }
}

